/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.web.javaee.internal.providers.generators;

import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.Reference;
import com.ibm.etools.references.services.providers.RefactoringGeneratorParameters;
import com.ibm.etools.references.web.AbstractWebProvider;
import com.ibm.etools.references.web.URIUtil;
import com.ibm.etools.references.web.javaee.taglib.WebEEUtil;
import com.ibm.etools.references.web.providers.generators.WebAppRelativeGeneratorProvider;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class WebLinkFullWebAppWebXMLRelativeGeneratorProvider
extends WebAppRelativeGeneratorProvider {
    public List<Reference> generateReferences(ILink link, String referenceType, String transformResult) {
        Reference reference = this.createReference(link, transformResult, referenceType);
        if (reference == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(reference);
    }

    protected IPath getAbsolutePathFromLink(URIUtil.ParsedURI uri, ILink link) {
        IPath absPath = null;
        if (uri.path.startsWith("/")) {
            absPath = this.getWorkspacePathForWebAppRelativeLink(link, uri);
        } else {
            IPath webXmlPath = WebEEUtil.getWebXmlPath(link.getContainer().getResource().getProject());
            webXmlPath = webXmlPath.removeLastSegments(1);
            absPath = webXmlPath.append(uri.path);
        }
        return absPath;
    }

    public String renameReference(RefactoringGeneratorParameters params) {
        String newString = null;
        String noQuotes = AbstractWebProvider.trimQuotes((String)params.transformResult);
        Path targetPath = new Path((String)params.renameParameters.get("web.ref.abs.path.id"));
        if (noQuotes.startsWith("/") || noQuotes.startsWith("\\")) {
            IPath linkPath = WebLinkFullWebAppWebXMLRelativeGeneratorProvider.getWebAppRootRelativePath((IPath)targetPath);
            if (linkPath != null) {
                linkPath = linkPath.makeAbsolute();
                newString = linkPath.toString();
                newString = URIUtil.addURIComponents((String)newString, (IFile)this.getTargetContainer(params), (String)noQuotes);
            }
        } else {
            IPath linkPath = this.getWebXMLRelativePath((IPath)targetPath);
            if (linkPath != null) {
                linkPath = linkPath.makeRelative();
                newString = linkPath.toString();
                newString = URIUtil.addURIComponents((String)newString, (IFile)this.getTargetContainer(params), (String)noQuotes);
            }
        }
        return newString;
    }

    protected IPath getWebXMLRelativePath(IPath targetPath) {
        IFile targetFile;
        IPath linkPath = null;
        if (targetPath != null && (targetFile = ResourcesPlugin.getWorkspace().getRoot().getFile(targetPath)) != null) {
            IPath webXmlPath = WebEEUtil.getWebXmlPath(targetFile.getProject());
            int matchingFirstSegments = targetPath.matchingFirstSegments(webXmlPath);
            linkPath = targetPath.removeFirstSegments(matchingFirstSegments);
        }
        return linkPath;
    }
}

