/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.web.javaee.internal.providers.detectors;

import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.IResolvedReference;
import com.ibm.etools.references.management.ReferenceElementFactory;
import com.ibm.etools.references.services.providers.ILinkDetectorProvider;
import com.ibm.etools.references.services.providers.SharedModel;
import com.ibm.etools.references.web.AbstractWebProvider;
import com.ibm.etools.references.web.CreateLinkParameter;
import com.ibm.etools.references.web.javaee.taglib.HTMLTaglibDirectiveUtil;
import com.ibm.etools.references.web.javaee.taglib.TaglibDirective;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeIterator;

public class JspLinkDetector
extends AbstractWebProvider
implements ILinkDetectorProvider {
    public List<ILink> detectLinks(ReferenceElementFactory factory, SharedModel sharedModel, Set<IResolvedReference> incomingReferences) {
        ArrayList<ILink> links = new ArrayList<ILink>();
        if (sharedModel.getSharedModel() instanceof IDOMModel) {
            IDOMModel model = (IDOMModel)sharedModel.getSharedModel();
            IDOMDocument document = model.getDocument();
            boolean xmlSyntax = HTMLTaglibDirectiveUtil.isJSPDocuments(model);
            if (xmlSyntax) {
                List<Node> v = HTMLTaglibDirectiveUtil.getTaglibDirectiveXML(model);
                for (Node node : v) {
                    ILink taglibLink;
                    TaglibDirective directive = HTMLTaglibDirectiveUtil.getTaglibDirective(node);
                    if (directive == null || (taglibLink = this.createTaglibLink(factory, (IDOMElement)((Attr)node).getOwnerElement(), directive.getPrefix(), (IDOMAttr)node)) == null) continue;
                    links.add(taglibLink);
                }
            }
            NodeIterator iter = ((DocumentTraversal)document).createNodeIterator((Node)document, 1, null, false);
            Node n = iter.nextNode();
            while (n != null) {
                String nodeName = n.getNodeName();
                if (nodeName != null) {
                    ILink link;
                    CreateLinkParameter param;
                    IDOMElement domElement = (IDOMElement)n;
                    IDOMAttr att = null;
                    if (!xmlSyntax && "jsp:directive.taglib".equals(nodeName)) {
                        TaglibDirective directive = HTMLTaglibDirectiveUtil.getTaglibDirective((Node)domElement);
                        if (directive != null) {
                            IDOMAttr uriAttrib = (IDOMAttr)domElement.getAttributeNode("uri");
                            ILink taglibLink = this.createTaglibLink(factory, domElement, directive.getPrefix(), uriAttrib);
                            if (taglibLink != null) {
                                links.add(taglibLink);
                            }
                        }
                    } else if ("bean".equalsIgnoreCase(nodeName)) {
                        att = (IDOMAttr)domElement.getAttributeNode("type");
                        if (att != null) {
                            param = new CreateLinkParameter(factory, domElement, (IDOMNode)att, "javaee.javatype", null);
                            link = AbstractWebProvider.createLink((CreateLinkParameter)param);
                            links.add(link);
                        }
                    } else if ("page".equalsIgnoreCase(nodeName) || "jsp:directive.page".equalsIgnoreCase(nodeName)) {
                        att = (IDOMAttr)domElement.getAttributeNode("extends");
                        if (att != null) {
                            param = new CreateLinkParameter(factory, domElement, (IDOMNode)att, "javaee.javatype", null);
                            link = AbstractWebProvider.createLink((CreateLinkParameter)param);
                            links.add(link);
                        }
                        if ((att = (IDOMAttr)domElement.getAttributeNode("errorPage")) != null) {
                            param = new CreateLinkParameter(factory, domElement, (IDOMNode)att, "web.nocontextroot", null);
                            link = AbstractWebProvider.createLink((CreateLinkParameter)param);
                            links.add(link);
                        }
                    } else if ("jsp:include".equalsIgnoreCase(nodeName) || "jsp:forward".equalsIgnoreCase(nodeName)) {
                        att = (IDOMAttr)domElement.getAttributeNode("page");
                        if (att != null) {
                            param = new CreateLinkParameter(factory, domElement, (IDOMNode)att, "web.nocontextroot", null);
                            link = AbstractWebProvider.createLink((CreateLinkParameter)param);
                            links.add(link);
                        }
                    } else if ("jsp:directive.include".equalsIgnoreCase(nodeName) || "include".equalsIgnoreCase(nodeName)) {
                        att = (IDOMAttr)domElement.getAttributeNode("file");
                        if (att != null) {
                            param = new CreateLinkParameter(factory, domElement, (IDOMNode)att, "web.nocontextroot", null);
                            link = AbstractWebProvider.createLink((CreateLinkParameter)param);
                            links.add(link);
                        }
                    } else if ("jsp:plugin".equalsIgnoreCase(nodeName)) {
                        att = (IDOMAttr)domElement.getAttributeNode("code");
                        if (att != null) {
                            param = new CreateLinkParameter(factory, domElement, (IDOMNode)att, "web.classresource.link", null);
                            link = AbstractWebProvider.createLink((CreateLinkParameter)param);
                            this.addLinkParameters(factory, n, nodeName, "web.classresource.link", link);
                            links.add(link);
                        }
                        if ((att = (IDOMAttr)domElement.getAttributeNode("archive")) != null) {
                            param = new CreateLinkParameter(factory, domElement, (IDOMNode)att, "web.separatedresources.link", null);
                            link = AbstractWebProvider.createLink((CreateLinkParameter)param);
                            this.addLinkParameters(factory, n, nodeName, "web.classresource.link", link);
                            links.add(link);
                        }
                        if ((att = (IDOMAttr)domElement.getAttributeNode("codebase")) != null) {
                            param = new CreateLinkParameter(factory, domElement, (IDOMNode)att, "web.commonlink", null);
                            link = AbstractWebProvider.createLink((CreateLinkParameter)param);
                            links.add(link);
                        }
                    }
                }
                n = iter.nextNode();
            }
        }
        return links;
    }

    private ILink createTaglibLink(ReferenceElementFactory factory, IDOMElement domElement, String prefix, IDOMAttr uriAttrib) {
        CreateLinkParameter param = new CreateLinkParameter(factory, domElement, (IDOMNode)uriAttrib, "javaee.jsp.taglibdirective", prefix);
        return JspLinkDetector.createLink((CreateLinkParameter)param);
    }

    private void addLinkParameters(ReferenceElementFactory factory, Node n, String nName, String linkType, ILink desc) {
        if (linkType == "web.classresource.link" || linkType == "web.separatedresources.link") {
            String codebaseValue = AbstractWebProvider.getAttributeValueForTag((Node)n, (String)nName, (String)"codebase");
            factory.addParam(desc, "param.codebase", codebaseValue);
        }
    }
}

