/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.web.javaee.internal;

import com.ibm.etools.references.InternalAPI;
import com.ibm.etools.references.events.ErrorEvent;
import com.ibm.etools.references.events.IReferenceLifecycleListener;
import com.ibm.etools.references.events.LifecycleEvent;
import com.ibm.etools.references.management.ReferenceManager;
import com.ibm.etools.references.management.SpecializedType;
import com.ibm.etools.references.web.javaee.internal.nls.Messages;
import com.ibm.etools.references.web.javaee.internal.providers.node.JavaNodeProvider;
import com.ibm.etools.references.web.javaee.providers.resolvers.SearchUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class JDTReferenceUpdater
implements IElementChangedListener,
IReferenceLifecycleListener {
    private static AtomicBoolean INSTALLED = new AtomicBoolean();
    private static JDTReferenceUpdater INSTANCE;
    private final AtomicInteger activeCount = new AtomicInteger();
    private final Object SYNC = new Object();

    public static final void install() {
        if (INSTALLED.compareAndSet(false, true)) {
            INSTANCE = new JDTReferenceUpdater();
            JavaCore.addElementChangedListener((IElementChangedListener)INSTANCE);
        }
    }

    public static final void uninstall() {
        if (INSTALLED.compareAndSet(true, false)) {
            INSTANCE.waitUntilDone();
            JavaCore.removeElementChangedListener((IElementChangedListener)INSTANCE);
            INSTANCE = null;
        }
    }

    public void handleLifecycleEvent(List<LifecycleEvent> events) {
        for (LifecycleEvent lifecycleEvent : events) {
            if (LifecycleEvent.Kind.STARTUP.equals((Object)lifecycleEvent.getKind())) {
                JDTReferenceUpdater.install();
                continue;
            }
            if (!LifecycleEvent.Kind.SHUTDOWN.equals((Object)lifecycleEvent.getKind())) continue;
            JDTReferenceUpdater.uninstall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilDone() {
        boolean interrupted = Thread.interrupted();
        while (this.activeCount.get() > 0) {
            Object object = this.SYNC;
            synchronized (object) {
                try {
                    this.SYNC.wait();
                }
                catch (InterruptedException interruptedException) {
                    interrupted = true;
                }
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void elementChanged(ElementChangedEvent event) {
        this.activeCount.incrementAndGet();
        try {
            this.handleEvent(event);
        }
        catch (Throwable throwable) {
            int newCount = this.activeCount.decrementAndGet();
            if (newCount == 0) {
                Object object = this.SYNC;
                synchronized (object) {
                    this.SYNC.notifyAll();
                }
            }
            throw throwable;
        }
        int newCount = this.activeCount.decrementAndGet();
        if (newCount == 0) {
            Object object = this.SYNC;
            synchronized (object) {
                this.SYNC.notifyAll();
            }
        }
    }

    private void handleEvent(ElementChangedEvent event) {
        if (ReferenceManager.getReferenceManager().isSuspended()) {
            return;
        }
        IJavaElementDelta delta = event.getDelta();
        if (delta != null) {
            ArrayList<InternalAPI.LinkDelta> deltas = new ArrayList<InternalAPI.LinkDelta>();
            try {
                HashSet<IJavaProject> triggerClassPaths = new HashSet<IJavaProject>();
                InternalAPI.setExternalReadiness((boolean)false);
                ArrayList<IJavaElementDelta> children = new ArrayList<IJavaElementDelta>();
                children.add(delta);
                while (!children.isEmpty()) {
                    IJavaElementDelta child = (IJavaElementDelta)children.remove(0);
                    ItemReturnType type = this.processItem(child);
                    deltas.addAll(type.deltas);
                    triggerClassPaths.addAll(type.triggerClassPaths);
                    children.addAll(Arrays.asList(child.getAffectedChildren()));
                }
                if (!triggerClassPaths.isEmpty()) {
                    deltas.add(InternalAPI.newLinkDelta((String)Messages.UpdateJavaTypeLinks_status_msg, (SpecializedType)ReferenceManager.getReferenceManager().getLinkType("javaee.javatype.nodeid"), (String)"jdt.link.passthrough", (String)"jdt:", (int)1));
                }
                for (IJavaProject jp : triggerClassPaths) {
                    if (jp == null) continue;
                    ReferenceManager.getReferenceManager().requestTriggeredEnablement(Collections.singleton(jp.getProject()), "javaee.trigger.ClasspathChanges", Collections.emptyMap(), null);
                }
            }
            finally {
                InternalAPI.processLinkDelta(deltas);
                InternalAPI.setExternalReadiness((boolean)true);
            }
        }
    }

    private ItemReturnType processItem(IJavaElementDelta child) {
        ItemReturnType type = new ItemReturnType();
        type.deltas = Collections.emptyList();
        type.triggerClassPaths = Collections.emptySet();
        try {
            IJavaElement element = child.getElement();
            if (element.getElementType() == 2) {
                if ((child.getFlags() & 0x20000) != 0 || (child.getFlags() & 0x200000) != 0) {
                    type.triggerClassPaths = Collections.singleton(element.getJavaProject());
                } else if (child.getKind() == 2) {
                    this.removeLinksForElement(element);
                } else if (child.getKind() == 4 && (child.getFlags() & 0x400) != 0) {
                    this.removeLinksForElement(element);
                }
            } else if (element.getElementType() == 3) {
                if (child.getKind() == 2) {
                    this.removeLinksForElement(element);
                } else if (child.getKind() == 4 && (child.getFlags() & 0x80) != 0) {
                    this.removeLinksForElement(element);
                }
            } else if (element.getElementType() == 4) {
                if (child.getKind() == 2) {
                    this.removeLinksForElement(element);
                } else if (child.getKind() == 1) {
                    ICompilationUnit[] compilationUnits;
                    IPackageFragment frag = (IPackageFragment)element;
                    ICompilationUnit[] iCompilationUnitArray = compilationUnits = frag.getCompilationUnits();
                    int n = compilationUnits.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ICompilationUnit compilationUnit = iCompilationUnitArray[n2];
                        this.addMethodLinksForCU(compilationUnit);
                        ++n2;
                    }
                }
            } else if (element.getElementType() != 7 && element.getElementType() != 9 && element.getElementType() == 5) {
                if (child.getKind() == 2) {
                    ICompilationUnit cu = (ICompilationUnit)child.getElement();
                    boolean ignore = this.shouldIgnore(cu);
                    if (ignore) {
                        return type;
                    }
                    this.removeLinksForElement(element);
                } else if (child.getKind() == 1) {
                    ICompilationUnit cu = (ICompilationUnit)child.getElement();
                    boolean ignore = this.shouldIgnore(cu);
                    if (ignore) {
                        return type;
                    }
                    type.deltas = Collections.singletonList(InternalAPI.newLinkDelta((String)JavaNodeProvider.getFullyQualifiedName(cu), (SpecializedType)ReferenceManager.getReferenceManager().getLinkType("javaee.javatype.nodeid"), (String)"jdt.link.passthrough", (String)SearchUtil.getModelInstanceId((ICompilationUnit)child.getElement()), (int)1));
                } else if (child.getKind() == 4) {
                    boolean updateLinks = true;
                    if ((child.getFlags() & 0x10000) == 65536 && ((ICompilationUnit)element).isWorkingCopy()) {
                        updateLinks = false;
                    }
                    if (updateLinks) {
                        type.deltas = this.addMethodLinksForCU((ICompilationUnit)element);
                    }
                }
            }
        }
        catch (JavaModelException e) {
            if (!e.getJavaModelStatus().isDoesNotExist()) {
                InternalAPI.handleContributionException((String)Messages.errorMsg_ignoring_exception, (String)"com.ibm.etools.references.web.javaee", (Throwable)e, EnumSet.of(ErrorEvent.PresentationHints.LOG));
            }
        }
        catch (Exception e) {
            InternalAPI.handleContributionException((String)Messages.errorMsg_ignoring_exception, (String)"com.ibm.etools.references.web.javaee", (Throwable)e, EnumSet.of(ErrorEvent.PresentationHints.LOG));
        }
        return type;
    }

    private boolean shouldIgnore(ICompilationUnit cu) {
        boolean ignore = cu.isWorkingCopy() ? cu.getOwner() != null : false;
        return ignore;
    }

    private List<InternalAPI.LinkDelta> addMethodLinksForCU(ICompilationUnit unit) throws JavaModelException {
        IType[] types;
        ArrayList<InternalAPI.LinkDelta> deltas = new ArrayList<InternalAPI.LinkDelta>();
        IType[] iTypeArray = types = unit.getAllTypes();
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            deltas.addAll(SearchUtil.syncIndexedTypeMethods(type));
            ++n2;
        }
        return deltas;
    }

    private void removeLinksForElement(IJavaElement element) {
        SearchUtil.removeLinksForJavaElement(element);
    }

    private static class ItemReturnType {
        Set<IJavaProject> triggerClassPaths;
        List<InternalAPI.LinkDelta> deltas;

        private ItemReturnType() {
        }
    }
}

