/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.web.javaee.ui.internal;

import com.ibm.etools.references.StringMatcher;
import com.ibm.etools.references.management.IReferenceElement;
import com.ibm.etools.references.management.Reference;
import com.ibm.etools.references.management.ReferenceManager;
import com.ibm.etools.references.search.DefaultSearchRequestor;
import com.ibm.etools.references.search.SearchEngine;
import com.ibm.etools.references.search.SearchPattern;
import com.ibm.etools.references.search.SearchRequestor;
import com.ibm.etools.references.search.SearchScope;
import com.ibm.etools.references.search.SearchType;
import com.ibm.etools.references.web.javaee.ui.internal.MatchPresentation;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.ui.search.ElementQuerySpecification;
import org.eclipse.jdt.ui.search.IMatchPresentation;
import org.eclipse.jdt.ui.search.IQueryParticipant;
import org.eclipse.jdt.ui.search.ISearchRequestor;
import org.eclipse.jdt.ui.search.PatternQuerySpecification;
import org.eclipse.jdt.ui.search.QuerySpecification;
import org.eclipse.search.ui.text.Match;

public class QueryParticipant
implements IQueryParticipant {
    MatchPresentation presentation = new MatchPresentation();

    public int estimateTicks(QuerySpecification specification) {
        return 250;
    }

    public IMatchPresentation getUIParticipant() {
        return null;
    }

    public void search(ISearchRequestor requestor, QuerySpecification querySpecification, IProgressMonitor monitor) throws CoreException {
        IScopeContext[] lookupOrder;
        IPreferencesService preferencesService = Platform.getPreferencesService();
        boolean enabled = preferencesService.getBoolean("com.ibm.etools.references", "jdtSearchParticipant", true, lookupOrder = new IScopeContext[]{new InstanceScope(), new DefaultScope()});
        if (enabled) {
            if (querySpecification.getLimitTo() == 2) {
                try {
                    ElementQuerySpecification elementQuery;
                    IJavaElement javaElement;
                    if (querySpecification instanceof ElementQuerySpecification && (javaElement = (elementQuery = (ElementQuerySpecification)querySpecification).getElement()) != null) {
                        String typeName = null;
                        IType type = (IType)javaElement.getAncestor(7);
                        if (type != null) {
                            typeName = type.getFullyQualifiedName();
                        }
                        IMethod method = (IMethod)javaElement.getAncestor(9);
                        String methodName = null;
                        if (method != null) {
                            methodName = method.getElementName();
                        }
                        this.doElementSearch(querySpecification, requestor, typeName, methodName, monitor);
                    }
                    if (querySpecification instanceof PatternQuerySpecification) {
                        PatternQuerySpecification patternQuery = (PatternQuerySpecification)querySpecification;
                        if (patternQuery.getSearchFor() == 1) {
                            this.doPatternSearch(querySpecification, requestor, null, patternQuery.getPattern(), monitor);
                        } else if (patternQuery.getSearchFor() == 0) {
                            this.doPatternSearch(querySpecification, requestor, patternQuery.getPattern(), null, monitor);
                        }
                    }
                    if (monitor.isCanceled()) {
                        return;
                    }
                    monitor.worked(1);
                }
                finally {
                    monitor.done();
                }
            }
        } else {
            monitor.done();
        }
    }

    private void doPatternSearch(QuerySpecification query, ISearchRequestor javaReq, String typeName, String methodName, IProgressMonitor monitor) {
        Set<Reference> matches = this.doSearch(query, javaReq, typeName, methodName, monitor);
        this.filterPatternMatches(javaReq, typeName, methodName, matches);
    }

    private void doElementSearch(QuerySpecification query, ISearchRequestor javaReq, String typeName, String methodName, IProgressMonitor monitor) {
        Set<Reference> matches = this.doSearch(query, javaReq, typeName, methodName, monitor);
        this.filterMatches(javaReq, typeName, methodName, matches);
    }

    private Set<Reference> doSearch(QuerySpecification query, ISearchRequestor javaReq, String typeName, String methodName, IProgressMonitor monitor) {
        SearchPattern pattern = null;
        if (methodName != null) {
            pattern = SearchPattern.createPattern((String)"jdt.reference", (SearchType)SearchType.BY_TYPE, (IReferenceElement.ElementType)IReferenceElement.ElementType.REFERENCE, (int)0);
        } else if (typeName != null) {
            pattern = SearchPattern.createPattern((String)"javaee.javatype.nodeid", (SearchType)SearchType.BY_TYPE, (IReferenceElement.ElementType)IReferenceElement.ElementType.REFERENCE, (int)0);
        } else {
            return Collections.emptySet();
        }
        ReferenceManager.getReferenceManager().userInitiatedAccess();
        SearchScope scope = SearchEngine.createWorkspaceScope();
        DefaultSearchRequestor req = new DefaultSearchRequestor();
        new SearchEngine().search(pattern, scope, (SearchRequestor)req, monitor);
        Set matches = req.getMatches();
        Iterator iterator = matches.iterator();
        while (iterator.hasNext()) {
            IPath[] paths;
            Reference r = (Reference)iterator.next();
            if (r.getSource() == null) continue;
            boolean foundMatch = false;
            IPath[] iPathArray = paths = query.getScope().enclosingProjectsAndJars();
            int n = paths.length;
            int n2 = 0;
            while (n2 < n) {
                IPath path = iPathArray[n2];
                if (path.segmentCount() == 1 && path.toString().indexOf("/") == 0 && path.isPrefixOf(r.getSource().getPath())) {
                    foundMatch = true;
                    break;
                }
                ++n2;
            }
            if (foundMatch) continue;
            iterator.remove();
        }
        return matches;
    }

    private void filterMatches(ISearchRequestor javaReq, String typeName, String methodName, Set<Reference> matches) {
        for (Reference reference : matches) {
            String handle;
            if (methodName != null) {
                handle = reference.getParameter("methodName.id");
                if (handle == null || !handle.equals(methodName)) continue;
                javaReq.reportMatch(new Match((Object)reference.getSource().getContainer().getResource(), reference.getFragmentLocation().getOffset() + reference.getSource().getLinkLocation().getOffset(), reference.getFragmentLocation().getLength()));
                continue;
            }
            if (typeName == null || (handle = reference.getParameter("typeName.id")) == null || !handle.equals(typeName)) continue;
            javaReq.reportMatch(new Match((Object)reference.getSource().getContainer().getResource(), reference.getFragmentLocation().getOffset() + reference.getSource().getLinkLocation().getOffset(), reference.getFragmentLocation().getLength()));
        }
    }

    private void filterPatternMatches(ISearchRequestor javaReq, String typeName, String methodName, Set<Reference> matches) {
        String matchPattern;
        String string = matchPattern = methodName != null ? methodName : typeName;
        if (!matchPattern.startsWith("*")) {
            matchPattern = "*" + matchPattern;
        }
        if (!matchPattern.endsWith("*")) {
            matchPattern = String.valueOf(matchPattern) + "*";
        }
        StringMatcher matcher = new StringMatcher(matchPattern);
        for (Reference reference : matches) {
            String handle;
            if (methodName != null) {
                handle = reference.getParameter("methodName.id");
                if (!matcher.match(handle)) continue;
                javaReq.reportMatch(new Match((Object)reference, reference.getFragmentLocation().getOffset() + reference.getSource().getLinkLocation().getOffset(), reference.getFragmentLocation().getLength()));
                continue;
            }
            if (typeName == null || !matcher.match(handle = reference.getParameter("typeName.id"))) continue;
            javaReq.reportMatch(new Match((Object)reference, reference.getFragmentLocation().getOffset() + reference.getSource().getLinkLocation().getOffset(), reference.getFragmentLocation().getLength()));
        }
    }
}

