/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.web.javaee.ui.internal;

import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.Reference;
import com.ibm.etools.references.management.TextRange;
import com.ibm.etools.references.web.javaee.ui.internal.LabelProvider;
import com.ibm.etools.references.web.javaee.ui.internal.nls.Messages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.ui.search.IMatchPresentation;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.FileEditorInput;

public class MatchPresentation
implements IMatchPresentation {
    public ILabelProvider createLabelProvider() {
        return new LabelProvider(PlatformUI.getWorkbench().getDisplay());
    }

    public void showMatch(Match match, int currentOffset, int currentLength, boolean activate) throws PartInitException {
        IFile file;
        Reference ref = (Reference)match.getElement();
        ILink target = ref.getSource();
        IResource resource = target.getContainer().getResource();
        IFile iFile = file = resource.getType() == 1 ? (IFile)resource : null;
        if (file != null) {
            IEditorPart part = null;
            try {
                IEditorDescriptor desc = IDE.getEditorDescriptor((IFile)file);
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                part = page.openEditor((IEditorInput)new FileEditorInput(file), desc.getId());
                if (part != null) {
                    IMarker marker = target.getContainer().getResource().createMarker("org.eclipse.core.resources.textmarker");
                    TextRange location = target.getContextLocation();
                    if (location != null) {
                        marker.setAttribute("charStart", location.getOffset());
                        marker.setAttribute("charEnd", location.getOffset() + location.getLength());
                        IGotoMarker gotom = (IGotoMarker)part.getAdapter(IGotoMarker.class);
                        if (gotom != null) {
                            gotom.gotoMarker(marker);
                        }
                    }
                }
            }
            catch (CoreException e) {
                throw new RuntimeException(Messages.errorMsg_error_showing_match, e);
            }
        }
    }
}

