/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.web.javaee.ui.internal;

import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.IResolvedReference;
import com.ibm.etools.references.search.SearchEngine;
import com.ibm.etools.references.ui.quickfix.ReferenceQuickFix;
import com.ibm.etools.references.web.javaee.ui.internal.nls.Messages;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.ui.actions.OpenNewClassWizardAction;
import org.eclipse.jdt.ui.wizards.NewClassWizardPage;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class JavaTypeOrMethodQuickFix
extends ReferenceQuickFix {
    protected Map<String, Object> run(Set<IResolvedReference> referencesToFix, IProgressMonitor monitor) {
        IResolvedReference resolvedReference = referencesToFix.iterator().next();
        String javaType = null;
        if ("jdt.reference".equals(resolvedReference.getReferenceType())) {
            Assert.isNotNull((Object)resolvedReference.getPrevious());
            resolvedReference = resolvedReference.getPrevious();
            ILink target = resolvedReference.getTarget();
            if (target != null) {
                Collection rrs = target.resolveReference("javaee.javatype.nodeid", SearchEngine.createWorkspaceScope(), null);
                IResolvedReference r = null;
                if (!rrs.isEmpty()) {
                    r = (IResolvedReference)rrs.iterator().next();
                    target = r.getTarget();
                    javaType = target.getName();
                }
            }
            return Collections.emptyMap();
        }
        javaType = resolvedReference.getReference().getParameter("typeName.id");
        String packageFragmentTxt = Signature.getQualifier((String)javaType);
        String className = Signature.getSimpleName((String)javaType);
        IProject project = resolvedReference.getSource().getContainer().getResource().getProject();
        IJavaProject jp = JavaCore.create((IProject)project);
        try {
            IPackageFragmentRoot[] srcFolders = jp.getPackageFragmentRoots();
            if (srcFolders.length > 0) {
                IPackageFragmentRoot srcFolder = srcFolders[0];
                IPackageFragment packageFragment = srcFolder.getPackageFragment(packageFragmentTxt);
                NewClassWizardPage page = new NewClassWizardPage();
                page.init((IStructuredSelection)new StructuredSelection((Object)jp));
                if (packageFragment != null) {
                    page.setPackageFragment(packageFragment, true);
                }
                if (className != null) {
                    page.setTypeName(className, true);
                }
                OpenNewClassWizardAction action = new OpenNewClassWizardAction();
                action.setConfiguredWizardPage(page);
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                action.setShell(shell);
                action.run();
                IType type = page.getCreatedType();
                if (type != null) {
                    HashMap<String, Object> targetDescription = new HashMap<String, Object>();
                    targetDescription.put("typeName.id", type.getFullyQualifiedName());
                    return targetDescription;
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(Messages.errorMsg_problems_performing_quickfix, e);
        }
        return null;
    }

    public String getDescription() {
        return Messages.quickfix_create_a_javatype_or_method;
    }

    public Image getImage() {
        return null;
    }

    public String getLabel() {
        return Messages.quickfix_creates_javatype_or_method;
    }
}

