/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.web.faces.resolvers;

import com.ibm.etools.references.management.BrokenStatus;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.IReferenceElement;
import com.ibm.etools.references.management.IResolvedReference;
import com.ibm.etools.references.management.LinkNode;
import com.ibm.etools.references.management.Reference;
import com.ibm.etools.references.management.ReferenceElementFactory;
import com.ibm.etools.references.management.ReferenceException;
import com.ibm.etools.references.search.DefaultSearchRequestor;
import com.ibm.etools.references.search.SearchEngine;
import com.ibm.etools.references.search.SearchPattern;
import com.ibm.etools.references.search.SearchRequestor;
import com.ibm.etools.references.search.SearchScope;
import com.ibm.etools.references.search.SearchType;
import com.ibm.etools.references.services.providers.CheckedReferenceRename;
import com.ibm.etools.references.services.providers.IReferenceResolverProvider;
import com.ibm.etools.references.services.providers.RefactoringResolverParameters;
import com.ibm.etools.references.web.AbstractWebProvider;
import com.ibm.etools.references.web.faces.FacesLinkUtil;
import com.ibm.etools.references.web.faces.FacesNavigation;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class FacesResolverProvider
implements IReferenceResolverProvider {
    public String createLink(Reference reference, LinkNode<IFile> linkNode) {
        return null;
    }

    public Map<String, Object> renameReference(RefactoringResolverParameters params) {
        return null;
    }

    public IResolvedReference resolveReference(ReferenceElementFactory factory, Reference reference, IResolvedReference previousResult) throws ReferenceException {
        IResolvedReference result = null;
        if ("jsf.simple.vbl".equals(reference.getReferenceType())) {
            Set matches;
            String pathString = reference.getParameter("param_managedbeanname.id");
            DefaultSearchRequestor requestor = new DefaultSearchRequestor();
            if (pathString != null) {
                SearchPattern pattern = SearchPattern.createPattern((String)pathString, (SearchType)SearchType.BY_LINKNAME, (IReferenceElement.ElementType)IReferenceElement.ElementType.LINK, (int)0);
                pattern = SearchPattern.createAndPattern((SearchPattern)pattern, (SearchPattern)SearchPattern.createPattern((String)"jsf.managedbean", (SearchType)SearchType.BY_TYPE, (IReferenceElement.ElementType)IReferenceElement.ElementType.LINK, (int)0));
                SearchScope scope = SearchEngine.createSearchScope((IResource[])new IResource[]{reference.getSource().getContainer().getResource().getProject()});
                NullProgressMonitor m = new NullProgressMonitor();
                new SearchEngine().search(pattern, scope, (SearchRequestor)requestor, (IProgressMonitor)m);
            }
            if ((matches = requestor.getMatches()).size() == 1) {
                ILink resolved = (ILink)matches.iterator().next();
                result = factory.createResolvedReference(BrokenStatus.NOTBROKEN, reference, resolved, null, false);
            } else {
                result = "1".equals(reference.getSource().getParameter("jsf.ignore")) ? factory.createResolvedReference(BrokenStatus.IGNORED, reference, null, "jsf.facesconfig", false) : factory.createResolvedReference(BrokenStatus.BROKEN, reference, null, "jsf.facesconfig", false);
            }
        } else if ("jsf.outcome".equals(reference.getReferenceType())) {
            ILink element;
            int freq;
            String fromView;
            ILink outcomeLink = reference.getSource();
            String outcome = AbstractWebProvider.trimQuotes((String)outcomeLink.getLinkText());
            String action = outcomeLink.getParameter("jsf.param.action");
            if (action != null && action.length() == 0) {
                action = null;
            }
            if ((fromView = outcomeLink.getParameter("jsf.param.fromview")) != null && fromView.length() == 0) {
                fromView = null;
            }
            SearchScope scope = SearchEngine.createSearchScope((IResource[])new IResource[]{outcomeLink.getContainer().getResource().getProject()});
            List<FacesNavigation> navs = FacesLinkUtil.getAllFacesNavigation(scope, null);
            navs = FacesLinkUtil.applicableToFromViews(fromView, navs);
            navs = FacesLinkUtil.applicableToAction(action, navs);
            navs = FacesLinkUtil.applicableToOutcome(outcome, navs);
            HashSet<ILink> outcomes = new HashSet<ILink>();
            for (FacesNavigation facesNavigation : navs) {
                ILink link = facesNavigation.getFromOutcomeLink();
                if (link == null) continue;
                outcomes.add(link);
            }
            ILink target = null;
            if (!outcomes.isEmpty() && (freq = Collections.frequency(outcomes, element = (ILink)outcomes.iterator().next())) == outcomes.size()) {
                target = element;
            }
            result = target != null ? factory.createResolvedReference(BrokenStatus.NOTBROKEN, reference, target, null, false) : factory.createResolvedReference(BrokenStatus.BROKEN, reference, null, "jsf.facesconfig", false);
        }
        return result;
    }

    public String getModelInstanceIdReference(Reference reference) {
        return "jsf.facesconfig";
    }

    public CheckedReferenceRename checkRenameReference(RefactoringResolverParameters params) {
        return new CheckedReferenceRename();
    }
}

