/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.web.faces.internal.providers.generators;

import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.Reference;
import com.ibm.etools.references.services.providers.RefactoringGeneratorParameters;
import com.ibm.etools.references.web.URIUtil;
import com.ibm.etools.references.web.providers.generators.WebLinkGeneratorProvider;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;

public class PageCodeProjectRelativeGeneratorProvider
extends WebLinkGeneratorProvider {
    public List<Reference> generateReferences(ILink link, String referenceType, String transformResult) {
        if ("web.reference.workspacePath".equals(referenceType)) {
            Reference reference = this.createReference(link, transformResult, referenceType);
            if (reference == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(reference);
        }
        return Collections.emptyList();
    }

    public String renameReference(RefactoringGeneratorParameters params) {
        String sPath = (String)params.renameParameters.get("web.ref.abs.path.id");
        Path path = new Path(sPath);
        path = path.removeFirstSegments(1).makeAbsolute();
        return path.toString();
    }

    public IStatus checkRenameReference(RefactoringGeneratorParameters params) {
        return Status.OK_STATUS;
    }

    protected IPath getAbsolutePathFromLink(URIUtil.ParsedURI uri, ILink link) {
        IProject project;
        IResource resource;
        IPath absPath = null;
        if (uri.path.startsWith("/") && (resource = link.getContainer().getResource()) != null && (project = resource.getProject()) != null) {
            String name = project.getName();
            absPath = new Path("/" + name).append(uri.path);
        }
        return absPath;
    }
}

