/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.web.faces.internal.providers.generators;

import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.Reference;
import com.ibm.etools.references.management.TextRange;
import com.ibm.etools.references.services.providers.RefactoringGeneratorParameters;
import com.ibm.etools.references.web.AbstractWebProvider;
import com.ibm.etools.references.web.URIUtil;
import com.ibm.etools.references.web.WebUtil;
import com.ibm.etools.references.web.providers.generators.WebLinkGeneratorProvider;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;

public class FacesConfigGeneratorProvider
extends WebLinkGeneratorProvider {
    public List<Reference> generateReferences(ILink link, String referenceType, String transformResult) {
        Reference result = null;
        String trimmedResult = transformResult.trim();
        if ("javaee.javatype.nodeid".equals(referenceType)) {
            Reference ref = new Reference(link, referenceType);
            ref.addParameter("typeName.id", trimmedResult);
            ref.setFragmentLocation(AbstractWebProvider.createTrimmedRange((ILink)link));
            result = ref;
        } else if ("web.reference.workspacePath".equals(referenceType)) {
            Reference reference = new Reference(link, referenceType);
            if (trimmedResult == null || trimmedResult.length() == 0) {
                return Collections.emptyList();
            }
            if ("jsf.navrule".equals(reference.getSource().getSpecializedType().getId()) && trimmedResult.contains("*")) {
                return Collections.emptyList();
            }
            IContainer container = WebUtil.getDocumentRootContainer((IResource)link.getContainer().getResource());
            if (container == null) {
                return Collections.emptyList();
            }
            IPath absPath = null;
            absPath = trimmedResult.startsWith("/") || trimmedResult.startsWith("\\") ? container.getFile((IPath)new Path(trimmedResult)).getFullPath() : link.getContainer().getResource().getParent().getFullPath().append(trimmedResult);
            int mb_offset = transformResult.indexOf(trimmedResult);
            int mb_length = trimmedResult.length();
            reference.addParameter("web.ref.abs.path.id", absPath.toPortableString());
            reference.setFragmentLocation(new TextRange(mb_offset, mb_length, link.getLinkLocation().getLinenumber()));
            result = reference;
        }
        if (result == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(result);
    }

    public String renameReference(RefactoringGeneratorParameters params) {
        if ("javaee.javatype.nodeid".equals(params.reference.getReferenceType())) {
            return (String)params.renameParameters.get("typeName.id");
        }
        if ("web.reference.workspacePath".equals(params.reference.getReferenceType())) {
            String newString = null;
            String noQuotes = AbstractWebProvider.trimQuotes((String)params.transformResult);
            Path targetPath = new Path((String)params.renameParameters.get("web.ref.abs.path.id"));
            IPath linkPath = FacesConfigGeneratorProvider.getWebAppRootRelativePath((IPath)targetPath);
            if (linkPath != null) {
                linkPath = noQuotes.startsWith("/") || noQuotes.startsWith("\\") ? linkPath.makeAbsolute() : linkPath.makeRelative();
                newString = linkPath.toString();
                newString = URIUtil.addURIComponents((String)newString, (IFile)this.getTargetContainer(params), (String)noQuotes);
            }
            return newString;
        }
        return null;
    }

    protected static IPath getWebAppRootRelativePath(IPath targetPath) {
        IContainer docRootFolder;
        IFile targetFile;
        IPath linkPath = null;
        if (targetPath != null && (targetFile = ResourcesPlugin.getWorkspace().getRoot().getFile(targetPath)) != null && (docRootFolder = WebUtil.getDocumentRootContainer((IResource)targetFile)) != null) {
            IPath docRootFolderPath = docRootFolder.getFullPath();
            int matchingFirstSegments = targetPath.matchingFirstSegments(docRootFolderPath);
            linkPath = targetPath.removeFirstSegments(matchingFirstSegments);
        }
        return linkPath;
    }

    public IStatus checkRenameReference(RefactoringGeneratorParameters params) {
        return Status.OK_STATUS;
    }
}

