/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.web.faces.internal.providers.detectors;

import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.IResolvedReference;
import com.ibm.etools.references.management.ReferenceElementFactory;
import com.ibm.etools.references.services.providers.ILinkDetectorProvider;
import com.ibm.etools.references.services.providers.SharedModel;
import com.ibm.etools.references.web.AbstractWebProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeIterator;

public class PageCodeLinkDetector
implements ILinkDetectorProvider {
    public List<ILink> detectLinks(ReferenceElementFactory factory, SharedModel sharedModel, Set<IResolvedReference> incomingReferences) {
        IDOMModel model;
        IDOMElement pageCodeElement;
        ArrayList<ILink> links = new ArrayList<ILink>();
        if (sharedModel.getSharedModel() instanceof IDOMModel && (pageCodeElement = PageCodeLinkDetector.getPageCodeElement(model = (IDOMModel)sharedModel.getSharedModel())) != null) {
            if (pageCodeElement.getNodeName().equalsIgnoreCase("jsf:pagecode")) {
                AbstractWebProvider.addLinksForTagAndAttributes((IDOMElement)pageCodeElement, (String)"jsf:pagecode", (String[])new String[]{"location"}, links, (ReferenceElementFactory)factory, (String)"jsf.pagecode");
            } else if (pageCodeElement.getNodeName().equalsIgnoreCase("jsf:codebehind")) {
                AbstractWebProvider.addLinksForTagAndAttributes((IDOMElement)pageCodeElement, (String)"jsf:codebehind", (String[])new String[]{"location"}, links, (ReferenceElementFactory)factory, (String)"jsf.pagecode");
            }
        }
        return links;
    }

    public static IDOMElement getPageCodeElement(IDOMModel model) {
        IDOMElement pageCodeElement = null;
        IDOMDocument document = model.getDocument();
        NodeIterator iter = ((DocumentTraversal)document).createNodeIterator((Node)document, 1, null, false);
        Node node = iter.nextNode();
        while (node != null) {
            if (node instanceof IDOMElement) {
                IDOMElement domElement = (IDOMElement)node;
                if (node.getNodeName().equalsIgnoreCase("jsf:pagecode")) {
                    pageCodeElement = domElement;
                    break;
                }
                if (node.getNodeName().equalsIgnoreCase("jsf:codebehind")) {
                    pageCodeElement = domElement;
                    break;
                }
            }
            node = iter.nextNode();
        }
        return pageCodeElement;
    }
}

