/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.web.faces.internal.providers.detectors;

import com.ibm.etools.jsf.util.JsfComponentUtil;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.IResolvedReference;
import com.ibm.etools.references.management.ReferenceElementFactory;
import com.ibm.etools.references.services.providers.ILinkDetectorProvider;
import com.ibm.etools.references.services.providers.SharedModel;
import com.ibm.etools.references.web.AbstractWebProvider;
import com.ibm.etools.references.web.CreateLinkParameter;
import com.ibm.etools.references.web.faces.internal.BindingHelper;
import com.ibm.etools.references.web.faces.internal.providers.detectors.PageCodeLinkDetector;
import com.ibm.etools.references.web.javaee.taglib.HTMLTaglibDirectiveUtil;
import com.ibm.etools.references.web.javaee.taglib.TaglibDirective;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeIterator;

public class FacesComponentLinkDetector
implements ILinkDetectorProvider {
    public List<ILink> detectLinks(ReferenceElementFactory factory, SharedModel sharedModel, Set<IResolvedReference> incomingReferences) {
        String F = "f:";
        String H = "h:";
        String HX = "hx:";
        ArrayList<ILink> links = new ArrayList<ILink>();
        if (sharedModel.getSharedModel() instanceof IDOMModel) {
            IDOMModel model = (IDOMModel)sharedModel.getSharedModel();
            IDOMElement pageCode = PageCodeLinkDetector.getPageCodeElement(model);
            boolean isEGL = false;
            if (pageCode != null) {
                isEGL = "EGL".equalsIgnoreCase(pageCode.getAttribute("language"));
            }
            if (isEGL) {
                return Collections.emptyList();
            }
            ModelQuery query = ModelQueryUtil.getModelQuery((IStructuredModel)model);
            IDOMDocument document = model.getDocument();
            List taglibDirectivesEx = HTMLTaglibDirectiveUtil.getTaglibDirectivesEx((IDOMModel)model);
            for (TaglibDirective taglibDirective : taglibDirectivesEx) {
                if ("http://java.sun.com/jsf/core".equals(taglibDirective.getURI())) {
                    F = String.valueOf(taglibDirective.getPrefix()) + ':';
                }
                if ("http://java.sun.com/jsf/html".equals(taglibDirective.getURI())) {
                    H = String.valueOf(taglibDirective.getPrefix()) + ':';
                    continue;
                }
                if (!"http://www.ibm.com/jsf/html_extended".equals(taglibDirective.getURI())) continue;
                HX = String.valueOf(taglibDirective.getPrefix()) + ':';
            }
            List nodes = JsfComponentUtil.findJsfNodes((Document)document);
            for (Node node : nodes) {
                if (!(node instanceof IDOMElement)) continue;
                IDOMElement domElement = (IDOMElement)node;
                if ((String.valueOf(H) + "commandButton").equals(((IDOMElement)node).getNodeName()) || (String.valueOf(HX) + "commandExButton").equals(((IDOMElement)node).getNodeName()) || (String.valueOf(HX) + "requestLink").equals(((IDOMElement)node).getNodeName()) || (String.valueOf(HX) + "requestRowAction").equals(((IDOMElement)node).getNodeName()) || (String.valueOf(HX) + "commandExRowAction").equals(((IDOMElement)node).getNodeName())) {
                    String actionValue;
                    IDOMAttr action = (IDOMAttr)domElement.getAttributeNode("action");
                    String string = actionValue = action != null ? action.getValue() : null;
                    if (action == null || actionValue != null && !actionValue.startsWith("#{component.") && !actionValue.startsWith("#{sessionScope.") && !actionValue.startsWith("#{requestScope.") && !actionValue.startsWith("#{applicationScope.")) {
                        ILink actionLink = AbstractWebProvider.createLink((CreateLinkParameter)new CreateLinkParameter(factory, domElement, (IDOMNode)action, "jsf.action.link", null));
                        if ((String.valueOf(HX) + "commandExButton").equals(((IDOMElement)node).getNodeName()) || (String.valueOf(H) + "commandButton").equals(((IDOMElement)node).getNodeName())) {
                            factory.addParam(actionLink, "uikind", "button");
                        } else if ((String.valueOf(HX) + "requestLink").equals(((IDOMElement)node).getNodeName())) {
                            factory.addParam(actionLink, "uikind", "link");
                        } else if ((String.valueOf(HX) + "requestRowAction").equals(((IDOMElement)node).getNodeName()) || (String.valueOf(HX) + "commandExRowAction").equals(((IDOMElement)node).getNodeName())) {
                            factory.addParam(actionLink, "uikind", "rowaction");
                        }
                        if (action != null) {
                            if (BindingHelper.isVblExpression(action.getValue())) {
                                factory.addParam(actionLink, "static", "false");
                            } else {
                                factory.addParam(actionLink, "static", "true");
                            }
                        }
                        factory.addParam(actionLink, "tagname", ((IDOMElement)node).getNodeName());
                        links.add(actionLink);
                    }
                }
                AbstractWebProvider.addLinksForTagAndAttributes((IDOMElement)domElement, (String)(String.valueOf(H) + "loadBundle"), (String[])new String[]{"basename"}, links, (ReferenceElementFactory)factory, (String)"jsf.contextRootAndWebapprelative.link");
                AbstractWebProvider.addLinksForTagAndAttributes((IDOMElement)domElement, (String)(String.valueOf(H) + "commandButton"), (String[])new String[]{"image"}, links, (ReferenceElementFactory)factory, (String)"jsf.contextRootAndWebapprelative.link");
                AbstractWebProvider.addLinksForTagAndAttributes((IDOMElement)domElement, (String)(String.valueOf(H) + "outputLink"), (String[])new String[]{"value"}, links, (ReferenceElementFactory)factory, (String)"jsf.contextRootAndWebapprelative.link");
                AbstractWebProvider.addLinksForTagAndAttributes((IDOMElement)domElement, (String)(String.valueOf(H) + "graphicImage"), (String[])new String[]{"url", "value"}, links, (ReferenceElementFactory)factory, (String)"jsf.contextRootAndWebapprelative.link");
                AbstractWebProvider.addLinksForTagAndAttributes((IDOMElement)domElement, (String)(String.valueOf(HX) + "commandExButton"), (String[])new String[]{"dimage", "himage", "image", "pimage", "iconDepressed", "iconDisabled", "iconMoused", "iconNormal"}, links, (ReferenceElementFactory)factory, (String)"jsf.contextRootAndWebapprelative.link");
                AbstractWebProvider.addLinksForTagAndAttributes((IDOMElement)domElement, (String)(String.valueOf(HX) + "pagerDeluxe"), (String[])new String[]{"srcFirst", "srcLast", "srcNext", "srcPrevious"}, links, (ReferenceElementFactory)factory, (String)"jsf.contextRootAndWebapprelative.link");
                AbstractWebProvider.addLinksForTagAndAttributes((IDOMElement)domElement, (String)(String.valueOf(HX) + "playerFlash"), (String[])new String[]{"src"}, links, (ReferenceElementFactory)factory, (String)"jsf.contextRootAndWebapprelative.link");
                AbstractWebProvider.addLinksForTagAndAttributes((IDOMElement)domElement, (String)(String.valueOf(HX) + "playerGenericPlayer"), (String[])new String[]{"src"}, links, (ReferenceElementFactory)factory, (String)"jsf.contextRootAndWebapprelative.link");
                AbstractWebProvider.addLinksForTagAndAttributes((IDOMElement)domElement, (String)(String.valueOf(HX) + "playerRealPlayer"), (String[])new String[]{"src"}, links, (ReferenceElementFactory)factory, (String)"jsf.contextRootAndWebapprelative.link");
                AbstractWebProvider.addLinksForTagAndAttributes((IDOMElement)domElement, (String)(String.valueOf(HX) + "playerMediaPlayer"), (String[])new String[]{"src"}, links, (ReferenceElementFactory)factory, (String)"jsf.contextRootAndWebapprelative.link");
                AbstractWebProvider.addLinksForTagAndAttributes((IDOMElement)domElement, (String)(String.valueOf(HX) + "playerShockwave"), (String[])new String[]{"src"}, links, (ReferenceElementFactory)factory, (String)"jsf.contextRootAndWebapprelative.link");
                AbstractWebProvider.addLinksForTagAndAttributes((IDOMElement)domElement, (String)(String.valueOf(HX) + "graphicImageEx"), (String[])new String[]{"url", "value"}, links, (ReferenceElementFactory)factory, (String)"jsf.contextRootAndWebapprelative.link");
                AbstractWebProvider.addLinksForTagAndAttributes((IDOMElement)domElement, (String)(String.valueOf(HX) + "inputRowSelect"), (String[])new String[]{"srcSelected", "srcUnselected"}, links, (ReferenceElementFactory)factory, (String)"jsf.contextRootAndWebapprelative.link");
                AbstractWebProvider.addLinksForTagAndAttributes((IDOMElement)domElement, (String)(String.valueOf(HX) + "outputSelecticons"), (String[])new String[]{"srcAll", "srcInverse", "srcNone"}, links, (ReferenceElementFactory)factory, (String)"jsf.contextRootAndWebapprelative.link");
                AbstractWebProvider.addLinksForTagAndAttributes((IDOMElement)domElement, (String)(String.valueOf(HX) + "panelActionbar"), (String[])new String[]{"nestedTitleImage"}, links, (ReferenceElementFactory)factory, (String)"jsf.contextRootAndWebapprelative.link");
                AbstractWebProvider.addLinksForTagAndAttributes((IDOMElement)domElement, (String)(String.valueOf(HX) + "outputLinkEx"), (String[])new String[]{"value"}, links, (ReferenceElementFactory)factory, (String)"jsf.contextRootAndWebapprelative.link");
                AbstractWebProvider.addLinksForTagAndAttributes((IDOMElement)domElement, (String)(String.valueOf(HX) + "pageSimple"), (String[])new String[]{"buttonImageSrc"}, links, (ReferenceElementFactory)factory, (String)"jsf.contextRootAndWebapprelative.link");
                AbstractWebProvider.addLinksForTagAndAttributes((IDOMElement)domElement, (String)(String.valueOf(HX) + "pageGoto"), (String[])new String[]{"buttonImageSrc"}, links, (ReferenceElementFactory)factory, (String)"jsf.contextRootAndWebapprelative.link");
                AbstractWebProvider.addLinksForTagAndAttributes((IDOMElement)domElement, (String)(String.valueOf(HX) + "panelDialog"), (String[])new String[]{"titleCloseButtonImage"}, links, (ReferenceElementFactory)factory, (String)"jsf.contextRootAndWebapprelative.link");
                AbstractWebProvider.addLinksForTagAndAttributes((IDOMElement)domElement, (String)(String.valueOf(HX) + "panelRowCategory"), (String[])new String[]{"collapsedImage", "expandedImage"}, links, (ReferenceElementFactory)factory, (String)"jsf.contextRootAndWebapprelative.link");
                AbstractWebProvider.addLinksForTagAndAttributes((IDOMElement)domElement, (String)(String.valueOf(HX) + "sortHeader"), (String[])new String[]{"srcAscending", "srcAscendingOn", "srcBi", "srcBiDown", "srcBiUp", "srcDescending", "srcDescendingOn"}, links, (ReferenceElementFactory)factory, (String)"jsf.contextRootAndWebapprelative.link");
                AbstractWebProvider.addLinksForTagAndAttributes((IDOMElement)domElement, (String)(String.valueOf(HX) + "pageSimple"), (String[])new String[]{"buttonImageSrc"}, links, (ReferenceElementFactory)factory, (String)"jsf.contextRootAndWebapprelative.link");
                NamedNodeMap map = domElement.getAttributes();
                int i = 0;
                while (i < map.getLength()) {
                    CMElementDeclaration declaration;
                    IDOMAttr attribute = (IDOMAttr)map.item(i);
                    boolean bCreateLink = false;
                    if ("validator".equals(attribute.getName()) || "valueChangeListener".equals(attribute.getName()) || "actionListener".equals(attribute.getName())) {
                        bCreateLink = true;
                    } else if ((String.valueOf(HX) + "scriptCollector").equals(domElement.getNodeName())) {
                        if ("preRender".equals(attribute.getName()) || "postRender".equals(attribute.getName()) || "decode".equals(attribute.getName())) {
                            bCreateLink = true;
                        }
                    } else if ((String.valueOf(F) + "view").equals(domElement.getNodeName()) && ("beforePhase".equals(attribute.getName()) || "afterPhase".equals(attribute.getName()))) {
                        bCreateLink = true;
                    }
                    if (bCreateLink && (declaration = query.getCMElementDeclaration((Element)domElement)) != null) {
                        List list = query.getAvailableContent((Element)domElement, declaration, 1);
                        for (CMAttributeDeclaration attr : list) {
                            if (!attribute.getName().equals(attr.getAttrName())) continue;
                            CreateLinkParameter param = new CreateLinkParameter(factory, domElement, (IDOMNode)attribute, "jsf.action.link", null);
                            ILink link = AbstractWebProvider.createLink((CreateLinkParameter)param);
                            factory.addParam(link, "jsf.ignore", "1");
                            factory.addParam(link, "tagname", domElement.getNodeName());
                            factory.addParam(link, "attrname", attribute.getName());
                            links.add(link);
                            break;
                        }
                    }
                    ++i;
                }
            }
        }
        return links;
    }

    public static String getAttributeValueForTag(Node tagNode, String tagName, String attributeName) {
        NodeList childNodes;
        IDOMElement attributeNode;
        String attributeValue = null;
        if (tagNode.getNodeName().equals(tagName) && (attributeValue = AbstractWebProvider.getTextContent((IDOMElement)(attributeNode = AbstractWebProvider.getNode((NodeList)(childNodes = tagNode.getChildNodes()), (String)attributeName)))) != null) {
            attributeValue = attributeValue.trim();
        }
        return attributeValue;
    }

    public static synchronized List<Node> findJsfAndPagecodeNodes(Document d) {
        boolean pagecodeFound = false;
        ArrayList<Node> resultnodes = new ArrayList<Node>();
        if (d == null) {
            return resultnodes;
        }
        NodeIterator iter = ((DocumentTraversal)((Object)d)).createNodeIterator(d, 1, null, false);
        Node node = iter.nextNode();
        while (node != null) {
            if (JsfComponentUtil.isJsfTag((Node)node)) {
                resultnodes.add(node);
            } else if (!pagecodeFound && node.getNodeName().equalsIgnoreCase("jsf:pagecode") || node.getNodeName().equalsIgnoreCase("jsf:codebehind")) {
                resultnodes.add(node);
                pagecodeFound = true;
            }
            node = iter.nextNode();
        }
        return resultnodes;
    }
}

