/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.web.faces;

import com.ibm.etools.references.StringMatcher;
import com.ibm.etools.references.management.BrokenStatus;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.IReferenceElement;
import com.ibm.etools.references.management.IResolvedReference;
import com.ibm.etools.references.management.ReferenceManager;
import com.ibm.etools.references.management.TextRange;
import com.ibm.etools.references.search.DefaultSearchRequestor;
import com.ibm.etools.references.search.SearchEngine;
import com.ibm.etools.references.search.SearchPattern;
import com.ibm.etools.references.search.SearchRequestor;
import com.ibm.etools.references.search.SearchScope;
import com.ibm.etools.references.search.SearchType;
import com.ibm.etools.references.web.AbstractWebProvider;
import com.ibm.etools.references.web.faces.FacesAction;
import com.ibm.etools.references.web.faces.FacesNavigation;
import com.ibm.etools.references.web.faces.internal.BindingHelper;
import com.ibm.etools.references.web.javaee.providers.resolvers.SearchUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.wst.common.internal.emf.resource.EMF2DOMAdapter;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.w3c.dom.Node;

public class FacesLinkUtil {
    public static ILink getManagedBeanLink(String beanName, IProject project) {
        SearchPattern pattern = SearchPattern.createPattern((String)"jsf.managedbean", (SearchType)SearchType.BY_TYPE, (IReferenceElement.ElementType)IReferenceElement.ElementType.LINK, (int)0);
        SearchPattern namePattern = SearchPattern.createPattern((String)beanName, (SearchType)SearchType.BY_LINKNAME, (IReferenceElement.ElementType)IReferenceElement.ElementType.LINK, (int)0);
        pattern = SearchPattern.createAndPattern((SearchPattern)namePattern, (SearchPattern)pattern);
        SearchScope scope = SearchEngine.createSearchScope((IResource[])new IResource[]{project});
        DefaultSearchRequestor req = new DefaultSearchRequestor();
        new SearchEngine().search(pattern, scope, (SearchRequestor)req, null);
        if (!req.getMatches().isEmpty()) {
            return (ILink)req.getMatches().iterator().next();
        }
        return null;
    }

    public static Collection<ILink> getAllFacesManagedBeans(IProject project, boolean includePagecodeBeans, IProgressMonitor monitor) {
        DefaultSearchRequestor req = new DefaultSearchRequestor();
        FacesLinkUtil.getAllFacesManagedBeans(project, includePagecodeBeans, (SearchRequestor<ILink>)req, monitor);
        return req.getMatches();
    }

    public static void getAllFacesManagedBeans(IProject project, final boolean includePagecodeBeans, final SearchRequestor<ILink> req, IProgressMonitor monitor) {
        SearchRequestor<ILink> filter = new SearchRequestor<ILink>(){

            public void acceptSearchMatch(ILink match) {
                ILink link;
                if (!includePagecodeBeans && (link = match).getName() != null && link.getName().startsWith("pc")) {
                    return;
                }
                req.acceptSearchMatch((IReferenceElement)match);
            }

            public void beginReporting() {
                req.beginReporting();
            }

            public void endReporting() {
                req.endReporting();
            }
        };
        SearchPattern pattern = SearchPattern.createPattern((String)"jsf.managedbean", (SearchType)SearchType.BY_TYPE, (IReferenceElement.ElementType)IReferenceElement.ElementType.LINK, (int)0);
        SearchScope scope = SearchEngine.createSearchScope((IResource[])new IResource[]{project});
        new SearchEngine().search(pattern, scope, (SearchRequestor)filter, monitor);
    }

    public static ILink getJavaTarget(ILink managedbean) {
        Collection rrs = managedbean.resolveReference("javaee.javatype.nodeid", null);
        if (!rrs.isEmpty()) {
            return ((IResolvedReference)rrs.iterator().next()).getTarget();
        }
        return null;
    }

    public static ILink getMBTarget(ILink link) {
        Collection rrs = link.resolveReference("jsf.simple.vbl", null);
        if (!rrs.isEmpty()) {
            return ((IResolvedReference)rrs.iterator().next()).getTarget();
        }
        return null;
    }

    public static ILink getFileTarget(ILink link) {
        Collection rrs = link.resolveReference("web.reference.workspacePath", null);
        if (!rrs.isEmpty()) {
            return ((IResolvedReference)rrs.iterator().next()).getTarget();
        }
        return null;
    }

    public static Collection<FacesAction> getFacesActionsForManageBean(ILink managedBean, IProgressMonitor monitor) {
        ArrayList<FacesAction> actions = new ArrayList<FacesAction>();
        DefaultSearchRequestor requestor = new DefaultSearchRequestor();
        FacesLinkUtil.getFacesActionsForManageBean(managedBean, (SearchRequestor<ILink>)requestor, monitor);
        Set links = requestor.getMatches();
        for (ILink link : links) {
            actions.add(new FacesAction(managedBean, link));
        }
        return actions;
    }

    public static void getFacesActionsForManageBean(ILink managedBean, SearchRequestor<ILink> req, IProgressMonitor monitor) {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        Collection rrs = managedBean.resolveReference("javaee.javatype.nodeid", FacesLinkUtil.monitorFor(monitor, (IProgressMonitor)sub.newChild(1)));
        if (!rrs.isEmpty()) {
            ILink typeLink = ((IResolvedReference)rrs.iterator().next()).getTarget();
            if (typeLink != null) {
                IJavaProject project = JavaCore.create((IProject)managedBean.getContainer().getResource().getProject());
                Collection methodLinks = SearchUtil.findAnyMethodLinks((IJavaProject)project, (String)AbstractWebProvider.trimQuotes((String)managedBean.getLinkText()), (IProgressMonitor)FacesLinkUtil.monitorFor(monitor, (IProgressMonitor)sub.newChild(1)));
                for (ILink methodLink : methodLinks) {
                    if (!"java.lang.String".equals(methodLink.getLinkText()) && !"String".equals(methodLink.getLinkText())) continue;
                    req.acceptSearchMatch((IReferenceElement)methodLink);
                }
            }
        } else {
            sub.worked(1);
        }
        req.endReporting();
    }

    public static List<FacesAction> getAllFacesActions(IProject project, boolean includePagecodeBeans, IProgressMonitor monitor) {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ArrayList<FacesAction> actions = new ArrayList<FacesAction>();
        Collection<ILink> mbLinks = FacesLinkUtil.getAllFacesManagedBeans(project, includePagecodeBeans, FacesLinkUtil.monitorFor(monitor, (IProgressMonitor)mon.newChild(20)));
        mon.setWorkRemaining(mbLinks.size());
        for (ILink mbLink : mbLinks) {
            actions.addAll(FacesLinkUtil.getFacesActionsForManageBean(mbLink, FacesLinkUtil.monitorFor(monitor, (IProgressMonitor)mon.newChild(1))));
        }
        if (monitor != null) {
            monitor.done();
        }
        return actions;
    }

    public static FacesAction getFacesActionTarget(ILink linkHandle) {
        IResolvedReference managedBean;
        Collection rrs = linkHandle.resolveReference("jsf.simple.vbl", null);
        if (!rrs.isEmpty() && (managedBean = (IResolvedReference)rrs.iterator().next()).getBrokenStatus() == BrokenStatus.NOTBROKEN) {
            IResolvedReference method = managedBean.getNext();
            return new FacesAction(managedBean.getTarget(), method.getTarget());
        }
        return null;
    }

    private static Set<ILink> getILinksOfType(String type, SearchScope scope) {
        SearchPattern pattern = SearchPattern.createPattern((String)type, (SearchType)SearchType.BY_TYPE, (IReferenceElement.ElementType)IReferenceElement.ElementType.LINK, (int)0);
        DefaultSearchRequestor req = new DefaultSearchRequestor();
        new SearchEngine().search(pattern, scope, (SearchRequestor)req, null);
        return req.getMatches();
    }

    public static Map<String, List<FacesNavigation>> createFromViewTree(Set<String> fromIds, List<FacesNavigation> navs) {
        HashMap<String, List<FacesNavigation>> tree = new HashMap<String, List<FacesNavigation>>();
        for (FacesNavigation nav : navs) {
            if (nav.getFromView() == null) {
                FacesLinkUtil.getOrCreateGroup("*", tree).add(nav);
                continue;
            }
            if (fromIds == null) {
                FacesLinkUtil.getOrCreateGroup(nav.getFromView(), tree).add(nav);
                continue;
            }
            if (!fromIds.contains(nav.getFromView())) continue;
            FacesLinkUtil.getOrCreateGroup(nav.getFromView(), tree).add(nav);
        }
        return tree;
    }

    private static List<FacesNavigation> getOrCreateGroup(String fromId, Map<String, List<FacesNavigation>> tree) {
        List<FacesNavigation> group = tree.get(fromId);
        if (group == null) {
            group = new ArrayList<FacesNavigation>();
            tree.put(fromId, group);
        }
        return group;
    }

    public static List<FacesNavigation> applicableToFromViews(String fromView, List<FacesNavigation> navs) {
        ArrayList<FacesNavigation> result = new ArrayList<FacesNavigation>(navs);
        if (fromView == null || fromView.length() == 0) {
            Iterator iterator = result.iterator();
            while (iterator.hasNext()) {
                FacesNavigation facesNavigation = (FacesNavigation)iterator.next();
                if (facesNavigation.getFromView() == null) continue;
                iterator.remove();
            }
        } else {
            Iterator iterator = result.iterator();
            while (iterator.hasNext()) {
                StringMatcher matcher;
                FacesNavigation facesNavigation = (FacesNavigation)iterator.next();
                if (facesNavigation.getFromView() == null || (matcher = new StringMatcher(facesNavigation.getFromView())).match(fromView)) continue;
                iterator.remove();
            }
        }
        return result;
    }

    public static List<FacesNavigation> applicableToOutcome(String outcome, List<FacesNavigation> navs) {
        if (outcome == null) {
            return navs;
        }
        Iterator<FacesNavigation> iterator = navs.iterator();
        while (iterator.hasNext()) {
            FacesNavigation facesNavigation = iterator.next();
            String navOutcome = facesNavigation.getFromOutcome();
            if (navOutcome == null || outcome.equals(navOutcome)) continue;
            iterator.remove();
        }
        return navs;
    }

    public static List<FacesNavigation> applicableToEveryAction(List<FacesNavigation> navs) {
        ArrayList<FacesNavigation> result = new ArrayList<FacesNavigation>(navs);
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            FacesNavigation facesNavigation = (FacesNavigation)iterator.next();
            if (facesNavigation.fromAction == null) continue;
            iterator.remove();
        }
        return result;
    }

    public static List<FacesNavigation> applicableToAction(String action, List<FacesNavigation> navs) {
        ArrayList<FacesNavigation> result = new ArrayList<FacesNavigation>(navs);
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            FacesNavigation facesNavigation = (FacesNavigation)iterator.next();
            String ruleFrom = facesNavigation.getFromAction();
            if (ruleFrom == null && action == null) continue;
            String ruleAction = facesNavigation.getFromAction();
            String vblAction = BindingHelper.makeVbl(ruleAction);
            if (ruleAction != null && action == null) {
                iterator.remove();
            }
            if (action != null && ruleAction == null || action == null || action.equals(vblAction)) continue;
            iterator.remove();
        }
        return result;
    }

    public static List<FacesNavigation> getAllFacesNavigation(SearchScope scope, IProgressMonitor monitor) {
        Set<ILink> navRules = FacesLinkUtil.getILinksOfType("jsf.navrule", scope);
        Set<ILink> navCases = FacesLinkUtil.getILinksOfType("jsf.navcase", scope);
        Set<ILink> fromActions = FacesLinkUtil.getILinksOfType("jsf.navcase.fromaction", scope);
        Set<ILink> fromOutcomes = FacesLinkUtil.getILinksOfType("jsf.navcase.fromoutcome", scope);
        Set<ILink> toViews = FacesLinkUtil.getILinksOfType("jsf.navcase.toview", scope);
        ArrayList<FacesNavigation> navigations = new ArrayList<FacesNavigation>();
        for (ILink navRule : navRules) {
            Iterator<ILink> caseItr = navCases.iterator();
            while (caseItr.hasNext()) {
                ILink navCase = caseItr.next();
                if (!navRule.getContextLocation().contains(navCase.getContextLocation())) continue;
                ILink toView = null;
                Iterator<ILink> toItr = toViews.iterator();
                while (toItr.hasNext()) {
                    ILink toViewLink = toItr.next();
                    if (!navCase.getContextLocation().contains(toViewLink.getContextLocation())) continue;
                    toView = toViewLink;
                    toItr.remove();
                    break;
                }
                ILink fromOutcome = null;
                Iterator<ILink> fromItr = fromOutcomes.iterator();
                while (fromItr.hasNext()) {
                    ILink anOutcome = fromItr.next();
                    if (!navCase.getContextLocation().contains(anOutcome.getContextLocation())) continue;
                    if (fromOutcome == null) {
                        fromOutcome = anOutcome;
                    }
                    fromItr.remove();
                }
                ILink fromAction = null;
                Iterator<ILink> fromItr2 = fromActions.iterator();
                while (fromItr2.hasNext()) {
                    ILink anAction = fromItr2.next();
                    if (!navCase.getContextLocation().contains(anAction.getContextLocation())) continue;
                    if (fromAction == null) {
                        fromAction = anAction;
                    }
                    fromItr2.remove();
                }
                if (toView != null) {
                    FacesNavigation navigation = new FacesNavigation();
                    navigation.navRule = navRule;
                    navigation.fromOutcome = fromOutcome;
                    navigation.fromAction = fromAction;
                    navigation.toView = toView;
                    navigation.navCase = navCase;
                    navigations.add(navigation);
                }
                caseItr.remove();
            }
        }
        return navigations;
    }

    public static List<FacesNavigation> getAllFacesNavigation(IResource resource, IProgressMonitor monitor) {
        return FacesLinkUtil.getAllFacesNavigation(SearchEngine.createSearchScope((IResource[])new IResource[]{resource}), monitor);
    }

    public static String addLeadingSlash(String fromView) {
        if (fromView.equals("") || fromView.startsWith("/") || fromView.startsWith("*")) {
            return fromView;
        }
        return "/" + fromView;
    }

    public static EObject getCorrespondingEObject(EClass eclass, EObject root, ILink link) {
        ReferenceManager.getReferenceManager().waitForIndexing(null, SearchEngine.createSearchScope((IResource[])new IResource[]{link.getContainer().getResource()}));
        TreeIterator itr = root.eAllContents();
        while (itr.hasNext()) {
            int contextLength;
            IDOMElement domElement;
            int contextStartOffset;
            TextRange elementRange;
            Node n;
            Adapter adapter;
            EObject object = (EObject)itr.next();
            if (!eclass.equals(object.eClass()) || !((adapter = EcoreUtil.getExistingAdapter((Notifier)object, (Object)EMF2DOMAdapter.ADAPTER_CLASS)) instanceof EMF2DOMAdapter) || !((n = ((EMF2DOMAdapter)adapter).getNode()) instanceof IDOMElement) || !(elementRange = new TextRange(contextStartOffset = (domElement = (IDOMElement)n).getStartOffset(), contextLength = domElement.getEndOffset() - contextStartOffset, 0)).contains(link.getContextLocation())) continue;
            return object;
        }
        return null;
    }

    public static ILink getStaticOutcomeTarget(ILink handle) {
        return null;
    }

    public static String getTaglibURIForTagName(IFile file, String tagName) {
        String prefix = tagName.substring(0, tagName.indexOf(":"));
        SearchPattern pattern = SearchPattern.createPattern((String)"javaee.jsp.taglibdirective", (SearchType)SearchType.BY_TYPE, (IReferenceElement.ElementType)IReferenceElement.ElementType.LINK, (int)0);
        SearchPattern namePattern = SearchPattern.createPattern((String)prefix, (SearchType)SearchType.BY_LINKNAME, (IReferenceElement.ElementType)IReferenceElement.ElementType.LINK, (int)0);
        pattern = SearchPattern.createAndPattern((SearchPattern)namePattern, (SearchPattern)pattern);
        SearchScope scope = SearchEngine.createSearchScope((IResource[])new IResource[]{file});
        DefaultSearchRequestor req = new DefaultSearchRequestor();
        new SearchEngine().search(pattern, scope, (SearchRequestor)req, null);
        if (!req.getMatches().isEmpty()) {
            ILink link = (ILink)req.getMatches().iterator().next();
            return AbstractWebProvider.trimQuotes((String)link.getLinkText());
        }
        return null;
    }

    private static IProgressMonitor monitorFor(IProgressMonitor rootMonitor, IProgressMonitor subMonitor) {
        if (rootMonitor == null || rootMonitor instanceof NullProgressMonitor) {
            return rootMonitor;
        }
        return subMonitor;
    }
}

