/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.ui.internal.search;

import com.ibm.etools.references.events.IReferenceListener;
import com.ibm.etools.references.events.ReferenceEvent;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.IReferenceElement;
import com.ibm.etools.references.management.LinkNode;
import com.ibm.etools.references.management.ReferenceManager;
import com.ibm.etools.references.ui.internal.search.IReferenceContentProvider;
import com.ibm.etools.references.ui.internal.search.ReferenceSearchMatch;
import com.ibm.etools.references.ui.internal.search.ReferenceSearchResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.search.ui.ISearchResultListener;
import org.eclipse.search.ui.SearchResultEvent;
import org.eclipse.search.ui.text.Match;
import org.eclipse.search.ui.text.MatchEvent;
import org.eclipse.search.ui.text.RemoveAllEvent;

public class FileTreeContentProvider
implements ITreeContentProvider,
IReferenceContentProvider,
ISearchResultListener,
IReferenceListener {
    private final Object[] EMPTY_ARR = new Object[0];
    public static final Object EMPTY_INDICATOR = new Object();
    private ReferenceSearchResult fResult;
    private final ColumnViewer fTreeViewer;
    private Map<Object, Set<Object>> fChildrenMap;
    private final boolean treeMode;

    FileTreeContentProvider(ColumnViewer viewer, boolean treeMode) {
        this.fTreeViewer = viewer;
        this.treeMode = treeMode;
        ReferenceManager.getReferenceManager().addReferenceListener((IReferenceListener)this);
    }

    public Object[] getElements(Object inputElement) {
        if (this.treeMode) {
            Object[] children = this.getChildren(inputElement);
            int elementLimit = this.getElementLimit();
            if (elementLimit != -1 && elementLimit < children.length) {
                Object[] limitedChildren = new Object[elementLimit];
                System.arraycopy(children, 0, limitedChildren, 0, elementLimit);
                return limitedChildren;
            }
            return children;
        }
        return this.fResult.getElements();
    }

    private int getElementLimit() {
        return -1;
    }

    public void dispose() {
        if (this.fResult != null) {
            this.fResult.removeListener(this);
        }
        ReferenceManager.getReferenceManager().removeReferenceListener((IReferenceListener)this);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput instanceof ReferenceSearchResult) {
            this.initialize((ReferenceSearchResult)((Object)newInput));
        }
    }

    private synchronized void initialize(ReferenceSearchResult result) {
        if (this.fResult != null) {
            this.fResult.removeListener(this);
        }
        this.fResult = result;
        this.fResult.addListener(this);
        this.fChildrenMap = new HashMap<Object, Set<Object>>();
        boolean showLineMatches = true;
        if (result != null) {
            Object[] elements = result.getElements();
            int i = 0;
            while (i < elements.length) {
                if (showLineMatches) {
                    Match[] matches = result.getMatches(elements[i]);
                    int j = 0;
                    while (j < matches.length) {
                        this.insert(((ReferenceSearchMatch)matches[j]).getILink(), false);
                        ++j;
                    }
                } else {
                    this.insert(elements[i], false);
                }
                ++i;
            }
        }
    }

    private void insert(Object child, boolean refreshViewer) {
        Object parent = this.getParent(child);
        while (parent != null) {
            if (this.insertChild(parent, child)) {
                if (refreshViewer) {
                    ((AbstractTreeViewer)this.fTreeViewer).add(parent, child);
                }
            } else {
                if (refreshViewer) {
                    this.fTreeViewer.refresh(parent);
                }
                return;
            }
            child = parent;
            parent = this.getParent(child);
        }
        if (this.insertChild((Object)this.fResult, child) && refreshViewer) {
            ((AbstractTreeViewer)this.fTreeViewer).add((Object)this.fResult, child);
        }
    }

    private boolean insertChild(Object parent, Object child) {
        Set<Object> children = this.fChildrenMap.get(parent);
        if (children == null) {
            children = new HashSet<Object>();
            this.fChildrenMap.put(parent, children);
        }
        return children.add(child);
    }

    private boolean hasChild(Object parent, Object child) {
        Set<Object> children = this.fChildrenMap.get(parent);
        return children != null && children.contains(child);
    }

    private void remove(Object element, boolean refreshViewer) {
        if (this.hasChildren(element)) {
            if (refreshViewer) {
                this.fTreeViewer.refresh(element);
            }
        } else if (!this.hasMatches(element)) {
            this.fChildrenMap.remove(element);
            Object parent = this.getParent(element);
            if (parent != null) {
                this.removeFromSiblings(element, parent);
                this.remove(parent, refreshViewer);
            } else {
                this.removeFromSiblings(element, (Object)this.fResult);
                if (refreshViewer) {
                    this.fTreeViewer.refresh();
                }
            }
        } else if (refreshViewer) {
            this.fTreeViewer.refresh(element);
        }
    }

    private boolean hasMatches(Object element) {
        return this.fResult.getMatchCount(element) > 0;
    }

    private void removeFromSiblings(Object element, Object parent) {
        Set<Object> siblings = this.fChildrenMap.get(parent);
        if (siblings != null) {
            siblings.remove(element);
        }
    }

    public Object[] getChildren(Object parentElement) {
        Set<Object> children = this.fChildrenMap.get(parentElement);
        if (children == null) {
            return this.EMPTY_ARR;
        }
        return children.toArray();
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    @Override
    public synchronized void elementsChanged(Object[] updatedElements) {
        if (this.treeMode) {
            if (updatedElements.length == 0 && this.fChildrenMap.isEmpty()) {
                this.insert(EMPTY_INDICATOR, true);
            }
            int i = 0;
            while (i < updatedElements.length) {
                ILink lineElement;
                if (updatedElements[i] instanceof ILink && !(lineElement = (ILink)updatedElements[i]).getSpecializedType().isInternal() && (ReferenceManager.getReferenceManager().isBuiltIn(lineElement) || !lineElement.isEndPoint())) {
                    if (this.hasMatches(lineElement)) {
                        if (lineElement.getContainer() == null) {
                            this.remove(EMPTY_INDICATOR, true);
                            this.insert(lineElement, true);
                        } else if (this.hasChild(lineElement.getContainer().getResource(), lineElement)) {
                            this.fTreeViewer.update(new Object[]{lineElement, lineElement.getContainer().getResource()}, null);
                            this.remove(EMPTY_INDICATOR, true);
                        } else {
                            this.remove(EMPTY_INDICATOR, true);
                            this.insert(lineElement, true);
                        }
                    } else {
                        this.remove(lineElement, true);
                    }
                }
                ++i;
            }
        } else {
            this.fTreeViewer.refresh();
        }
    }

    public void clear() {
        this.initialize(this.fResult);
        this.fTreeViewer.refresh();
    }

    public Object getParent(Object element) {
        LinkNode container;
        if (element instanceof IProject) {
            return null;
        }
        if (element instanceof IResource) {
            IResource resource = (IResource)element;
            return resource.getParent();
        }
        if (element instanceof ILink && (container = ((ILink)element).getContainer()) != null) {
            return container.getResource();
        }
        return null;
    }

    public void searchResultChanged(SearchResultEvent e) {
        if (e instanceof MatchEvent) {
            MatchEvent match = (MatchEvent)e;
            if (match.getKind() == 2) {
                Match[] matches = match.getMatches();
                if (this.treeMode) {
                    Match[] matchArray = matches;
                    int n = matches.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Match m = matchArray[n2];
                        Object removedObject = m.getElement();
                        Object parent = this.getParent(removedObject);
                        this.removeFromSiblings(removedObject, parent);
                        ++n2;
                    }
                }
            }
        } else if (e instanceof RemoveAllEvent) {
            this.fChildrenMap.clear();
        }
    }

    public void handleReferenceEvents(List<ReferenceEvent> events) {
        if (this.fResult != null) {
            ArrayList<Match> matches = new ArrayList<Match>();
            for (ReferenceEvent referenceEvent : events) {
                if (referenceEvent.getKind() == ReferenceEvent.Kind.REMOVE && referenceEvent.getReferenceElement().getElementType() == IReferenceElement.ElementType.LINK) {
                    matches.addAll(Arrays.asList(this.fResult.getMatches(referenceEvent.getReferenceElement())));
                    continue;
                }
                if (referenceEvent.getKind() != ReferenceEvent.Kind.RESET) continue;
                this.fResult.removeAll();
            }
            this.fResult.removeMatches(matches.toArray(new Match[matches.size()]));
        }
    }
}

