/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.ui.internal.quickfix;

import com.ibm.etools.references.ui.internal.BuildUtil;
import com.ibm.etools.references.ui.internal.nls.Messages;
import com.ibm.etools.references.ui.internal.quickfix.QuickFixRegistry;
import com.ibm.etools.references.ui.quickfix.ReferenceQuickFix;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator2;

public class ReferenceQuickFixGenerator
implements IMarkerResolutionGenerator2 {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasResolutions(IMarker marker) {
        try {
            Object refId;
            String providerIdsRaw = (String)marker.getAttribute("providerIds");
            if (providerIdsRaw != null) {
                String[] providerIds;
                String[] stringArray = providerIds = providerIdsRaw.split(",");
                int n = providerIds.length;
                int n2 = 0;
                while (n2 < n) {
                    String providerIdString = stringArray[n2];
                    try {
                        int providerId = Integer.parseInt(providerIdString);
                        if (QuickFixRegistry.hasQuickFix(providerId)) {
                            return true;
                        }
                    }
                    catch (Exception exception) {}
                    ++n2;
                }
            }
            if ((refId = marker.getAttribute("refId")) != null) return false;
            return true;
        }
        catch (Exception exception) {}
        return false;
    }

    public IMarkerResolution[] getResolutions(IMarker marker) {
        HashSet<ReferenceQuickFix> fixes = new HashSet<ReferenceQuickFix>();
        try {
            Object refId;
            String providerIdsRaw = (String)marker.getAttribute("providerIds");
            if (providerIdsRaw != null) {
                String[] providerIds;
                String[] stringArray = providerIds = providerIdsRaw.split(",");
                int n = providerIds.length;
                int n2 = 0;
                while (n2 < n) {
                    String providerIdString = stringArray[n2];
                    try {
                        int providerId = Integer.parseInt(providerIdString);
                        Set<ReferenceQuickFix> fixForProvider = QuickFixRegistry.getQuickFix(providerId);
                        for (ReferenceQuickFix quickfix : fixForProvider) {
                            quickfix.setSelectedMarker(marker);
                        }
                        fixes.addAll(fixForProvider);
                    }
                    catch (Exception exception) {}
                    ++n2;
                }
            }
            if ((refId = marker.getAttribute("refId")) == null) {
                return new IMarkerResolution[]{new IMarkerResolution(){

                    public void run(IMarker marker) {
                        BuildUtil.rebuildDatabase();
                    }

                    public String getLabel() {
                        return Messages.ReferenceQuickFixGenerator_0;
                    }
                }};
            }
        }
        catch (Exception exception) {}
        return (IMarkerResolution[])fixes.toArray(new ReferenceQuickFix[fixes.size()]);
    }
}

