/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.ui.internal.quickfix;

import com.ibm.etools.references.InternalAPI;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.IResolvedReference;
import com.ibm.etools.references.refactoring.RefactoringSupport;
import com.ibm.etools.references.ui.internal.nls.Messages;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.PerformChangeOperation;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.views.markers.WorkbenchMarkerResolution;

public abstract class InternalQuickFix
extends WorkbenchMarkerResolution {
    int pID;
    IMarker selectedMarker;

    void setProviderId(int providerId) {
        this.pID = providerId;
    }

    void setSelectedMarker(IMarker marker) {
        this.selectedMarker = marker;
    }

    protected IMarker getSelectedMarker() {
        return this.selectedMarker;
    }

    private boolean hasSameTarget(IResolvedReference ref1, IResolvedReference ref2) {
        boolean same = true;
        Map params = ref1.getReference().getParameters();
        for (Map.Entry entry : params.entrySet()) {
            String value;
            String key = (String)entry.getKey();
            if (!key.contains("id") || (value = (String)entry.getValue()).equals(ref2.getReference().getParameter(key))) continue;
            same = false;
        }
        return same;
    }

    public IMarker[] findOtherMarkers(IMarker[] markers) {
        ArrayList<IMarker> otherMarkers = new ArrayList<IMarker>();
        try {
            Integer brokenRefId = (Integer)this.selectedMarker.getAttribute("brokenResolvedReferenceId");
            if (brokenRefId == null) {
                return new IMarker[0];
            }
            Integer brokenLinkId = (Integer)this.selectedMarker.getAttribute("refId");
            if (brokenLinkId == null) {
                return new IMarker[0];
            }
            ILink brokenLink = (ILink)InternalAPI.getElement((int)brokenLinkId);
            IResolvedReference selRef = this.getRR(brokenLink, this.selectedMarker);
            if (selRef == null) {
                return new IMarker[0];
            }
            int selId = InternalAPI.getProviderId((IResolvedReference)selRef);
            IMarker[] iMarkerArray = markers;
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                block11: {
                    IMarker marker = iMarkerArray[n2];
                    if (this.selectedMarker != marker) {
                        try {
                            String[] providerIds;
                            if (!"com.ibm.etools.references.linkmarker".equals(marker.getType())) break block11;
                            String providerIdsRaw = (String)marker.getAttribute("providerIds");
                            String[] stringArray = providerIds = providerIdsRaw.split(",");
                            int n3 = providerIds.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                IResolvedReference otherRef;
                                int otherId;
                                ILink otherLinkRef;
                                Integer otherInt;
                                String providerIdString = stringArray[n4];
                                int providerId = Integer.parseInt(providerIdString);
                                if (providerId == this.pID && (otherInt = (Integer)marker.getAttribute("refId")) != null && (otherLinkRef = (ILink)InternalAPI.getElement((int)otherInt)) != null && selId == (otherId = InternalAPI.getProviderId((IResolvedReference)(otherRef = this.getRR(otherLinkRef, marker)))) && this.hasSameTarget(selRef, otherRef)) {
                                    otherMarkers.add(marker);
                                    break;
                                }
                                ++n4;
                            }
                        }
                        catch (Exception exception) {}
                    }
                }
                ++n2;
            }
        }
        catch (Exception exception) {}
        return otherMarkers.toArray(new IMarker[otherMarkers.size()]);
    }

    private IResolvedReference getRR(ILink brokenLink, IMarker marker) {
        Collection rrs = brokenLink.resolveReference(null, null);
        Iterator iterator = rrs.iterator();
        while (iterator.hasNext()) {
            IResolvedReference rr = (IResolvedReference)iterator.next();
            int id = InternalAPI.getProviderId((IResolvedReference)rr);
            if (id == this.pID) continue;
            iterator.remove();
        }
        if (rrs.size() > 1) {
            try {
                Integer providerIdsRaw = (Integer)marker.getAttribute("brokenResolvedReferenceId");
                if (providerIdsRaw != null) {
                    int i = providerIdsRaw;
                    for (IResolvedReference resolvedReference : rrs) {
                        if (resolvedReference.getId() != i) continue;
                        return resolvedReference;
                    }
                }
            }
            catch (Exception exception) {}
            return null;
        }
        if (rrs.size() != 1) {
            return null;
        }
        return (IResolvedReference)rrs.iterator().next();
    }

    public void run(IMarker[] markers, IProgressMonitor monitor) {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor);
        mon.beginTask(Messages.quickfix_performing_quick_fixes, 2);
        mon.subTask(Messages.quickfix_initialization);
        SubMonitor part1 = mon.newChild(1);
        part1.beginTask("", markers.length);
        HashSet<IResolvedReference> tofix = new HashSet<IResolvedReference>();
        int i = 0;
        while (i < markers.length) {
            IResolvedReference rr = this.getResolvedReferences(markers[i]);
            if (rr != null) {
                tofix.add(rr);
            }
            part1.worked(1);
            ++i;
        }
        SubMonitor part2 = mon.newChild(1);
        part2.beginTask("", 4);
        if (!tofix.isEmpty()) {
            part2.subTask(Messages.quickfix_gathering_changes);
            Map<String, Object> targetDescription = this.run(tofix, (IProgressMonitor)part2.newChild(1));
            if (targetDescription != null && !targetDescription.isEmpty()) {
                RefactoringSupport support = new RefactoringSupport();
                for (IResolvedReference resolvedReference : tofix) {
                    support.createEdits(resolvedReference, targetDescription, Collections.emptySet());
                }
                part2.subTask(Messages.quickfix_executing_changes);
                Change change = support.createChange(Messages.quickfix_update_references, (IProgressMonitor)part2.newChild(1));
                if (change != null) {
                    Object[] obs = change.getAffectedObjects();
                    ArrayList<ISchedulingRule> rules = new ArrayList<ISchedulingRule>();
                    Object[] objectArray = obs;
                    int n = obs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object o = objectArray[n2];
                        if (o instanceof IResource) {
                            rules.add(ResourcesPlugin.getWorkspace().getRuleFactory().modifyRule((IResource)o));
                        }
                        ++n2;
                    }
                    ISchedulingRule schedulingRule = MultiRule.combine((ISchedulingRule[])rules.toArray(new ISchedulingRule[rules.size()]));
                    change.initializeValidationData((IProgressMonitor)part2.newChild(1));
                    PerformChangeOperation op = new PerformChangeOperation(change);
                    op.setUndoManager(RefactoringCore.getUndoManager(), Messages.quickfix_fix_broken_links);
                    op.setSchedulingRule(schedulingRule);
                    try {
                        op.run((IProgressMonitor)part2.newChild(1));
                    }
                    catch (CoreException e) {
                        throw new RuntimeException(e);
                    }
                }
            } else {
                UIJob job = new UIJob(Messages.InternalQuickFix_OpenInfo){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.InternalQuickFix_Information, (String)Messages.InternalQuickFix_QuickFixNotFound);
                        return Status.OK_STATUS;
                    }
                };
                job.schedule();
            }
        }
    }

    public final void run(IMarker marker) {
    }

    protected IResolvedReference getResolvedReferences(IMarker marker) {
        try {
            ILink link;
            Integer providerIdsRaw = (Integer)marker.getAttribute("refId");
            if (providerIdsRaw != null && (link = (ILink)InternalAPI.getElement((int)providerIdsRaw)) != null) {
                return this.getRR(link, marker);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error getting references from marker", e);
        }
        return null;
    }

    protected abstract Map<String, Object> run(Set<IResolvedReference> var1, IProgressMonitor var2);
}

