/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.ui.internal.handlers;

import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.ReferenceManager;
import com.ibm.etools.references.search.SearchEngine;
import com.ibm.etools.references.search.SearchScope;
import com.ibm.etools.references.ui.internal.search.ReferencesSearchQuery;
import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class ShowReferencesCommandHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection s = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        if (s instanceof IStructuredSelection) {
            Object o = ((IStructuredSelection)s).getFirstElement();
            if (event.getParameters() == null || event.getParameters().isEmpty()) {
                this.doIncoming(o, "workspace");
                return null;
            }
            String scope = event.getParameter("scope");
            String direction = event.getParameter("direction");
            if ("incoming".equals(direction)) {
                this.doIncoming(o, scope);
            } else if ("outgoing".equals(direction)) {
                this.doOutgoing(o, scope);
            }
        }
        return null;
    }

    private SearchScope getScope(String scope, IResource resource) {
        if ("workspace".equals(scope)) {
            return SearchEngine.createWorkspaceScope();
        }
        if ("project".equals(scope)) {
            return SearchEngine.createSearchScope((IResource[])new IResource[]{resource.getProject()});
        }
        IWorkingSet set = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSet(scope);
        ArrayList<IResource> resources = new ArrayList<IResource>();
        if (set != null) {
            IAdaptable[] adaptables = set.getElements();
            int j = 0;
            while (j < adaptables.length) {
                IAdaptable adaptable = adaptables[j];
                IResource r = (IResource)adaptable.getAdapter(IResource.class);
                if (r != null) {
                    resources.add(r);
                }
                ++j;
            }
        }
        return SearchEngine.createSearchScope(resources);
    }

    private IResource getResource(Object object) {
        IResource resource;
        if (object instanceof IResource) {
            return (IResource)object;
        }
        if (object instanceof IAdaptable && (resource = (IResource)((IAdaptable)object).getAdapter(IResource.class)) != null) {
            return resource;
        }
        return null;
    }

    private ILink getLink(Object object) {
        ILink link;
        if (object instanceof ILink) {
            return (ILink)object;
        }
        if (object instanceof IAdaptable && (link = (ILink)((IAdaptable)object).getAdapter(ILink.class)) != null) {
            return link;
        }
        return null;
    }

    private void doIncoming(Object object, String scopeString) {
        IResource resource = this.getResource(object);
        ILink link = this.getLink(object);
        if (resource == null && link == null) {
            return;
        }
        if (link != null) {
            resource = link.getContainer().getResource();
        }
        if (link != null && resource != null && ReferenceManager.getReferenceManager().isBuiltIn(link)) {
            link = null;
        }
        SearchScope scope = this.getScope(scopeString, resource);
        ReferencesSearchQuery query = null;
        query = link == null ? new ReferencesSearchQuery(scope, resource, true, true) : new ReferencesSearchQuery(scope, link, true, true);
        NewSearchUI.runQueryInBackground((ISearchQuery)query);
    }

    private void doOutgoing(Object object, String scopeString) {
        IResource resource = this.getResource(object);
        ILink link = this.getLink(object);
        if (resource == null && link == null) {
            return;
        }
        if (link != null) {
            resource = link.getContainer().getResource();
        }
        if (link != null && resource != null && ("builtin.file.nodeid".equals(link.getSpecializedType().getId()) || "builtin.folder.nodeid".equals(link.getSpecializedType().getId()) || "builtin.project.nodeid".equals(link.getSpecializedType().getId()))) {
            link = null;
        }
        SearchScope scope = this.getScope(scopeString, resource);
        ReferencesSearchQuery query = null;
        query = link == null ? new ReferencesSearchQuery(scope, resource, false, true) : new ReferencesSearchQuery(scope, link, false, true);
        NewSearchUI.runQueryInBackground((ISearchQuery)query);
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isHandled() {
        return true;
    }
}

