/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.ui.internal.filebuffers;

import com.ibm.etools.references.InternalAPI;
import com.ibm.etools.references.ui.internal.filebuffers.FileBufferListener;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public class EditorTracker
implements IWindowListener,
IPageListener,
IPartListener {
    private final FileBufferListener listener;

    public EditorTracker(FileBufferListener listener) {
        this.listener = listener;
    }

    public void connect() {
        IWorkbenchWindow[] windows;
        PlatformUI.getWorkbench().addWindowListener((IWindowListener)this);
        IWorkbenchWindow[] iWorkbenchWindowArray = windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = windows.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchPage[] pages;
            IWorkbenchWindow workbenchWindow = iWorkbenchWindowArray[n2];
            workbenchWindow.addPageListener((IPageListener)this);
            workbenchWindow.getPartService().addPartListener((IPartListener)this);
            IWorkbenchPage[] iWorkbenchPageArray = pages = workbenchWindow.getPages();
            int n3 = pages.length;
            int n4 = 0;
            while (n4 < n3) {
                IEditorReference[] refs;
                IWorkbenchPage workbenchPage = iWorkbenchPageArray[n4];
                IEditorReference[] iEditorReferenceArray = refs = workbenchPage.getEditorReferences();
                int n5 = refs.length;
                int n6 = 0;
                while (n6 < n5) {
                    IEditorReference editorReference = iEditorReferenceArray[n6];
                    IEditorPart part = editorReference.getEditor(false);
                    if (part != null) {
                        this.partOpened((IWorkbenchPart)part);
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
    }

    public void disconnect() {
        IWorkbenchWindow[] windows;
        PlatformUI.getWorkbench().removeWindowListener((IWindowListener)this);
        IWorkbenchWindow[] iWorkbenchWindowArray = windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = windows.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchPage[] pages;
            IWorkbenchWindow workbenchWindow = iWorkbenchWindowArray[n2];
            workbenchWindow.removePageListener((IPageListener)this);
            workbenchWindow.getPartService().removePartListener((IPartListener)this);
            IWorkbenchPage[] iWorkbenchPageArray = pages = workbenchWindow.getPages();
            int n3 = pages.length;
            int n4 = 0;
            while (n4 < n3) {
                IEditorReference[] refs;
                IWorkbenchPage workbenchPage = iWorkbenchPageArray[n4];
                IEditorReference[] iEditorReferenceArray = refs = workbenchPage.getEditorReferences();
                int n5 = refs.length;
                int n6 = 0;
                while (n6 < n5) {
                    IEditorReference editorReference = iEditorReferenceArray[n6];
                    IEditorPart part = editorReference.getEditor(false);
                    if (part != null) {
                        this.partClosed((IWorkbenchPart)part);
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
    }

    public void windowActivated(IWorkbenchWindow window) {
    }

    public void windowDeactivated(IWorkbenchWindow window) {
    }

    public void windowClosed(IWorkbenchWindow window) {
        window.removePageListener((IPageListener)this);
    }

    public void windowOpened(IWorkbenchWindow window) {
        window.addPageListener((IPageListener)this);
        if (window.getActivePage() != null) {
            window.getActivePage().addPartListener((IPartListener)this);
        }
    }

    public void pageActivated(IWorkbenchPage page) {
    }

    public void pageClosed(IWorkbenchPage page) {
        page.removePartListener((IPartListener)this);
    }

    public void pageOpened(IWorkbenchPage page) {
        page.addPartListener((IPartListener)this);
    }

    public void partActivated(IWorkbenchPart part) {
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        if (part instanceof IEditorPart) {
            this.editorClosed((IEditorPart)part);
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
        IWorkbenchSiteProgressService service;
        IViewPart view;
        if (part instanceof IEditorPart) {
            this.editorOpened((IEditorPart)part);
        } else if (part instanceof IViewPart && "org.eclipse.ui.views.ProblemView".equals((view = (IViewPart)part).getViewSite().getId()) && (service = (IWorkbenchSiteProgressService)view.getSite().getService(IWorkbenchSiteProgressService.class)) != null) {
            service.showBusyForFamily(InternalAPI.MARKERS_FAMILY);
        }
    }

    public void editorOpened(IEditorPart part) {
        this.listener.editorOpened(part);
    }

    public void editorClosed(IEditorPart part) {
        this.listener.editorClosed(part);
    }
}

