/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.ui.internal.debug;

import com.ibm.etools.references.InternalAPI;
import com.ibm.etools.references.StringMatcher;
import com.ibm.etools.references.management.BrokenReference;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.IReferenceElement;
import com.ibm.etools.references.management.IResolvedReference;
import com.ibm.etools.references.management.LinkNode;
import com.ibm.etools.references.management.ReferenceException;
import com.ibm.etools.references.management.ReferenceManager;
import com.ibm.etools.references.management.ResourceChange;
import com.ibm.etools.references.management.SpecializedType;
import com.ibm.etools.references.search.DefaultSearchRequestor;
import com.ibm.etools.references.search.SearchEngine;
import com.ibm.etools.references.search.SearchPattern;
import com.ibm.etools.references.search.SearchRequestor;
import com.ibm.etools.references.search.SearchScope;
import com.ibm.etools.references.search.SearchType;
import com.ibm.etools.references.ui.internal.BuildUtil;
import com.ibm.etools.references.ui.internal.debug.FileVisitor;
import com.ibm.etools.references.ui.internal.debug.IOConsoleViewer;
import com.ibm.etools.references.ui.internal.debug.ResourceVisitor;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.osgi.service.runnable.ParameterizedRunnable;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.console.IPatternMatchListener;
import org.eclipse.ui.console.PatternMatchEvent;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.console.TextConsoleViewer;
import org.eclipse.ui.dialogs.ResourceSelectionDialog;

public class ReferenceTestDialog
extends Dialog {
    private boolean autoclear = true;
    private Button checkbox;
    private final LocalResourceManager local;
    private IOConsole mainScreen;
    private TextConsoleViewer mainScreenViewer;
    private OutputStream mainScreenOutputStream;
    private PrintStream mainScreenPrintStream;
    private IOConsole detailsConsole;
    private PrintStream detailsPrintStream;
    private Composite rightPanel;
    private MyLogListener listener;
    private IOConsole logConsole;
    private Text id;

    private void activatePlugin() {
        ReferenceManager.getReferenceManager();
    }

    private void recreate() {
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
                    InternalAPI.resetManager((IProgressMonitor)sub.newChild(1));
                    if (monitor != null) {
                        monitor.done();
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace(this.mainScreenPrintStream);
        }
    }

    private void requestIndex(IResource resource, int style) {
        ReferenceManager manager = ReferenceManager.getReferenceManager();
        manager.requestChangeAnalysis(new ResourceChange(resource, style), null);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
    }

    private void dumpLinks(String pathSpec, boolean exact) {
        try {
            SearchEngine.setSearchHint(EnumSet.of(SearchEngine.SearchHint.NOWAIT));
            SearchScope scope = SearchEngine.createWorkspaceScope();
            ReferenceManager.getReferenceManager().waitForIndexing(null, scope);
            Collection<Object> resources = new ArrayList<IFile>();
            if (exact) {
                try {
                    IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(pathSpec));
                    if (file != null) {
                        resources.add(file);
                    }
                }
                catch (RuntimeException e) {
                    e.printStackTrace(this.mainScreenPrintStream);
                }
            } else {
                ResourceVisitor fileVisitor = new ResourceVisitor();
                try {
                    ResourcesPlugin.getWorkspace().getRoot().accept((IResourceVisitor)fileVisitor);
                }
                catch (CoreException coreException) {
                    coreException.printStackTrace(this.mainScreenPrintStream);
                }
                if (pathSpec.indexOf(42) == -1) {
                    pathSpec = String.valueOf('*') + pathSpec + '*';
                }
                resources = fileVisitor.getResources();
            }
            this.mainScreenPrintStream.println("Dumping links on: " + pathSpec);
            StringMatcher matcher = new StringMatcher(pathSpec);
            for (IResource iResource : resources) {
                LinkNode myFile = ReferenceManager.getReferenceManager().getLinkNode(iResource);
                if (!matcher.match(iResource.getFullPath().toString())) continue;
                this.mainScreenPrintStream.println("===================================================");
                this.mainScreenPrintStream.println("| Looking at... " + myFile);
                this.mainScreenPrintStream.println("===================================================");
                try {
                    Collection links = myFile.getLinks(null, SpecializedType.Depth.ZERO, null);
                    for (ILink link : links) {
                        this.mainScreenPrintStream.println("  " + link);
                        List refTypes = link.getReferenceTypes();
                        if (refTypes.size() == 0) {
                            this.mainScreenPrintStream.println("    -NO REFERENCES GENERABLE-");
                        }
                        for (String refType : refTypes) {
                            IResolvedReference next;
                            IResolvedReference current;
                            IResolvedReference resolvedRef;
                            Iterator iterator;
                            this.mainScreenPrintStream.println("    Reference Type:" + refType);
                            this.mainScreenPrintStream.println("    -OUT-");
                            try {
                                Collection outgoingRefs = link.resolveReference(refType, null);
                                if (outgoingRefs.isEmpty()) {
                                    this.mainScreenPrintStream.println("        -NO RESOLVED REFS-");
                                }
                                iterator = outgoingRefs.iterator();
                                while (iterator.hasNext()) {
                                    current = resolvedRef = (IResolvedReference)iterator.next();
                                    next = resolvedRef;
                                    while (next != null) {
                                        if (next != current) {
                                            this.mainScreenPrintStream.println("         ---> NEXT REFERENCE: ");
                                        }
                                        this.mainScreenPrintStream.println("          " + next.toString());
                                        next = next.getNext();
                                    }
                                }
                            }
                            catch (RuntimeException e) {
                                e.printStackTrace(this.mainScreenPrintStream);
                            }
                            this.mainScreenPrintStream.println("    -IN-");
                            try {
                                Collection incomingRefs = link.resolveIncomingReference(refType, null);
                                if (incomingRefs.isEmpty()) {
                                    this.mainScreenPrintStream.println("        -NO RESOLVED REFS-");
                                }
                                iterator = incomingRefs.iterator();
                                while (iterator.hasNext()) {
                                    current = resolvedRef = (IResolvedReference)iterator.next();
                                    next = resolvedRef;
                                    while (next != null) {
                                        if (next != current) {
                                            this.mainScreenPrintStream.println("          ---> NEXT REFERENCE: ");
                                        }
                                        this.mainScreenPrintStream.println("          " + next.toString());
                                        next = next.getNext();
                                    }
                                }
                            }
                            catch (RuntimeException e) {
                                e.printStackTrace(this.mainScreenPrintStream);
                            }
                        }
                        Collection brokenRefs = link.findBrokenReferences(null);
                        if (brokenRefs.isEmpty()) {
                            this.mainScreenPrintStream.println("    -NO BROKEN REFS-");
                        } else {
                            this.mainScreenPrintStream.println("    -BROKEN REFS:");
                        }
                        for (BrokenReference broken : brokenRefs) {
                            this.mainScreenPrintStream.println("          " + broken);
                        }
                    }
                    this.mainScreenPrintStream.println("- INCOMING TO TARGET NODE AND ENCLOSED LINKS-");
                    try {
                        Collection incoming = myFile.getIncomingLinks(null);
                        for (ILink link : incoming) {
                            this.mainScreenPrintStream.println("  " + link);
                        }
                        if (incoming.size() != 0) continue;
                        this.mainScreenPrintStream.println("  -NONE-");
                    }
                    catch (ReferenceException e) {
                        e.printStackTrace(this.mainScreenPrintStream);
                    }
                }
                catch (ReferenceException e1) {
                    e1.printStackTrace(this.mainScreenPrintStream);
                }
            }
            this.mainScreenPrintStream.println("DONE");
        }
        finally {
            SearchEngine.clearSearchHint(EnumSet.of(SearchEngine.SearchHint.NOWAIT));
        }
    }

    public ReferenceTestDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(3312);
        this.local = new LocalResourceManager(JFaceResources.getResources());
    }

    public boolean close() {
        boolean parent = super.close();
        this.removeLogListener();
        this.local.dispose();
        this.detailsPrintStream.close();
        return parent;
    }

    private Composite createTripple(Composite c) {
        Composite twin = new Composite(c, 0);
        GridLayoutFactory col2 = GridLayoutFactory.fillDefaults();
        col2.numColumns(3);
        col2.generateLayout(twin);
        return twin;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Link Indexer Debugger (for support usage only)");
    }

    private Composite createTwin(Composite parent) {
        Composite twin = new Composite(parent, 0);
        GridLayoutFactory col2 = GridLayoutFactory.fillDefaults();
        col2.numColumns(2);
        col2.equalWidth(false);
        col2.generateLayout(twin);
        return twin;
    }

    protected Control createDialogArea(Composite parent) {
        GridLayoutFactory defaults = GridLayoutFactory.fillDefaults();
        defaults.margins(5, 5);
        SashForm horizontal = new SashForm(parent, 66048);
        defaults.applyTo((Composite)horizontal);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)horizontal);
        Composite topsection = new Composite(parent, 2048);
        defaults.applyTo(topsection);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)topsection);
        SashForm col2 = new SashForm((Composite)horizontal, 65792);
        GridDataFactory.fillDefaults().grab(true, true).minSize(50, -1).applyTo((Control)col2);
        ScrolledComposite scrolled = new ScrolledComposite((Composite)col2, 2560);
        defaults.applyTo((Composite)scrolled);
        Composite leftPanel = new Composite((Composite)scrolled, 0);
        defaults.applyTo(leftPanel);
        GridDataFactory.fillDefaults().applyTo((Control)leftPanel);
        scrolled.setContent((Control)leftPanel);
        scrolled.setExpandHorizontal(true);
        scrolled.setExpandVertical(true);
        GridDataFactory.swtDefaults().align(1, 4).grab(false, true).applyTo((Control)leftPanel);
        this.rightPanel = new Composite((Composite)col2, 2048);
        col2.setWeights(new int[]{10, 90});
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.rightPanel);
        TabFolder tab = new TabFolder(this.rightPanel, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)tab);
        GridLayoutFactory.fillDefaults().applyTo((Composite)tab);
        Composite tab1control = new Composite((Composite)tab, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)tab1control);
        GridLayoutFactory.fillDefaults().applyTo(tab1control);
        TabItem tab1 = new TabItem(tab, 0);
        tab1.setText("Main");
        tab1.setControl((Control)tab1control);
        this.mainScreen = this.createConsole();
        Composite mainScreenHolder = new Composite(tab1control, 2048);
        GridLayoutFactory.fillDefaults().applyTo(mainScreenHolder);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)mainScreenHolder);
        this.mainScreenViewer = new TextConsoleViewer(mainScreenHolder, (TextConsole)this.mainScreen);
        GridDataFactory.fillDefaults().grab(true, true).applyTo(this.mainScreenViewer.getControl());
        this.mainScreenOutputStream = this.mainScreen.newOutputStream();
        this.mainScreenPrintStream = new PrintStream(this.mainScreenOutputStream);
        Group debugObjectDetails = new Group(this.rightPanel, 0);
        GridLayoutFactory.fillDefaults().applyTo((Composite)debugObjectDetails);
        GridDataFactory.fillDefaults().applyTo((Control)debugObjectDetails);
        debugObjectDetails.setText("Database object details");
        Composite twinId = this.createTwin((Composite)debugObjectDetails);
        Label dumpId = new Label(twinId, 0);
        dumpId.setText("Object ID: ");
        this.id = new Text(twinId, 2048);
        this.id.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.character == '\r') {
                    ReferenceTestDialog.this.dumpObject();
                }
            }
        });
        this.detailsConsole = this.createConsole();
        Composite detailsHolder = new Composite((Composite)debugObjectDetails, 2048);
        GridLayoutFactory.fillDefaults().applyTo(detailsHolder);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)detailsHolder);
        TextConsoleViewer detailsViewer = new TextConsoleViewer(detailsHolder, (TextConsole)this.detailsConsole);
        GridDataFactory.fillDefaults().grab(true, true).hint(-1, 50).applyTo(detailsViewer.getControl());
        IOConsoleOutputStream stream = this.detailsConsole.newOutputStream();
        this.detailsPrintStream = new PrintStream((OutputStream)stream);
        Button clear = new Button((Composite)debugObjectDetails, 8);
        clear.setText("Clear");
        clear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReferenceTestDialog.this.clearMainConsole();
            }
        });
        final Button auto = new Button((Composite)debugObjectDetails, 32);
        auto.setText("Auto clear");
        auto.setSelection(this.autoclear);
        auto.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReferenceTestDialog.this.autoclear = auto.getSelection();
            }
        });
        final Button deProxy = new Button((Composite)debugObjectDetails, 32);
        deProxy.setText("Deproxy objects");
        deProxy.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InternalAPI.LOAD_DATA_FOR_TO_STRING = deProxy.getSelection();
            }
        });
        deProxy.setSelection(InternalAPI.LOAD_DATA_FOR_TO_STRING);
        final Button dumpLinks = new Button((Composite)debugObjectDetails, 32);
        dumpLinks.setText("Print actual links for indexes");
        dumpLinks.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        defaults.applyTo(this.rightPanel);
        Button re = new Button(leftPanel, 8);
        re.setText("Re-index workspace");
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)re);
        re.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ReferenceTestDialog.this.autoclear) {
                    ReferenceTestDialog.this.clearMainConsole();
                }
                ReferenceTestDialog.this.mainScreenPrintStream.println("Re-indexing invoked...");
                BuildUtil.rebuildDatabase();
            }
        });
        Button b = new Button(leftPanel, 8);
        b.setText("Activate Plugin");
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)b);
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ReferenceTestDialog.this.autoclear) {
                    ReferenceTestDialog.this.clearMainConsole();
                }
                ReferenceTestDialog.this.mainScreenPrintStream.println("Activate plugin invoked...");
                ReferenceTestDialog.this.activatePlugin();
            }
        });
        Button reset = new Button(leftPanel, 8);
        reset.setText("Reset (clears database)");
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)reset);
        reset.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ReferenceTestDialog.this.autoclear) {
                    ReferenceTestDialog.this.clearMainConsole();
                }
                ReferenceTestDialog.this.mainScreenPrintStream.println("Database is cleared...");
                ReferenceTestDialog.this.recreate();
            }
        });
        Button recreate = new Button(leftPanel, 8);
        recreate.setText("Recreate all markers");
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)recreate);
        recreate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ReferenceTestDialog.this.autoclear) {
                    ReferenceTestDialog.this.clearMainConsole();
                }
                ReferenceTestDialog.this.mainScreenPrintStream.println("Markers recreation requested...");
                ReferenceManager.getReferenceManager().requestRebuildAllMarkers();
            }
        });
        Button reload = new Button(leftPanel, 8);
        reload.setText("Flush caches");
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)reload);
        reload.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ReferenceTestDialog.this.autoclear) {
                    ReferenceTestDialog.this.clearMainConsole();
                }
                ReferenceTestDialog.this.mainScreenPrintStream.print("Flush caches");
                try {
                    PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            InternalAPI.flushCaches();
                        }
                    });
                }
                catch (Exception e1) {
                    e1.printStackTrace(ReferenceTestDialog.this.mainScreenPrintStream);
                }
            }
        });
        Button printStats = new Button(leftPanel, 8);
        printStats.setText("Print performance stats");
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)printStats);
        printStats.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ReferenceTestDialog.this.autoclear) {
                    ReferenceTestDialog.this.clearMainConsole();
                }
                ReferenceTestDialog.this.mainScreenPrintStream.println("Performance stats");
                try {
                    PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            InternalAPI.printExtensionStats((PrintStream)ReferenceTestDialog.this.mainScreenPrintStream);
                        }
                    });
                }
                catch (Exception e1) {
                    e1.printStackTrace(ReferenceTestDialog.this.mainScreenPrintStream);
                }
            }
        });
        Button printCache = new Button(leftPanel, 8);
        printCache.setText("Print cache stats");
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)printCache);
        printCache.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ReferenceTestDialog.this.autoclear) {
                    ReferenceTestDialog.this.clearMainConsole();
                }
                ReferenceTestDialog.this.mainScreenPrintStream.print("Cache stats");
                InternalAPI.printStats((PrintStream)ReferenceTestDialog.this.mainScreenPrintStream);
            }
        });
        Button resetStats = new Button(leftPanel, 8);
        resetStats.setText("Reset cache stats");
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)resetStats);
        resetStats.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ReferenceTestDialog.this.autoclear) {
                    ReferenceTestDialog.this.clearMainConsole();
                }
                ReferenceTestDialog.this.mainScreenPrintStream.print("Resetting cache stats");
                InternalAPI.resetCacheStats();
            }
        });
        Button clearJDTLinks = new Button(leftPanel, 8);
        clearJDTLinks.setText("Clear JDT links");
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)clearJDTLinks);
        clearJDTLinks.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ReferenceTestDialog.this.autoclear) {
                    ReferenceTestDialog.this.clearMainConsole();
                }
                ReferenceTestDialog.this.mainScreenPrintStream.print("Clearing JDT links");
                try {
                    PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            ParameterizedRunnable runnable = InternalAPI.getRunnable((String)"removeLinks");
                            if (runnable != null) {
                                SearchEngine engine = new SearchEngine();
                                SearchPattern types = SearchPattern.createPattern((String)"javaee.javatype.nodeid", (SearchType)SearchType.BY_TYPE, (IReferenceElement.ElementType)IReferenceElement.ElementType.LINK, (int)0);
                                SearchPattern methods = SearchPattern.createPattern((String)"javaee.jdt.publicmethod", (SearchType)SearchType.BY_TYPE, (IReferenceElement.ElementType)IReferenceElement.ElementType.LINK, (int)0);
                                DefaultSearchRequestor requestor = new DefaultSearchRequestor();
                                engine.search(types.or(methods), null, (SearchRequestor)requestor, monitor);
                                try {
                                    runnable.run((Object)requestor.getMatches());
                                }
                                catch (Exception e) {
                                    throw new InvocationTargetException(e, "Badness");
                                }
                            }
                        }
                    });
                }
                catch (Exception e1) {
                    e1.printStackTrace(ReferenceTestDialog.this.mainScreenPrintStream);
                }
            }
        });
        Button boostPriority = new Button(leftPanel, 8);
        boostPriority.setText("Boost priority");
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)boostPriority);
        boostPriority.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ReferenceTestDialog.this.autoclear) {
                    ReferenceTestDialog.this.clearMainConsole();
                }
                ReferenceTestDialog.this.mainScreenPrintStream.print("Boosting prority");
                InternalAPI.boostPriority();
            }
        });
        Composite twin = this.createTwin(leftPanel);
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)twin);
        Button dump = new Button(twin, 8);
        dump.setText("Dump links on: ");
        final Text t = new Text(twin, 2048);
        t.setText("*.jsp");
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)t);
        dump.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ReferenceTestDialog.this.autoclear) {
                    ReferenceTestDialog.this.clearMainConsole();
                }
                final boolean exact = ReferenceTestDialog.this.checkbox.getSelection();
                final String to = t.getText();
                Job dump = new Job("dumpLinks"){

                    protected IStatus run(IProgressMonitor monitor) {
                        ReferenceTestDialog.this.dumpLinks(to, exact);
                        return Status.OK_STATUS;
                    }
                };
                dump.setSystem(true);
                dump.schedule();
            }
        });
        Group g1 = new Group(leftPanel, 0);
        g1.setText("Triggered change indexing");
        g1.setLayout((Layout)new GridLayout());
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)g1);
        Label l = new Label((Composite)g1, 64);
        l.setText("Here you can (re)index files. You can use * and ? as wildcards. If  \"Exact path\" is checked, * and ? are invalid and it will request index on the FULL PATH specified");
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).hint(200, -1).applyTo((Control)l);
        Composite tripple = this.createTripple((Composite)g1);
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)tripple);
        Button requestIndex = new Button(tripple, 8);
        requestIndex.setText("(Re)analyze path:");
        GridDataFactory.swtDefaults().align(1, 0x1000000).grab(false, false).applyTo((Control)requestIndex);
        final Text file = new Text(tripple, 2048);
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)file);
        Button selectFile = new Button(tripple, 8);
        selectFile.setText("...");
        Composite twin2 = this.createTripple((Composite)g1);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)twin2);
        ((GridLayout)twin2.getLayout()).makeColumnsEqualWidth = true;
        final Combo kind = new Combo(twin2, 8);
        kind.add("ADD");
        kind.add("REMOVE");
        kind.add("CHANGE");
        kind.select(2);
        GridDataFactory.fillDefaults().applyTo((Control)kind);
        this.checkbox = new Button(twin2, 32);
        this.checkbox.setText("Exact path");
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.checkbox);
        this.checkbox.setSelection(false);
        selectFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] o;
                ResourceSelectionDialog d = new ResourceSelectionDialog(ReferenceTestDialog.this.getShell(), (IAdaptable)ResourcesPlugin.getWorkspace().getRoot(), "Pick a resource");
                if (d.open() == 0 && (o = d.getResult()).length > 0) {
                    IResource r = (IResource)o[0];
                    file.setText(r.getFullPath().toString());
                }
            }
        });
        requestIndex.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final String pathSpec = file.getText();
                final boolean selection = ReferenceTestDialog.this.checkbox.getSelection();
                final int selectedIndex = kind.getSelectionIndex();
                final String item = kind.getItem(selectedIndex);
                Job updateJob = new Job("Update"){

                    protected IStatus run(IProgressMonitor monitor) {
                        if (ReferenceTestDialog.this.autoclear) {
                            ReferenceTestDialog.this.clearMainConsole();
                        }
                        FileVisitor visit = new FileVisitor();
                        try {
                            ResourcesPlugin.getWorkspace().getRoot().accept((IResourceVisitor)visit);
                        }
                        catch (CoreException coreException) {}
                        Collection<Object> files = new ArrayList<IFile>();
                        String p = pathSpec;
                        if (selection) {
                            try {
                                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(pathSpec));
                                if (file != null) {
                                    files.add(file);
                                }
                            }
                            catch (RuntimeException ee) {
                                ee.printStackTrace(ReferenceTestDialog.this.mainScreenPrintStream);
                            }
                        } else {
                            ResourceVisitor fileVisitor = new ResourceVisitor();
                            try {
                                ResourcesPlugin.getWorkspace().getRoot().accept((IResourceVisitor)fileVisitor);
                            }
                            catch (CoreException ee) {
                                ee.printStackTrace(ReferenceTestDialog.this.mainScreenPrintStream);
                            }
                            if (pathSpec.indexOf(42) == -1) {
                                p = String.valueOf('*') + pathSpec + '*';
                            }
                            files = fileVisitor.getResources();
                        }
                        StringMatcher matcher = new StringMatcher(p);
                        for (IResource iResource : files) {
                            if (!matcher.match(iResource.getFullPath().toString())) continue;
                            ReferenceTestDialog.this.mainScreenPrintStream.println("Request change analysis (" + item + ") on: " + iResource.getFullPath());
                            int style = 0;
                            if (selectedIndex == 0) {
                                style |= 1;
                            } else if (selectedIndex == 1) {
                                style |= 2;
                            } else if (selectedIndex == 2) {
                                style |= 4;
                            }
                            ReferenceTestDialog.this.requestIndex(iResource, style);
                        }
                        return Status.OK_STATUS;
                    }
                };
                updateJob.schedule();
            }
        });
        Button dumpDatabase = new Button(leftPanel, 8);
        dumpDatabase.setText("Dump Database");
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)dumpDatabase);
        dumpDatabase.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ReferenceTestDialog.this.autoclear) {
                    ReferenceTestDialog.this.clearMainConsole();
                }
                Job printDb = new Job("PrintDb"){

                    protected IStatus run(IProgressMonitor monitor) {
                        InternalAPI.printDatabase((PrintStream)ReferenceTestDialog.this.mainScreenPrintStream);
                        return Status.OK_STATUS;
                    }
                };
                printDb.setSystem(true);
                printDb.schedule();
            }
        });
        Group g = new Group(leftPanel, 0);
        g.setText("Dump indices");
        g.setLayout((Layout)new GridLayout());
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)g);
        List files = InternalAPI.getIndexes();
        Collections.sort(files);
        for (File indexFile : files) {
            Button dumpIndex = new Button((Composite)g, 8);
            GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)dumpIndex);
            dumpIndex.setText(indexFile.getName());
            dumpIndex.setData((Object)indexFile);
            dumpIndex.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (ReferenceTestDialog.this.autoclear) {
                        ReferenceTestDialog.this.clearMainConsole();
                    }
                    final boolean d = dumpLinks.getSelection();
                    Button button = (Button)e.getSource();
                    final File file = (File)button.getData();
                    try {
                        PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                InternalAPI.printIndex((File)file, (PrintStream)ReferenceTestDialog.this.mainScreenPrintStream, (boolean)d);
                            }
                        });
                    }
                    catch (Exception ee) {
                        ee.printStackTrace(ReferenceTestDialog.this.mainScreenPrintStream);
                    }
                }
            });
        }
        leftPanel.setSize(scrolled.computeSize(-1, -1));
        scrolled.setMinSize(leftPanel.computeSize(-1, -1));
        defaults.generateLayout(leftPanel);
        this.createLogViewer(defaults, horizontal);
        horizontal.setWeights(new int[]{70, 30});
        return col2;
    }

    private void dumpObject() {
        this.id.setText(this.id.getText().trim());
        final String oid = this.id.getText();
        Job dumpJob = new Job("Object details"){

            protected IStatus run(IProgressMonitor monitor) {
                block6: {
                    boolean oldDeproxify = InternalAPI.LOAD_DATA_FOR_TO_STRING;
                    try {
                        try {
                            InternalAPI.LOAD_DATA_FOR_TO_STRING = true;
                            ReferenceTestDialog.this.detailsConsole.clearConsole();
                            Object element = InternalAPI.getObject((int)Integer.parseInt(oid));
                            if (element != null) {
                                ReferenceTestDialog.this.detailsPrintStream.print(element.toString());
                                break block6;
                            }
                            ReferenceTestDialog.this.detailsPrintStream.print("Object not found");
                        }
                        catch (RuntimeException e1) {
                            e1.printStackTrace(ReferenceTestDialog.this.detailsPrintStream);
                            InternalAPI.LOAD_DATA_FOR_TO_STRING = oldDeproxify;
                        }
                    }
                    finally {
                        InternalAPI.LOAD_DATA_FOR_TO_STRING = oldDeproxify;
                    }
                }
                return Status.OK_STATUS;
            }
        };
        dumpJob.schedule();
    }

    private void addLogListener() {
        if (this.listener == null) {
            this.listener = new MyLogListener(this.logConsole.newOutputStream());
            InternalAPI.addLogListener((ILogListener)this.listener);
        }
    }

    private void removeLogListener() {
        if (this.listener != null) {
            InternalAPI.removeLogListener((ILogListener)this.listener);
            OutputStream s = this.listener.getStream();
            if (s != null) {
                try {
                    s.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this.listener = null;
        }
    }

    private IOConsole createConsole() {
        IOConsole c = new IOConsole("MyConsole", null);
        c.addPatternMatchListener(new IPatternMatchListener(){

            public void matchFound(PatternMatchEvent event) {
                IOConsole c = (IOConsole)event.getSource();
                try {
                    String value = c.getDocument().get(event.getOffset(), event.getLength());
                    int oid = 0;
                    if (value.indexOf(":") >= 0) {
                        String[] vals = value.split(":");
                        oid = InternalAPI.doubleUnsignedShortToInt((int)Integer.parseInt(vals[1]), (int)Integer.parseInt(vals[0]));
                    } else {
                        try {
                            oid = Integer.parseInt(value);
                        }
                        catch (Exception exception) {}
                    }
                    if (oid != 0) {
                        final int toid = oid;
                        c.addHyperlink(new IHyperlink(){

                            public void linkExited() {
                            }

                            public void linkEntered() {
                            }

                            public void linkActivated() {
                                ReferenceTestDialog.this.id.setText(Integer.toString(toid));
                                ReferenceTestDialog.this.dumpObject();
                            }
                        }, event.getOffset(), event.getLength());
                    }
                }
                catch (BadLocationException badLocationException) {}
            }

            public void disconnect() {
            }

            public void connect(TextConsole console) {
            }

            public String getPattern() {
                return "[0-9]+:[0-9]+|[0-9]+";
            }

            public String getLineQualifier() {
                return null;
            }

            public int getCompilerFlags() {
                return 0;
            }
        });
        return c;
    }

    private void createLogViewer(GridLayoutFactory defaults, SashForm horizontal) {
        Composite debugTwoCol = new Composite((Composite)horizontal, 2048);
        defaults.copy().numColumns(2).applyTo(debugTwoCol);
        ScrolledComposite scrolled = new ScrolledComposite(debugTwoCol, 2560);
        defaults.applyTo((Composite)scrolled);
        Composite leftDebug = new Composite((Composite)scrolled, 0);
        defaults.applyTo(leftDebug);
        scrolled.setContent((Control)leftDebug);
        scrolled.setExpandHorizontal(true);
        scrolled.setExpandVertical(true);
        GridDataFactory.swtDefaults().align(1, 4).grab(false, true).applyTo((Control)scrolled);
        Composite rightDebug = new Composite(debugTwoCol, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)rightDebug);
        defaults.applyTo(rightDebug);
        this.logConsole = this.createConsole();
        Composite viewerHolder = new Composite(rightDebug, 2048);
        GridLayoutFactory.fillDefaults().applyTo(viewerHolder);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)viewerHolder);
        final IOConsoleViewer logViewer = new IOConsoleViewer(viewerHolder, (TextConsole)this.logConsole);
        logViewer.setAutoScroll(true);
        GridDataFactory.fillDefaults().grab(true, true).applyTo(logViewer.getControl());
        Label label = new Label(leftDebug, 0);
        label.setText("Tracing control options");
        List options = InternalAPI.getDebugOptions();
        for (String o : options) {
            Button option = new Button(leftDebug, 32);
            option.setLayoutData((Object)new GridData(4, 1, true, false));
            option.setText(o);
            option.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Button b = (Button)e.getSource();
                    InternalAPI.setDebugOptionEnabled((String)b.getText(), (boolean)b.getSelection());
                }
            });
            option.setSelection(InternalAPI.isEnabled((String)o));
        }
        leftDebug.setSize(scrolled.computeSize(-1, -1));
        scrolled.setMinSize(leftDebug.computeSize(-1, -1));
        final Button enableListner = new Button(rightDebug, 32);
        enableListner.setText("Display log events");
        enableListner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (enableListner.getSelection()) {
                    ReferenceTestDialog.this.addLogListener();
                } else {
                    ReferenceTestDialog.this.removeLogListener();
                }
            }
        });
        this.addLogListener();
        enableListner.setSelection(true);
        Button autoScroll = new Button(rightDebug, 32);
        autoScroll.setText("Auto Scroll");
        autoScroll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                logViewer.setAutoScroll(((Button)e.getSource()).getSelection());
            }
        });
        autoScroll.setSelection(logViewer.getAutoScroll());
        Button clearConsole = new Button(rightDebug, 8);
        clearConsole.setText("Clear");
        clearConsole.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReferenceTestDialog.this.logConsole.clearConsole();
            }
        });
        Point pre = leftDebug.computeSize(-1, -1);
        GridDataFactory.fillDefaults().hint(-1, pre.y).applyTo((Control)debugTwoCol);
    }

    public void clearMainConsole() {
        this.mainScreen.clearConsole();
    }

    protected Point getInitialSize() {
        Point p = new Point(1100, 800);
        return p;
    }

    class MyLogListener
    implements ILogListener {
        private Text thetext;
        private IOConsoleOutputStream newOutputStream;

        public MyLogListener(Text text) {
            this.thetext = text;
        }

        public MyLogListener(IOConsoleOutputStream newOutputStream) {
            this.newOutputStream = newOutputStream;
        }

        public OutputStream getStream() {
            return this.newOutputStream;
        }

        public void logging(final IStatus status, String plugin) {
            if (this.newOutputStream != null) {
                try {
                    this.newOutputStream.write((String.valueOf(status.getMessage()) + "\n").getBytes());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!MyLogListener.this.thetext.isDisposed()) {
                            MyLogListener.this.thetext.append(String.valueOf(status.getMessage()) + "\n");
                        }
                    }
                });
            }
        }
    }
}

