/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.qev.view;

import com.ibm.etools.qev.Debug;
import com.ibm.etools.qev.EventsConstants;
import com.ibm.etools.qev.actions.SimpleAction;
import com.ibm.etools.qev.edit.EventEditManager;
import com.ibm.etools.qev.model.IEvent;
import com.ibm.etools.qev.model.IEventList;
import com.ibm.etools.qev.model.IEventModelListener;
import com.ibm.etools.qev.model.IEventModelProvider;
import com.ibm.etools.qev.model.impl.EventModelProvider;
import com.ibm.etools.qev.model.impl.NullEvent;
import com.ibm.etools.qev.nls.ResourceHandler;
import com.ibm.etools.qev.view.BreakApartActionAction;
import com.ibm.etools.qev.view.DeleteActionAction;
import com.ibm.etools.qev.view.EditActionVariablesAction;
import com.ibm.etools.qev.view.EditorPanel;
import com.ibm.etools.qev.view.EventListFilter;
import com.ibm.etools.qev.view.EventListPanel;
import com.ibm.etools.qev.view.FilterAction;
import com.ibm.etools.qev.view.NewSimpleActionMenu;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.IContributedContentsView;
import org.eclipse.ui.part.ViewPart;

public class QEVView
extends ViewPart
implements IEventModelListener,
IPartListener2,
ISelectionChangedListener,
ISaveablePart2 {
    private static final String VIEWTITLE_EVENT_END = "]";
    private static final String VIEWTITLE_EVENT_BEGIN = " [";
    private String viewTitle = ResourceHandler.Events_View_Title;
    private IEditorPart currentPart;
    private IEventModelProvider eventModelProvider;
    private IEventList currentEventList;
    private IEventList latestEventList;
    private IEvent currentEvent;
    private IEvent badCurrentEvent;
    private EventListFilter filter = new EventListFilter();
    private String currentLanguage = null;
    private SashForm viewPanel;
    private EventListPanel eventsListPanel;
    private EditorPanel editorPanel;
    private boolean dontSaveScript = false;
    private boolean ignoreSelectionChange = false;
    protected Action filterAction = null;
    protected EditActionVariablesAction editActionAction = null;
    protected DeleteActionAction deleteActionAction = null;
    protected NewSimpleActionMenu insertNewActionsMenu = null;
    protected BreakApartActionAction breakApartActionAction = null;
    private final IPropertyListener fEditorPropertyListener = new IPropertyListener(){

        public void propertyChanged(Object source, int propId) {
            if (propId == 257) {
                QEVView.this.firePropertyChange(257);
            }
        }
    };

    public static QEVView getViewInstance() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && window.getActivePage() != null) {
            IViewPart eventViewPart;
            IViewReference[] viewRefs = window.getActivePage().getViewReferences();
            IViewReference eventViewRef = null;
            int i = 0;
            while (i < viewRefs.length) {
                if (viewRefs[i].getId().equals("com.ibm.etools.qev.view.QEVView")) {
                    eventViewRef = viewRefs[i];
                }
                ++i;
            }
            if (eventViewRef != null && (eventViewPart = eventViewRef.getView(true)) != null && eventViewPart instanceof QEVView) {
                return (QEVView)eventViewPart;
            }
        }
        return null;
    }

    public void cancelScript() {
        this.refreshUI(this.getCurrentEvent());
    }

    private void clearEditor() {
        this.setCurrentEvent(null);
        this.currentLanguage = null;
        this.getEditManager().clearEditor();
        this.editorPanel.setupPanelForDefault(EventsConstants.NO_SCRIPT_TO_EDIT);
        this.updateViewTitle();
        this.updateViewToolbar();
        this.editorPanel.setEnabled(false);
    }

    private void createControls(Composite parent) {
        this.viewPanel = new SashForm(parent, 256);
        this.eventsListPanel = new EventListPanel((Composite)this.viewPanel, 0);
        this.editorPanel = new EditorPanel((Composite)this.viewPanel, 0);
        this.editorPanel.setupEditorPanel(this.getViewSite());
        int[] formWeights = new int[]{15, 85};
        this.viewPanel.setWeights(formWeights);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.viewPanel, "com.ibm.etools.qev.qedv1000");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.eventsListPanel, "com.ibm.etools.qev.qedv1100");
    }

    public void createPartControl(Composite parent) {
        this.createControls(parent);
        this.setupViewMenu();
        this.setupViewToolbar();
        this.setDefaultUIState();
        this.getViewSite().getPage().addPartListener((IPartListener2)this);
        this.getEventTableViewer().addSelectionChangedListener((ISelectionChangedListener)this);
        this.doSetupForEditor(this.getViewSite().getPage().getActiveEditor());
        this.getEditManager().addPropertyListener(this.fEditorPropertyListener);
    }

    public void dispose() {
        if (this.eventModelProvider != null) {
            this.eventModelProvider.removeEventModelListener(this);
        }
        this.getEditManager().removePropertyListener(this.fEditorPropertyListener);
        if (this.getEditManager().getEditor() != null) {
            this.getEditManager().getEditor().dispose();
        }
        this.getViewSite().getPage().removePartListener((IPartListener2)this);
        if (this.getEventTableViewer() != null) {
            this.getEventTableViewer().removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        super.dispose();
        this.eventModelProvider = null;
        this.setCurrentPart(null);
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.isDirty()) {
            this.saveScript();
            this.getEditManager().doSave(monitor);
            if (this.currentPart != null) {
                IWorkbenchPage page = this.currentPart.getSite().getPage();
                page.saveEditor(this.currentPart, false);
            }
            this.getEditManager().setIgnoreOneCycle(true);
        }
    }

    public void doSaveAs() {
    }

    public void doSetupForEditor(IEditorPart editorPart) {
        Debug.trace("view", "QEVView#doSetupForEditor");
        if (editorPart != null) {
            this.setCurrentPart(editorPart);
            IEventModelProvider newEventModelProvider = (IEventModelProvider)editorPart.getAdapter(IEventModelProvider.class);
            if (this.eventModelProvider == newEventModelProvider) {
                return;
            }
            if (this.eventModelProvider != null) {
                this.eventModelProvider.removeEventModelListener(this);
            }
            this.eventModelProvider = newEventModelProvider;
            if (this.eventModelProvider != null) {
                ((EventModelProvider)this.eventModelProvider).setEditorPart(editorPart);
                this.eventModelProvider.addEventModelListener(this);
                return;
            }
        }
        this.setDefaultUIState();
    }

    public void errorClearEditor() {
        IEvent theBad = this.getCurrentEvent();
        this.setCurrentEvent(null);
        this.badCurrentEvent = theBad;
        this.currentLanguage = null;
        this.getEditManager().clearEditor();
        this.editorPanel.setupPanelForDefault(EventsConstants.PROBLEMS_ENCOUNTERED_WITH_THIS_SCRIPT);
        this.updateViewTitle();
        this.updateViewToolbar();
        this.editorPanel.setEnabled(false);
    }

    @Override
    public void eventModelChanged(IEventList eventList) {
        Debug.trace("view", "QEVView#eventModelChanged()");
        this.saveScript(false);
        this.refreshUI(eventList);
    }

    @Override
    public void eventModelDirtyStateChanged(boolean isDirty) {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                QEVView.this.firePropertyChange(257);
            }
        });
    }

    @Override
    public void eventModelReset() {
        Debug.trace("view", "QEVView#eventModelReset()");
        this.refreshUI(this.currentEventList);
    }

    private ArrayList getActions() {
        return this.getEditManager().getActions();
    }

    public Object getAdapter(Class adapter) {
        if (this.currentPart != null && IContributedContentsView.class.equals((Object)adapter)) {
            return new IContributedContentsView(){

                public IWorkbenchPart getContributingPart() {
                    return QEVView.this.currentPart;
                }
            };
        }
        return super.getAdapter(adapter);
    }

    protected BreakApartActionAction getBreakApartActionAction() {
        if (this.breakApartActionAction == null) {
            this.breakApartActionAction = new BreakApartActionAction();
        }
        return this.breakApartActionAction;
    }

    public IEvent getCurrentEvent() {
        return this.currentEvent;
    }

    public String getCurrentLanguage() {
        return this.currentLanguage;
    }

    protected DeleteActionAction getDeleteActionAction() {
        if (this.deleteActionAction == null) {
            this.deleteActionAction = new DeleteActionAction();
        }
        return this.deleteActionAction;
    }

    protected EditActionVariablesAction getEditActionAction() {
        if (this.editActionAction == null) {
            this.editActionAction = new EditActionVariablesAction();
        }
        return this.editActionAction;
    }

    public EventEditManager getEditManager() {
        return this.editorPanel.getEditManager();
    }

    public TableViewer getEventTableViewer() {
        return this.eventsListPanel.getViewer();
    }

    protected Action getFilterAction() {
        if (this.filterAction == null) {
            this.filterAction = new FilterAction(this.filter, this.getEventTableViewer());
        }
        return this.filterAction;
    }

    private IEvent getInitialEvent(TableViewer eventTableViewer) {
        IEvent firstEvent = (IEvent)eventTableViewer.getElementAt(0);
        boolean foundScripted = false;
        int i = 0;
        while (i < eventTableViewer.getTable().getItemCount() && !foundScripted) {
            IEvent tempEvent = (IEvent)eventTableViewer.getElementAt(i);
            if (tempEvent.isScripted()) {
                firstEvent = tempEvent;
                foundScripted = true;
            }
            ++i;
        }
        return firstEvent;
    }

    public IEventModelProvider getModelProvider() {
        return this.eventModelProvider;
    }

    private NewSimpleActionMenu getNewActionMenu() {
        if (this.insertNewActionsMenu == null) {
            this.insertNewActionsMenu = new NewSimpleActionMenu(this.getEditManager());
        }
        return this.insertNewActionsMenu;
    }

    private String getScript() {
        return this.getEditManager().getScript();
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        if (memento != null) {
            this.filter.restoreState(memento);
        }
    }

    private boolean isDirtiable() {
        return this.getCurrentEvent() != null && !this.getCurrentEvent().isReadOnly() && this.getEditManager().getCurrentOffset() > -1;
    }

    public boolean isDirty() {
        return this.currentPart != null && this.currentPart.isDirty() || this.isQEVDirty();
    }

    public boolean isQEVDirty() {
        if (this.isDirtiable()) {
            return this.getEditManager().isDirty();
        }
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return this.isQEVDirty();
    }

    public void partActivated(IWorkbenchPartReference partRef) {
        if (partRef.getPart(false) instanceof IEditorPart) {
            this.doSetupForEditor((IEditorPart)partRef.getPart(false));
        }
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
        if (partRef.getPart(false) instanceof IEditorPart) {
            this.doSetupForEditor((IEditorPart)partRef.getPart(false));
        }
    }

    public void partClosed(IWorkbenchPartReference partRef) {
        Debug.trace("view", "QEVView#partClosed");
        if (partRef.getPart(false) instanceof IEditorPart && this.currentPart != null && this.currentPart.equals(partRef.getPart(false))) {
            if (this.eventModelProvider != null) {
                this.eventModelProvider.removeEventModelListener(this);
                this.eventModelProvider = null;
            }
            this.setCurrentPart(null);
            this.setDefaultUIState();
        }
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
    }

    public void partHidden(IWorkbenchPartReference partRef) {
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
    }

    public void partOpened(IWorkbenchPartReference partRef) {
    }

    public void partVisible(IWorkbenchPartReference partRef) {
        if (partRef.getPart(false) == this && this.latestEventList != null) {
            this.refreshUI(this.latestEventList);
        }
    }

    public int promptToSaveOnClose() {
        return 3;
    }

    private void refreshUI(IEvent event) {
        Debug.trace("view", "QEVView#refreshUI(IEvent)");
        if (!this.editorPanel.isVisible()) {
            Debug.trace("view", "Call to refreshUI when editor is not visible");
            return;
        }
        if (event == null) {
            Debug.trace("view", "QEVView#refreshUI(event) - event was null!");
            this.clearEditor();
            return;
        }
        this.currentLanguage = event.getLanguage();
        this.setCurrentEvent(event);
        this.updateViewTitle();
        this.setupEditor(event);
        this.updateViewToolbar();
    }

    private void refreshUI(IEventList eventList) {
        this.refreshUI(eventList, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void refreshUI(IEventList eventList, IEvent eventToSelect) {
        Debug.trace("view", "EventView#refreshUI(IEventList)");
        if (!this.editorPanel.isVisible()) {
            Debug.trace("view", "Call to refreshUI when editor is not visible");
            this.latestEventList = eventList;
            return;
        }
        if (Display.getCurrent() == null) {
            Debug.trace("view", "Call to refreshUI from non-UI thread");
            return;
        }
        try {
            IEvent eventInList;
            this.dontSaveScript = true;
            TableViewer eventTableViewer = this.getEventTableViewer();
            if (eventList == null && this.currentEventList != null) {
                this.currentEventList = null;
                this.latestEventList = null;
                this.setDefaultUIState();
                return;
            }
            this.ignoreSelectionChange = true;
            if (eventList != null && !eventList.equals(this.currentEventList)) {
                this.currentEventList = eventList;
                this.latestEventList = null;
                eventTableViewer.setInput((Object)this.currentEventList);
                if (eventTableViewer.getFilters().length == 0) {
                    eventTableViewer.addFilter((ViewerFilter)this.filter);
                }
                this.setCurrentEvent(null);
            }
            eventTableViewer.refresh(true);
            if (eventTableViewer.getTable().getItemCount() == 0) {
                this.clearEditor();
                return;
            }
            if (eventToSelect == null) {
                eventToSelect = this.getCurrentEvent();
            }
            if (!eventTableViewer.getSelection().isEmpty()) {
                StructuredSelection sel = (StructuredSelection)eventTableViewer.getSelection();
                IEvent selectedEvent = (IEvent)sel.getFirstElement();
                if (eventToSelect == null || selectedEvent.getID().equals(eventToSelect.getID())) {
                    this.refreshUI(selectedEvent);
                    return;
                }
            }
            if (eventToSelect != null && (eventInList = this.currentEventList.getEvent(eventToSelect.getID())) != null) {
                this.selectEvent(eventInList);
                this.refreshUI(eventInList);
                return;
            }
            IEvent defaultEvent = this.getInitialEvent(eventTableViewer);
            this.selectEvent(defaultEvent);
            this.refreshUI(defaultEvent);
            return;
        }
        finally {
            this.dontSaveScript = false;
            this.ignoreSelectionChange = false;
        }
    }

    public void saveScript() {
        this.saveScript(true);
    }

    public void saveScript(boolean refresh) {
        Debug.trace("view", "EventView#saveScript()");
        if (!this.dontSaveScript && this.getCurrentEvent() != null && this.editorPanel != null && this.editorPanel.getCurrentEditor() != null) {
            try {
                Debug.trace("view", "EventView#saveScript() - updating event:" + this.getCurrentEvent().getID());
                this.updateEventInModel(this.getScript(), this.currentLanguage, this.getActions());
                if (refresh) {
                    this.refreshUI(this.currentEventList);
                }
            }
            catch (Exception e) {
                Debug.log(202, "Exception occurred while updating event: " + this.getCurrentEvent().getDisplayName(), e);
            }
        }
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        if (memento != null) {
            this.filter.saveState(memento);
        }
    }

    public void selectEvent(IEvent event) {
        this.getEventTableViewer().setSelection((ISelection)new StructuredSelection((Object)event), true);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (!this.ignoreSelectionChange) {
            StructuredSelection selection = (StructuredSelection)event.getSelection();
            Object o = selection.getFirstElement();
            if (o instanceof IEvent) {
                IEvent selectedEvent = (IEvent)o;
                IEvent eventToCompare = null;
                eventToCompare = this.getCurrentEvent() != null ? this.getCurrentEvent() : this.badCurrentEvent;
                if (selectedEvent != eventToCompare) {
                    this.selectNewEvent(selectedEvent);
                } else {
                    Debug.trace("view", "selectionChanged: same event so selection ignored");
                }
            } else if (o == null) {
                this.selectNewEvent(null);
            }
        }
    }

    private void selectNewEvent(IEvent event) {
        this.saveScript(false);
        this.refreshUI(this.currentEventList, event);
    }

    private void setCurrentEvent(IEvent event) {
        this.currentEvent = event;
        this.badCurrentEvent = null;
    }

    protected void setCurrentLanguage(String lang) {
        if (this.currentLanguage == lang) {
            return;
        }
        this.currentLanguage = lang;
        this.updateViewTitle();
        this.getEditManager().switchEditorLanguage(this.currentLanguage);
    }

    private void setCurrentPart(IEditorPart part) {
        this.currentPart = part;
        if (part != null) {
            this.getViewSite().setSelectionProvider(part.getSite().getSelectionProvider());
        } else {
            this.getViewSite().setSelectionProvider(null);
        }
    }

    private void setDefaultUIState() {
        this.getEventTableViewer().add((Object)new NullEvent());
        this.getEventTableViewer().setInput(null);
        this.currentEventList = null;
        this.latestEventList = null;
        this.clearEditor();
        this.setEnabled(false);
    }

    private void setEnabled(boolean enabled) {
        this.editorPanel.setEnabled(enabled);
    }

    public void setFocus() {
        this.getEventTableViewer().getControl().setFocus();
    }

    private void setupEditor(IEvent event) {
        try {
            this.getEditManager().setEditorEnvironment(event, this.currentLanguage);
            this.setEnabled(true);
        }
        catch (Exception e) {
            Debug.log(202, "exception found during editor setup", e);
            this.errorClearEditor();
        }
    }

    private void setupViewMenu() {
        IMenuManager menuManager = this.getViewSite().getActionBars().getMenuManager();
        menuManager.add((IAction)this.getFilterAction());
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IContributionItem)this.getNewActionMenu());
        menuManager.add((IAction)this.getEditActionAction());
        menuManager.add((IAction)this.getBreakApartActionAction());
        menuManager.add((IAction)this.getDeleteActionAction());
        menuManager.add((IContributionItem)new Separator());
        menuManager.addMenuListener((IMenuListener)new EventsViewMenuListener());
    }

    private void setupViewToolbar() {
    }

    protected void updateEventInModel(String eventScript, String language, ArrayList actions) {
        if (this.getCurrentEvent() != null && this.getCurrentEvent().getEventUpdater() != null) {
            this.getCurrentEvent().getEventUpdater().updateModel(this.getCurrentEvent(), eventScript, language, actions);
        }
    }

    void updateViewMenu() {
        this.getNewActionMenu().setCurrentEvent(this.getCurrentEvent());
        SimpleAction a = this.getEditManager().getActionAtOffset(this.getEditManager().getCurrentOffset());
        this.getEditActionAction().setSimpleAction(a);
        this.getBreakApartActionAction().setSimpleAction(a);
        this.getDeleteActionAction().setSimpleAction(a);
    }

    protected void updateViewTitle() {
        if (this.currentEventList == null) {
            this.setContentDescription(this.viewTitle);
        } else {
            this.setContentDescription(String.valueOf(this.viewTitle) + VIEWTITLE_EVENT_BEGIN + this.currentEventList.getName() + VIEWTITLE_EVENT_END);
        }
    }

    private void updateViewToolbar() {
    }

    protected class EventsViewMenuListener
    implements IMenuListener {
        protected EventsViewMenuListener() {
        }

        public void menuAboutToShow(IMenuManager manager) {
            QEVView.this.updateViewMenu();
        }
    }
}

