/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.qev.view;

import com.ibm.etools.qev.Debug;
import com.ibm.etools.qev.EventsConstants;
import com.ibm.etools.qev.edit.EventEditManager;
import com.ibm.etools.qev.edit.IEventsViewEditor;
import com.ibm.etools.qev.edit.QEVEditorEditorSite;
import com.ibm.etools.qev.nls.ResourceHandler;
import com.ibm.etools.qev.registry.DefinitionsRegistry;
import com.ibm.etools.qev.registry.QEVEditorDefinition;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPartSite;

public class EditorPanel
extends Composite
implements EventsConstants {
    private final String NO_EDITOR_FOUND = ResourceHandler.EditorPanel_0;
    private Text defaultText;
    private HashMap editorIdToEditorMap = new HashMap();
    private IEventsViewEditor currentEditor = null;
    private EventEditManager editManager = null;
    private IViewSite fViewSite = null;
    private final StackLayout layout = new StackLayout();
    String[] fQEVScopes = new String[]{"org.eclipse.ui.globalScope"};
    String[] fEditorScopes;
    private FocusListener fFocusListener = new FocusListener(){

        public void focusGained(FocusEvent e) {
            Debug.trace("view", "EditorPanel.focusGained");
            if (EditorPanel.this.fEditorScopes != null) {
                if (EditorPanel.this.fEditorScopes != null && EditorPanel.this.fEditorScopes.length > 0) {
                    EditorPanel.this.getSite().getKeyBindingService().setScopes(EditorPanel.this.fEditorScopes);
                }
                EditorPanel.this.firePartNotification();
            }
        }

        public void focusLost(FocusEvent e) {
            Debug.trace("view", "EditorPanel.focusLost");
            if (EditorPanel.this.fQEVScopes != null && EditorPanel.this.fEditorScopes.length > 0) {
                EditorPanel.this.getSite().getKeyBindingService().setScopes(EditorPanel.this.fEditorScopes);
            }
            EditorPanel.this.firePartNotification();
        }
    };

    public EditorPanel(Composite parent, int style) {
        super(parent, style);
        this.createControls(this);
    }

    private IEventsViewEditor addEditor(QEVEditorDefinition def) {
        IEventsViewEditor newEditor = null;
        if (def != null && (newEditor = (IEventsViewEditor)this.editorIdToEditorMap.get(def.getEditorId())) == null && (newEditor = def.createQEVEditor()) != null) {
            QEVEditorEditorSite nestedSite = new QEVEditorEditorSite(this.fViewSite);
            newEditor.setupEditorControl((IWorkbenchPartSite)nestedSite, this, 0);
            this.editorIdToEditorMap.put(def.getEditorId(), newEditor);
        }
        return newEditor;
    }

    private void createControls(Composite parent) {
        parent.setLayoutData((Object)new GridData(1808));
        parent.setLayout((Layout)this.layout);
    }

    public void dispose() {
        if (this.getCurrentEditor() != null && this.getCurrentEditor().getSourceViewer() != null && this.getCurrentEditor().getSourceViewer().getTextWidget() != null) {
            this.getCurrentEditor().getSourceViewer().getTextWidget().removeFocusListener(this.fFocusListener);
        }
        Iterator editors = this.editorIdToEditorMap.values().iterator();
        while (editors.hasNext()) {
            ((IEventsViewEditor)editors.next()).dispose();
            editors.remove();
        }
        super.dispose();
    }

    void firePartNotification() {
        Event e = new Event();
        e.type = 26;
        this.fViewSite.getShell().notifyListeners(26, e);
    }

    public IEventsViewEditor getCurrentEditor() {
        return this.currentEditor;
    }

    public EventEditManager getEditManager() {
        return this.editManager;
    }

    public IWorkbenchPartSite getSite() {
        return this.fViewSite;
    }

    public Control getTopControl() {
        return this.layout.topControl;
    }

    public void setEnabled(boolean enabled) {
        if (this.getCurrentEditor() != null) {
            this.getCurrentEditor().getSourceViewer().getTextWidget().setEnabled(enabled);
        }
        super.setEnabled(enabled);
    }

    public void setupEditorPanel(IViewSite site) {
        this.fViewSite = site;
        this.editManager = new EventEditManager();
        this.editManager.init(this);
        this.defaultText = new Text((Composite)this, 776);
        this.layout.topControl = this.defaultText;
        this.currentEditor = null;
    }

    public void setupPanelForDefault(String message) {
        if (this.currentEditor != null) {
            this.currentEditor.editorDeactivated();
            if (this.currentEditor.getSourceViewer() != null && this.currentEditor.getSourceViewer().getTextWidget() != null) {
                this.currentEditor.getSourceViewer().getTextWidget().removeFocusListener(this.fFocusListener);
            }
            this.firePartNotification();
            this.currentEditor = null;
        }
        if (message != null && !message.equals(this.defaultText.getText())) {
            this.defaultText.setText(message);
        }
        if (this.layout.topControl != this.defaultText) {
            this.layout.topControl = this.defaultText;
            this.layout();
        }
    }

    protected void setupPanelForEditor(IEventsViewEditor editor) {
        if (this.currentEditor != null) {
            this.currentEditor.editorDeactivated();
            if (this.currentEditor.getSourceViewer() != null && this.currentEditor.getSourceViewer().getTextWidget() != null) {
                this.currentEditor.getSourceViewer().getTextWidget().removeFocusListener(this.fFocusListener);
            }
            this.firePartNotification();
        }
        this.currentEditor = editor;
        this.layout.topControl = this.currentEditor.getControl();
        this.layout();
        this.currentEditor.editorActivated();
        this.fEditorScopes = this.getSite().getKeyBindingService().getScopes();
        if (this.currentEditor.getSourceViewer() != null && this.currentEditor.getSourceViewer().getTextWidget() != null) {
            this.currentEditor.getSourceViewer().getTextWidget().addFocusListener(this.fFocusListener);
        }
        this.firePartNotification();
    }

    public void showDefaultEditorForLanguage(String language) {
        QEVEditorDefinition def = DefinitionsRegistry.getRegistry().getEditor(language);
        IEventsViewEditor newEditor = this.addEditor(def);
        if (this.currentEditor != newEditor && newEditor != null) {
            Debug.trace("view", "switching editor: " + this.currentEditor + "  new editor: " + newEditor);
            this.setupPanelForEditor(newEditor);
        }
        if (newEditor == null) {
            Debug.log(202, "Error loading default editor for language: " + language);
            this.setupPanelForDefault(this.NO_EDITOR_FOUND);
        }
    }
}

