/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.qev.util;

import com.ibm.etools.qev.model.adapters.EventsDocumentAdapter;
import java.util.Iterator;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class TextNodeUtil {
    public static Node createChildTextNode(Node n) {
        Document d = n.getOwnerDocument();
        Text textNode = d.createTextNode("");
        n.appendChild(textNode);
        return textNode;
    }

    public static Node findChildTextNode(Node n) {
        Node candidateNode = null;
        if (n != null) {
            Node child = n.getFirstChild();
            while (child != null) {
                if (child.getNodeType() == 3) {
                    candidateNode = child;
                    break;
                }
                child = child.getNextSibling();
            }
        }
        return candidateNode;
    }

    public static String generateUniqueFunctionName(EventsDocumentAdapter pageInfo) {
        int maxFunctionNumber = 0;
        if (pageInfo != null) {
            Iterator names = pageInfo.getFunctionNames();
            while (names.hasNext()) {
                String name = (String)names.next();
                if (!name.startsWith("func_")) continue;
                String candidateString = name.substring("func_".length(), name.length());
                try {
                    int candidateValue = Integer.parseInt(candidateString);
                    if (candidateValue <= maxFunctionNumber) continue;
                    maxFunctionNumber = candidateValue;
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        return "func_" + String.valueOf(maxFunctionNumber + 1);
    }
}

