/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.qev.registry;

import com.ibm.etools.qev.Debug;
import com.ibm.etools.qev.QEVPlugin;
import com.ibm.etools.qev.registry.ActionDefinition;
import com.ibm.etools.qev.registry.DetectorDefinition;
import com.ibm.etools.qev.registry.EventCategoryDefinition;
import com.ibm.etools.qev.registry.EventDefinition;
import com.ibm.etools.qev.registry.ModelBuilderDefinition;
import com.ibm.etools.qev.registry.QEVEditorDefinition;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.memory.LowMemoryListener;
import org.eclipse.equinox.memory.MemoryManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.osgi.framework.Bundle;

public class DefinitionsRegistry {
    private static DefinitionsRegistry registry;
    private HashMap eventIdsToDefsMap = new HashMap();
    private HashMap categoryIdsToDefsMap = new HashMap();
    private HashMap actionIdsToDefsMap = new HashMap();
    private HashMap builderIdsToDefsMap = new HashMap();
    private HashMap languageToEditorMap = new HashMap();
    private HashMap detectorIdsToDefsMap = new HashMap();
    private boolean cached = false;
    private boolean caching = false;
    private QEVLowMemoryListener qEVLowMemoryListener = new QEVLowMemoryListener();

    private DefinitionsRegistry() {
        MemoryManager.addLowMemoryListener((LowMemoryListener)this.qEVLowMemoryListener);
    }

    public static DefinitionsRegistry getRegistry() {
        if (registry == null) {
            registry = new DefinitionsRegistry();
            registry.loadDefinitions();
        }
        return registry;
    }

    private void addAction(IConfigurationElement element) {
        ImageRegistry imageReg;
        Bundle bundle;
        String actionID = element.getAttribute("id");
        String actionClassString = element.getAttribute("class");
        String displayName = element.getAttribute("displayName");
        String iconPath = element.getAttribute("icon");
        String language = element.getAttribute("language");
        String dialogClassName = element.getAttribute("dialogClass");
        String extractorName = element.getAttribute("detectorID");
        if (this.actionIdsToDefsMap.containsKey(actionID)) {
            Debug.log(2, "Action '" + actionID + "' already defined - duplicate contribution ignored.");
            return;
        }
        ImageDescriptor iconDescriptor = null;
        String declaringPluginId = element.getDeclaringExtension().getNamespace();
        if (declaringPluginId != null && (bundle = Platform.getBundle((String)declaringPluginId)) != null) {
            iconDescriptor = this.getImageDescriptorFromPluginPath(bundle, iconPath);
        }
        if ((imageReg = QEVPlugin.getDefault().getImageRegistry()).get(actionID) == null) {
            imageReg.put(actionID, iconDescriptor);
        }
        ActionDefinition newAction = new ActionDefinition();
        newAction.setActionID(actionID);
        newAction.setActionClassName(actionClassString);
        newAction.setActionName(displayName);
        newAction.setIconKey(actionID);
        newAction.setLanguage(language);
        newAction.setDialogClass(dialogClassName);
        newAction.setConfigurationElement(element);
        newAction.setDetectorId(extractorName);
        this.actionIdsToDefsMap.put(actionID, newAction);
    }

    private void addActionEventMapping(ActionDefinition actionDef, EventDefinition eventDef) {
        if (eventDef != null) {
            if (!eventDef.containsActionMapping(actionDef)) {
                eventDef.addAction(actionDef);
            }
            if (!actionDef.containsEventMapping(eventDef)) {
                actionDef.addEvent(eventDef);
            }
        }
    }

    private void addActionMapping(String actionID, IConfigurationElement element) {
        ActionDefinition actionDef = this.getAction(actionID);
        if (actionDef == null) {
            return;
        }
        if (element.getAttribute("eventID") != null) {
            String eventID = element.getAttribute("eventID");
            this.addActionEventMapping(actionDef, this.getEvent(eventID));
        } else if (element.getAttribute("categoryID") != null) {
            String categoryID = element.getAttribute("categoryID");
            EventCategoryDefinition catDef = this.getEventCategory(categoryID);
            if (catDef == null) {
                return;
            }
            Iterator eventsIter = catDef.getEvents();
            while (eventsIter.hasNext()) {
                this.addActionEventMapping(actionDef, (EventDefinition)eventsIter.next());
            }
        }
    }

    private void addBuilder(IConfigurationElement element) {
        StringTokenizer tokenizer;
        String builderID = element.getAttribute("id");
        String builderClassString = element.getAttribute("class");
        String taglibUris = element.getAttribute("taglibUri");
        String facetIds = element.getAttribute("facets");
        if (this.builderIdsToDefsMap.containsKey(builderID)) {
            Debug.log(2, "Event builder " + builderID + " already defined.");
            return;
        }
        ModelBuilderDefinition newBuilder = new ModelBuilderDefinition();
        newBuilder.setBuilderID(builderID);
        newBuilder.setBuilderClassName(builderClassString);
        newBuilder.setConfigurationElement(element);
        if (taglibUris != null) {
            if (taglibUris.trim().length() == 0) {
                newBuilder.addURI("");
            } else {
                tokenizer = new StringTokenizer(taglibUris, ",");
                while (tokenizer.hasMoreTokens()) {
                    String uri = tokenizer.nextToken().trim();
                    newBuilder.addURI(uri);
                }
            }
        }
        if (facetIds != null && facetIds.trim().length() > 0) {
            tokenizer = new StringTokenizer(facetIds, ",");
            while (tokenizer.hasMoreTokens()) {
                String facet = tokenizer.nextToken().trim();
                newBuilder.addFacet(facet);
            }
        }
        this.builderIdsToDefsMap.put(builderID, newBuilder);
    }

    private void addDetector(IConfigurationElement element) {
        String detectorId = element.getAttribute("id");
        String detectorName = element.getAttribute("name");
        String detectorClassString = element.getAttribute("class");
        if (this.detectorIdsToDefsMap.containsKey(detectorId)) {
            Debug.log(2, "Action detector '" + detectorId + "' already defined - duplicate contribution ignored.");
            return;
        }
        DetectorDefinition detector = new DetectorDefinition();
        detector.setDetectorId(detectorId);
        detector.setDetectorName(detectorName);
        detector.setDetectorClassName(detectorClassString);
        detector.setConfigurationElement(element);
        this.detectorIdsToDefsMap.put(detectorId, detector);
    }

    private void addEditor(IConfigurationElement element) {
        String editorId = element.getAttribute("id");
        String editorName = element.getAttribute("name");
        String editorClassString = element.getAttribute("class");
        String languages = element.getAttribute("languages");
        if (languages != null) {
            StringTokenizer tokenizer = new StringTokenizer(languages, ",");
            while (tokenizer.hasMoreTokens()) {
                String language = tokenizer.nextToken().trim().toLowerCase();
                if (this.languageToEditorMap.containsKey(language)) {
                    Debug.log(2, "language to editor mapping '" + language + "' already defined - duplicate contribution ignored.");
                    continue;
                }
                QEVEditorDefinition newEditor = new QEVEditorDefinition();
                newEditor.setEditorId(editorId);
                newEditor.setLanguage(language);
                newEditor.setEditorClassName(editorClassString);
                newEditor.setEditorName(editorName);
                newEditor.setConfigurationElement(element);
                this.languageToEditorMap.put(language, newEditor);
            }
        }
    }

    private void addEvent(String catID, IConfigurationElement element) {
        String eventID = element.getAttribute("id");
        if (this.eventIdsToDefsMap.containsKey(eventID)) {
            Debug.log(2, "Event '" + eventID + "' already defined - duplicate contribution ignored..");
            return;
        }
        String eventName = element.getAttribute("name");
        String displayName = element.getAttribute("displayName");
        String eventClassName = element.getAttribute("class");
        EventDefinition newDef = new EventDefinition();
        newDef.setEventID(eventID);
        newDef.setEventName(eventName);
        newDef.setDisplayName(displayName);
        newDef.setEventClassName(eventClassName);
        newDef.setConfigurationElement(element);
        EventCategoryDefinition catDef = this.getEventCategory(catID);
        if (catDef == null) {
            return;
        }
        newDef.setCategory(catDef);
        catDef.addEvent(newDef);
        this.eventIdsToDefsMap.put(eventID, newDef);
    }

    private void addEventCategory(IConfigurationElement element) {
        Bundle bundle;
        String catID = element.getAttribute("id");
        if (this.categoryIdsToDefsMap.containsKey(catID)) {
            Debug.log(2, "Event category '" + catID + "' already defined - duplicate contribution ignored.");
            return;
        }
        String catName = element.getAttribute("name");
        String setIconPath = element.getAttribute("setIcon");
        String unsetIconPath = element.getAttribute("unsetIcon");
        EventCategoryDefinition newDef = new EventCategoryDefinition();
        newDef.setCategoryID(catID);
        newDef.setDisplayName(catName);
        ImageDescriptor setIconDescriptor = null;
        ImageDescriptor unsetIconDescriptor = null;
        String declaringPluginId = element.getDeclaringExtension().getNamespace();
        if (declaringPluginId != null && (bundle = Platform.getBundle((String)declaringPluginId)) != null) {
            setIconDescriptor = this.getImageDescriptorFromPluginPath(bundle, setIconPath);
            unsetIconDescriptor = this.getImageDescriptorFromPluginPath(bundle, unsetIconPath);
        }
        ImageRegistry imageReg = QEVPlugin.getDefault().getImageRegistry();
        String setKey = String.valueOf(catName) + "_set";
        String unsetKey = String.valueOf(catName) + "_unset";
        if (imageReg.get(setKey) == null) {
            imageReg.put(setKey, setIconDescriptor);
        }
        if (imageReg.get(unsetKey) == null) {
            imageReg.put(unsetKey, unsetIconDescriptor);
        }
        newDef.setSetIconKey(setKey);
        newDef.setUnsetIconKey(unsetKey);
        this.categoryIdsToDefsMap.put(catID, newDef);
    }

    private void cache() {
        if (!this.caching && !this.cached) {
            this.loadDefinitions();
        }
    }

    private void clearCache() {
        this.eventIdsToDefsMap.clear();
        this.categoryIdsToDefsMap.clear();
        this.actionIdsToDefsMap.clear();
        this.builderIdsToDefsMap.clear();
        this.languageToEditorMap.clear();
        this.detectorIdsToDefsMap.clear();
        this.cached = false;
    }

    public ActionDefinition getAction(String id) {
        this.cache();
        return (ActionDefinition)this.actionIdsToDefsMap.get(id);
    }

    public Iterator getActions() {
        this.cache();
        return this.actionIdsToDefsMap.values().iterator();
    }

    public ModelBuilderDefinition getBuilder(String id) {
        this.cache();
        return (ModelBuilderDefinition)this.builderIdsToDefsMap.get(id);
    }

    public Iterator getBuilders() {
        this.cache();
        return this.builderIdsToDefsMap.values().iterator();
    }

    public DetectorDefinition getDetector(String id) {
        this.cache();
        if (id != null) {
            return (DetectorDefinition)this.detectorIdsToDefsMap.get(id);
        }
        return null;
    }

    public Iterator getDetectors() {
        this.cache();
        return this.detectorIdsToDefsMap.values().iterator();
    }

    public QEVEditorDefinition getEditor(String language) {
        this.cache();
        if (language != null) {
            language = language.toLowerCase();
            return (QEVEditorDefinition)this.languageToEditorMap.get(language);
        }
        return null;
    }

    public Iterator getEditors() {
        this.cache();
        return this.languageToEditorMap.values().iterator();
    }

    public EventDefinition getEvent(String id) {
        this.cache();
        return (EventDefinition)this.eventIdsToDefsMap.get(id);
    }

    public Iterator getEventCategories() {
        this.cache();
        return this.categoryIdsToDefsMap.values().iterator();
    }

    public EventCategoryDefinition getEventCategory(String id) {
        this.cache();
        return (EventCategoryDefinition)this.categoryIdsToDefsMap.get(id);
    }

    public Iterator getEvents() {
        this.cache();
        return this.eventIdsToDefsMap.values().iterator();
    }

    private ImageDescriptor getImageDescriptorFromPluginPath(Bundle bundle, String pathToImage) {
        URL fullPathString = Platform.find((Bundle)bundle, (IPath)new Path(pathToImage));
        if (fullPathString != null) {
            return ImageDescriptor.createFromURL((URL)fullPathString);
        }
        URL path = bundle.getEntry("/");
        try {
            fullPathString = new URL(path, pathToImage);
            return ImageDescriptor.createFromURL((URL)fullPathString);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    private void loadDefinitions() {
        this.caching = true;
        try {
            int i;
            IConfigurationElement[] elements;
            IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
            IExtensionPoint ep = extensionRegistry.getExtensionPoint("com.ibm.etools.qev", "eventDefinition");
            if (ep != null) {
                elements = ep.getConfigurationElements();
                i = 0;
                while (i < elements.length) {
                    this.processEventCategoryDefinition(elements[i]);
                    ++i;
                }
            }
            if ((ep = extensionRegistry.getExtensionPoint("com.ibm.etools.qev", "simpleAction")) != null) {
                elements = ep.getConfigurationElements();
                i = 0;
                while (i < elements.length) {
                    this.processActionDefinition(elements[i]);
                    ++i;
                }
            }
            if ((ep = extensionRegistry.getExtensionPoint("com.ibm.etools.qev", "actionDetector")) != null) {
                elements = ep.getConfigurationElements();
                i = 0;
                while (i < elements.length) {
                    this.processDetectorDefinition(elements[i]);
                    ++i;
                }
            }
            if ((ep = extensionRegistry.getExtensionPoint("com.ibm.etools.qev", "webeditEventBuilder")) != null) {
                elements = ep.getConfigurationElements();
                i = 0;
                while (i < elements.length) {
                    this.processBuilderDefinition(elements[i]);
                    ++i;
                }
            }
            if ((ep = extensionRegistry.getExtensionPoint("com.ibm.etools.qev", "qevEditor")) != null) {
                elements = ep.getConfigurationElements();
                i = 0;
                while (i < elements.length) {
                    this.processEditorDefinition(elements[i]);
                    ++i;
                }
            }
        }
        finally {
            this.caching = false;
            this.cached = true;
        }
    }

    private void processActionDefinition(IConfigurationElement element) {
        String name = element.getName();
        if (name.equals("action")) {
            this.addAction(element);
            IConfigurationElement[] children = element.getChildren();
            int i = 0;
            while (i < children.length) {
                this.processActionMapping(element.getAttribute("id"), children[i]);
                ++i;
            }
        }
    }

    private void processActionMapping(String actionID, IConfigurationElement element) {
        String name = element.getName();
        if (name.equals("mapping")) {
            this.addActionMapping(actionID, element);
        }
    }

    private void processBuilderDefinition(IConfigurationElement element) {
        String name = element.getName();
        if (name.equals("builder")) {
            this.addBuilder(element);
        }
    }

    private void processDetectorDefinition(IConfigurationElement element) {
        String name = element.getName();
        if (name.equals("detector")) {
            this.addDetector(element);
        }
    }

    private void processEditorDefinition(IConfigurationElement element) {
        String name = element.getName();
        if (name.equals("editor")) {
            this.addEditor(element);
        }
    }

    private void processEventCategoryDefinition(IConfigurationElement element) {
        String name = element.getName();
        if (name.equals("category")) {
            this.addEventCategory(element);
            IConfigurationElement[] children = element.getChildren();
            int i = 0;
            while (i < children.length) {
                this.processEventDefinition(element.getAttribute("id"), children[i]);
                ++i;
            }
        }
    }

    private void processEventDefinition(String catID, IConfigurationElement element) {
        String name = element.getName();
        if (name.equals("event")) {
            this.addEvent(catID, element);
        }
    }

    private class QEVLowMemoryListener
    extends LowMemoryListener {
        private QEVLowMemoryListener() {
        }

        public int getCount() {
            return DefinitionsRegistry.this.eventIdsToDefsMap.size() + DefinitionsRegistry.this.categoryIdsToDefsMap.size() + DefinitionsRegistry.this.actionIdsToDefsMap.size() + DefinitionsRegistry.this.builderIdsToDefsMap.size() + DefinitionsRegistry.this.languageToEditorMap.size() + DefinitionsRegistry.this.detectorIdsToDefsMap.size();
        }

        public String getDescription() {
            return "QEV extension points contributions manager cache";
        }

        public long getSize() {
            return -1L;
        }

        public void memoryIsLow(int severity) {
            if (severity == 2) {
                DefinitionsRegistry.this.clearCache();
            } else if (severity == 3) {
                DefinitionsRegistry.this.clearCache();
            }
        }
    }
}

