/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.qev.model.impl;

import com.ibm.etools.qev.model.IEventEditorInfo;
import com.ibm.etools.qev.model.IEventScriptContext;
import com.ibm.etools.qev.model.IEventUpdater;
import com.ibm.etools.qev.model.impl.HtmlJavascriptContext;
import com.ibm.etools.qev.model.impl.ITagEvent;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.jface.text.Position;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;

public class TagEventImpl
implements ITagEvent,
Comparable {
    private String eventID = null;
    private IEventUpdater updater = null;
    private IDOMNode node = null;
    private boolean scripted = false;
    private String displayName = null;
    private String eventScript = null;
    private String scriptLanguage = null;
    private String description = null;
    private ArrayList allowedLanguages = new ArrayList();
    private Image setIcon = null;
    private Image unsetIcon = null;
    private HashMap scriptContexts = new HashMap();
    private String functionName = null;
    private boolean eventInDOM = false;
    private boolean readOnly = false;
    private Position scriptPosition = null;
    private IEventEditorInfo editorInfo = null;
    private String eventType = "";

    public TagEventImpl() {
    }

    public TagEventImpl(IDOMNode n, String eventID, String displayName, Image unset, Image set, String script) {
        this.eventID = eventID;
        this.node = n;
        this.displayName = displayName;
        this.unsetIcon = unset;
        this.setIcon = set;
        this.eventScript = script;
        if (this.eventScript != null && !this.eventScript.equals("")) {
            this.scripted = true;
        }
    }

    public TagEventImpl(IDOMNode n, String eventID, String displayName, Image unset, Image set, String script, IEventEditorInfo info) {
        this(n, eventID, displayName, unset, set, script);
        this.editorInfo = info;
    }

    public void addAllowedLanguage(String lang) {
        this.allowedLanguages.add(lang);
    }

    public void addScriptContext(String language, IEventScriptContext ctx) {
        if (language != null) {
            language = language.toLowerCase();
        }
        if (ctx instanceof HtmlJavascriptContext) {
            ((HtmlJavascriptContext)ctx).setEvent(this);
        }
        this.scriptContexts.put(language, ctx);
    }

    public void clearEventInfo() {
        this.scripted = false;
        this.eventScript = null;
    }

    public int compareTo(Object arg0) {
        if (arg0 instanceof TagEventImpl) {
            return this.displayName.compareTo(((TagEventImpl)arg0).getDisplayName());
        }
        return 0;
    }

    @Override
    public String[] getAllowedLanguages() {
        String[] langs = new String[this.allowedLanguages.size()];
        int i = 0;
        while (i < this.allowedLanguages.size()) {
            langs[i] = (String)this.allowedLanguages.get(i);
            ++i;
        }
        return langs;
    }

    @Override
    public IEventScriptContext getContextForLanguage(String language) {
        if (language != null) {
            language = language.toLowerCase();
        }
        return (IEventScriptContext)this.scriptContexts.get(language);
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public IEventEditorInfo getEditorInfo() {
        return this.editorInfo;
    }

    public String getEventType() {
        return this.eventType;
    }

    @Override
    public IEventUpdater getEventUpdater() {
        return this.updater;
    }

    @Override
    public String getFunctionName() {
        return this.functionName;
    }

    @Override
    public Image getIcon() {
        if (this.isScripted()) {
            return this.getSetIcon();
        }
        return this.getUnsetIcon();
    }

    @Override
    public String getID() {
        return this.eventID;
    }

    @Override
    public String getLanguage() {
        return this.scriptLanguage;
    }

    @Override
    public IDOMNode getNode() {
        return this.node;
    }

    @Override
    public String getScript() {
        return this.eventScript;
    }

    @Override
    public Position getScriptPosition() {
        return this.scriptPosition;
    }

    public Image getSetIcon() {
        return this.setIcon;
    }

    public Image getUnsetIcon() {
        return this.unsetIcon;
    }

    @Override
    public boolean isActive(IDOMNode node) {
        return true;
    }

    @Override
    public boolean isInDOMAttribute() {
        return this.eventInDOM;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public boolean isScripted() {
        return this.scripted;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    protected void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setEditorInfo(IEventEditorInfo info) {
        this.editorInfo = info;
    }

    @Override
    public void setFunctionName(String fn) {
        this.functionName = fn;
    }

    protected void setID(String eventID) {
        this.eventID = eventID;
    }

    @Override
    public void setInDOMAttribute(boolean b) {
        this.eventInDOM = b;
    }

    @Override
    public void setLanguage(String lang) {
        this.scriptLanguage = lang;
    }

    public void setNode(IDOMNode node) {
        this.node = node;
    }

    public void setReadOnly(boolean b) {
        this.readOnly = b;
    }

    @Override
    public void setScript(String s) {
        this.eventScript = s;
        if (this.eventScript != null && !this.eventScript.equals("")) {
            this.scripted = true;
        }
    }

    public void setScripted(boolean b) {
        this.scripted = b;
    }

    public void setScriptPosition(Position pos) {
        this.scriptPosition = pos;
    }

    protected void setSetIcon(Image icon) {
        this.setIcon = icon;
    }

    protected void setUnsetIcon(Image icon) {
        this.unsetIcon = icon;
    }

    public void setUpdater(IEventUpdater updater) {
        this.updater = updater;
    }
}

