/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.qev.model.impl;

import com.ibm.etools.qev.Debug;
import com.ibm.etools.qev.model.IEventEditorInfo;
import com.ibm.etools.qev.model.adapters.EventsDocumentAdapter;
import com.ibm.etools.qev.model.impl.FunctionBounds;
import com.ibm.etools.qev.model.impl.TagEventImpl;
import com.ibm.etools.qev.util.TextNodeUtil;
import org.eclipse.jface.text.Position;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class HtmlTagEventImpl
extends TagEventImpl {
    protected boolean isDirty = true;

    public HtmlTagEventImpl(IDOMNode n, String eventID, String displayName, Image unset, Image set) {
        super(n, eventID, displayName, unset, set, null);
    }

    public HtmlTagEventImpl(IDOMNode n, String eventID, String displayName, Image unset, Image set, IEventEditorInfo info) {
        super(n, eventID, displayName, unset, set, null, info);
    }

    protected String extractFunctionName(String attrValue) {
        int endCheck;
        String functionName = null;
        int parenIndex = attrValue.lastIndexOf("(");
        if (parenIndex > 0 && (endCheck = attrValue.lastIndexOf(")")) > 0 && endCheck > parenIndex && (functionName = attrValue.substring(0, parenIndex).trim()) != null) {
            int endTagIndex;
            int spaceIndex = functionName.lastIndexOf(" ");
            if (spaceIndex > -1) {
                functionName = functionName.substring(spaceIndex, functionName.length()).trim();
            }
            if (functionName.startsWith("#{") && (endTagIndex = functionName.lastIndexOf("}")) > -1) {
                functionName = functionName.substring(endTagIndex + 1, functionName.length());
            }
            if (functionName.startsWith("'<%") && (endTagIndex = functionName.lastIndexOf(">")) > -1) {
                functionName = functionName.substring(endTagIndex + 1, functionName.length());
            }
        }
        return functionName;
    }

    @Override
    public String getFunctionName() {
        if (this.isDirty) {
            this.refreshEventScript();
        }
        return super.getFunctionName();
    }

    @Override
    public String getScript() {
        this.refreshEventScript();
        return super.getScript();
    }

    @Override
    public Position getScriptPosition() {
        this.refreshEventScript();
        return super.getScriptPosition();
    }

    @Override
    public boolean isInDOMAttribute() {
        if (this.isDirty) {
            this.refreshEventScript();
        }
        return super.isInDOMAttribute();
    }

    protected boolean isMultiStatement(String s) {
        return s.indexOf(";") < s.lastIndexOf(";");
    }

    @Override
    public boolean isScripted() {
        Attr attrNode;
        if (this.getNode() == null) {
            return false;
        }
        return this.getNode() instanceof Element && (attrNode = ((Element)this.getNode()).getAttributeNode(this.getDisplayName())) != null;
    }

    protected void refreshEventScript() {
        String theScript = new String();
        String theFunctionName = null;
        Position thePos = null;
        if (this.isScripted()) {
            Attr attrNode = ((Element)this.getNode()).getAttributeNode(this.getDisplayName());
            if (attrNode != null) {
                String attrValue = attrNode.getNodeValue();
                if (attrValue != null) {
                    theFunctionName = this.extractFunctionName(attrValue);
                    EventsDocumentAdapter pageInfo = (EventsDocumentAdapter)this.getNode().getModel().getDocument().getAdapterFor(EventsDocumentAdapter.class);
                    if (pageInfo != null) {
                        if (this.isMultiStatement(attrValue) || theFunctionName == null || !pageInfo.isInScriptTag(theFunctionName)) {
                            this.setInDOMAttribute(true);
                            theScript = attrValue;
                            IDOMAttr at = (IDOMAttr)attrNode;
                            int start = at.getValueRegionStartOffset();
                            String value = at.getValueRegionText();
                            int length = value.length();
                            if (value.startsWith("\"") || value.startsWith("'")) {
                                ++start;
                                --length;
                            }
                            if (value.endsWith("\"") || value.endsWith("'")) {
                                --length;
                            }
                            thePos = new Position(start, length);
                        } else {
                            Node scriptNode = pageInfo.getNodeForScript(theFunctionName);
                            if (scriptNode != null) {
                                Node textNode = TextNodeUtil.findChildTextNode(scriptNode);
                                if (textNode != null) {
                                    String text = textNode.getNodeValue();
                                    FunctionBounds bounds = pageInfo.getBoundsForScript(theFunctionName);
                                    if (text != null && bounds != null) {
                                        int start = bounds.getBodyStart();
                                        int end = bounds.getBodyEnd();
                                        theScript = text.substring(start, end);
                                        thePos = new Position(((IDOMNode)textNode).getStartOffset() + start, end - start);
                                    } else {
                                        Debug.trace("adapters", "refreshEventScript(): text=" + text + " functionBounds=" + bounds);
                                    }
                                } else {
                                    Debug.trace("adapters", "refreshEventScript(): scriptnode has no textNode");
                                }
                            } else {
                                Debug.trace("adapters", "refreshEventScript():no scriptNode for function: " + theFunctionName);
                            }
                        }
                    } else {
                        Debug.trace("adapters", "refreshEventScript():no pageInfo for " + this.getDisplayName());
                    }
                } else {
                    Debug.trace("adapters", "refreshEventScript():no attribute value for " + this.getDisplayName());
                }
            } else {
                Debug.trace("adapters", "refreshEventScript():could not find event attribute for " + this.getDisplayName());
            }
        }
        this.setScript(theScript);
        this.setFunctionName(theFunctionName);
        this.setScriptPosition(thePos);
        this.isDirty = false;
    }
}

