/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.qev.model.impl;

import com.ibm.etools.qev.model.adapters.EventsDocumentAdapter;
import com.ibm.etools.qev.model.impl.DeferredJavascriptContext;
import com.ibm.etools.qev.model.impl.ITagEvent;
import com.ibm.etools.qev.util.TextNodeUtil;
import java.util.List;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class HtmlJavascriptContext
extends DeferredJavascriptContext {
    ITagEvent event = null;

    public HtmlJavascriptContext(IDOMNode node) {
        super(node, true);
    }

    @Override
    protected void appendAdditional(StringBuffer buffer) {
        buffer.append("\n}");
    }

    @Override
    protected void initContext() {
        IDOMDocument doc = (IDOMDocument)this.getNode().getOwnerDocument();
        EventsDocumentAdapter docAdapter = (EventsDocumentAdapter)doc.getAdapterFor(EventsDocumentAdapter.class);
        if (docAdapter != null) {
            List scriptNodes = docAdapter.getScriptNodes();
            int i = 0;
            while (i < scriptNodes.size()) {
                Node tempNode;
                Node n = (Node)scriptNodes.get(i);
                NamedNodeMap nodeAttributes = n.getAttributes();
                if (nodeAttributes != null && nodeAttributes.getNamedItem("src") == null && (tempNode = TextNodeUtil.findChildTextNode(n)) != null) {
                    String nodeValue = tempNode.getNodeValue();
                    this.addFunction(nodeValue);
                }
                ++i;
            }
        }
    }

    @Override
    protected void prependAdditional(StringBuffer buffer) {
        String functionName = null;
        if (this.event != null && this.event.isScripted()) {
            functionName = this.event.getFunctionName();
        }
        if (functionName == null) {
            IDOMDocument doc = (IDOMDocument)this.getNode().getOwnerDocument();
            EventsDocumentAdapter docAdapter = (EventsDocumentAdapter)doc.getAdapterFor(EventsDocumentAdapter.class);
            functionName = TextNodeUtil.generateUniqueFunctionName(docAdapter);
            this.event.setFunctionName(functionName);
        }
        buffer.append("function ");
        buffer.append(functionName);
        buffer.append("() {\n");
    }

    public void setEvent(ITagEvent tagEvent) {
        this.event = tagEvent;
    }
}

