/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.qev.model.impl;

import com.ibm.etools.qev.Debug;
import com.ibm.etools.qev.model.IEvent;
import com.ibm.etools.qev.model.impl.IEventUpdaterWithModel;
import com.ibm.etools.qev.model.impl.ILanguageSpecificUpdater;
import com.ibm.etools.qev.model.impl.ITagEvent;
import com.ibm.etools.qev.model.impl.TagEventImpl;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;

public class CompositeEventUpdater
implements IEventUpdaterWithModel {
    private IStructuredModel eventsEditorModel = null;
    private HashMap languageUpdaterMap = new HashMap();

    public void addUpdater(String language, ILanguageSpecificUpdater updater) {
        if (language != null) {
            this.languageUpdaterMap.put(language.toLowerCase(), updater);
        }
    }

    @Override
    public void forceCreate(IEvent event, String newEventScript, String language, ArrayList actions) {
        ILanguageSpecificUpdater updateHandler = this.getUpdaterForLanguage(language);
        if (updateHandler == null) {
            Debug.log(202, "No handler for event! Cannot create.");
            return;
        }
        updateHandler.doCreate(event, newEventScript, actions, this.getEventEditorModel());
    }

    @Override
    public void forceRemove(IEvent event, ArrayList actions) {
        if (event == null) {
            return;
        }
        ILanguageSpecificUpdater updateHandler = this.getUpdaterForLanguage(event.getLanguage());
        if (updateHandler == null) {
            Debug.log(202, "No handler for event! Cannot remove.");
            return;
        }
        updateHandler.doRemove(event, actions, this.getEventEditorModel());
    }

    @Override
    public IStructuredModel getEventEditorModel() {
        return this.eventsEditorModel;
    }

    protected ILanguageSpecificUpdater getUpdaterForLanguage(String language) {
        if (language != null) {
            return (ILanguageSpecificUpdater)this.languageUpdaterMap.get(language.toLowerCase());
        }
        return null;
    }

    @Override
    public void setEventEditorModel(IStructuredModel model) {
        this.eventsEditorModel = model;
    }

    @Override
    public void updateModel(IEvent ev, String newScript, String language, ArrayList actions) {
        ITagEvent event = (ITagEvent)ev;
        ILanguageSpecificUpdater updateHandler = this.getUpdaterForLanguage(language);
        if (updateHandler == null) {
            Debug.log(202, "No handler for event! Cannot update.");
            return;
        }
        if (event.isScripted()) {
            if (!newScript.trim().equals("")) {
                updateHandler.doUpdate(event, newScript, actions, this.getEventEditorModel());
            }
            if (newScript.trim().equals("")) {
                updateHandler.doRemove(event, actions, this.getEventEditorModel());
                ((TagEventImpl)event).setScripted(false);
            }
        }
    }
}

