/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.qev.model.impl;

import com.ibm.etools.qev.Debug;
import com.ibm.etools.qev.actions.SimpleAction;
import com.ibm.etools.qev.edit.IExtendedDesignEditor;
import com.ibm.etools.qev.model.IEvent;
import com.ibm.etools.qev.model.adapters.EventsNodeAdapter;
import com.ibm.etools.qev.model.impl.EventModelProvider;
import com.ibm.etools.qev.model.impl.ILanguageSpecificUpdater;
import com.ibm.etools.qev.model.impl.ITagEvent;
import com.ibm.etools.qev.registry.DefinitionsRegistry;
import com.ibm.etools.qev.registry.EventDefinition;
import com.ibm.etools.qev.view.QEVView;
import java.util.ArrayList;
import org.eclipse.jface.text.IDocument;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Element;

public abstract class AbstractDOMEventUpdater
implements ILanguageSpecificUpdater {
    private IExtendedDesignEditor editDomain;

    public AbstractDOMEventUpdater(IExtendedDesignEditor editDomain) {
        this.editDomain = editDomain;
    }

    private void beginUpdates(UpdateStateContainer updateStateContainer) {
        if (QEVView.getViewInstance() == null || QEVView.getViewInstance().getModelProvider() == null) {
            Debug.trace("beginUpdates-No QEVView instance or EventModelProvider!!", "update");
            return;
        }
        EventsNodeAdapter adapter = (EventsNodeAdapter)updateStateContainer.node.getAdapterFor(EventsNodeAdapter.class);
        adapter.enableAutoRefresh(false);
        ((EventModelProvider)QEVView.getViewInstance().getModelProvider()).setFireSelection(false);
        updateStateContainer.node.getModel().beginRecording((Object)this);
    }

    protected abstract void create(ITagEvent var1, Element var2, EventDefinition var3, String var4, IStructuredModel var5);

    @Override
    public void doCreate(IEvent event, String newEventScript, ArrayList actions, IStructuredModel model) {
        Debug.trace("doCreate", "update");
        ITagEvent tagEvent = (ITagEvent)event;
        Element tag = (Element)tagEvent.getNode();
        EventDefinition eventDef = this.getEventDefinition(tagEvent.getID());
        UpdateStateContainer updateState = new UpdateStateContainer(tagEvent.getNode());
        this.beginUpdates(updateState);
        try {
            this.create(tagEvent, tag, eventDef, newEventScript, model);
            this.doUpdateActions(tagEvent, actions, model);
        }
        finally {
            this.endUpdates(updateState);
        }
    }

    @Override
    public void doRemove(IEvent event, ArrayList actions, IStructuredModel model) {
        Debug.trace("doRemove", "update");
        ITagEvent tagEvent = (ITagEvent)event;
        Element tag = (Element)tagEvent.getNode();
        EventDefinition eventDef = this.getEventDefinition(tagEvent.getID());
        UpdateStateContainer updateState = new UpdateStateContainer(tagEvent.getNode());
        this.beginUpdates(updateState);
        try {
            this.remove(tagEvent, tag, eventDef);
            this.doUpdateActions(tagEvent, actions, model);
        }
        finally {
            this.endUpdates(updateState);
        }
    }

    @Override
    public void doUpdate(IEvent event, String newEventScript, ArrayList actions, IStructuredModel model) {
        Debug.trace("doUpdate", "update");
        ITagEvent tagEvent = (ITagEvent)event;
        Element tag = (Element)tagEvent.getNode();
        EventDefinition eventDef = this.getEventDefinition(tagEvent.getID());
        UpdateStateContainer updateState = new UpdateStateContainer(tagEvent.getNode());
        this.beginUpdates(updateState);
        try {
            this.update(tagEvent, tag, eventDef, newEventScript, model);
            this.doUpdateActions(tagEvent, actions, model);
        }
        finally {
            this.endUpdates(updateState);
        }
    }

    private void doUpdateActions(ITagEvent tagEvent, ArrayList actions, IStructuredModel model) {
        if (actions != null && !actions.isEmpty()) {
            IStructuredDocument doc = tagEvent.getNode().getStructuredDocument();
            int i = 0;
            while (i < actions.size()) {
                SimpleAction currentAction = (SimpleAction)actions.get(i);
                currentAction.updateAdditionalScript(tagEvent, (IDocument)doc);
                ++i;
            }
        }
    }

    @Override
    public void doUpdateActionsOnly(IEvent event, ArrayList actions, IStructuredModel model) {
        Debug.trace("update", "doUpdateActionsOnly");
        ITagEvent tagEvent = (ITagEvent)event;
        UpdateStateContainer updateState = new UpdateStateContainer(tagEvent.getNode());
        this.beginUpdates(updateState);
        try {
            try {
                this.doUpdateActions(tagEvent, actions, model);
            }
            catch (Exception e) {
                Debug.trace("update", "doUpdateActionsOnly failed: exception=" + e.getMessage());
                this.endUpdates(updateState);
            }
        }
        finally {
            this.endUpdates(updateState);
        }
    }

    private void endUpdates(UpdateStateContainer updateStateContainer) {
        if (QEVView.getViewInstance() == null || QEVView.getViewInstance().getModelProvider() == null) {
            Debug.trace("endUpdates-No QEVView instance or EventModelProvider!!", "update");
            return;
        }
        try {
            updateStateContainer.node.getModel().endRecording((Object)this);
        }
        catch (Exception e) {
            Debug.log(202, e.getMessage(), e);
        }
        ((EventModelProvider)QEVView.getViewInstance().getModelProvider()).setFireSelection(true);
        EventsNodeAdapter adapter = (EventsNodeAdapter)updateStateContainer.node.getAdapterFor(EventsNodeAdapter.class);
        adapter.enableAutoRefresh(true);
    }

    public IExtendedDesignEditor getEditDomain() {
        return this.editDomain;
    }

    protected EventDefinition getEventDefinition(String eventId) {
        return DefinitionsRegistry.getRegistry().getEvent(eventId);
    }

    protected abstract void remove(ITagEvent var1, Element var2, EventDefinition var3);

    public void setEditDomain(IExtendedDesignEditor domain) {
        this.editDomain = domain;
    }

    protected abstract void update(ITagEvent var1, Element var2, EventDefinition var3, String var4, IStructuredModel var5);

    class UpdateStateContainer {
        IDOMNode node;

        public UpdateStateContainer(IDOMNode n) {
            this.node = n;
        }
    }
}

