/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.qev.model.adapters;

import com.ibm.etools.qev.Debug;
import com.ibm.etools.qev.model.IEvent;
import com.ibm.etools.qev.model.IEventList;
import com.ibm.etools.qev.model.adapters.EventsNodeAdapterFactory;
import com.ibm.etools.qev.model.impl.ITagEventModelBuilder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;

public class EventsNodeAdapter
implements INodeAdapter,
IEventList {
    private Object key = this.getClass();
    private EventsNodeAdapterFactory factory;
    private TreeSet events = new TreeSet();
    private IDOMNode node;
    private boolean ignoreChanges;
    private boolean needsRefresh = true;
    private HashMap eventToBuilder = new HashMap();

    public EventsNodeAdapter(IDOMNode n, EventsNodeAdapterFactory factory) {
        this.node = n;
        this.factory = factory;
        Debug.trace("adapters", "new adapter for node: " + n.getNodeName());
    }

    public void addEvent(IEvent m, ITagEventModelBuilder eventModelBuilder) {
        if (!this.events.contains(m) && m.isActive(this.node)) {
            this.events.add(m);
            this.eventToBuilder.put(m, eventModelBuilder);
        }
    }

    public void clearEvents() {
        this.events.clear();
        this.eventToBuilder.clear();
    }

    public void enableAutoRefresh(boolean enable) {
        Debug.trace("adapters", "enableAutoRefresh: " + this.getName() + ": " + enable);
        this.ignoreChanges = !enable;
    }

    @Override
    public IEvent getEvent(String id) {
        Iterator list = this.getEvents();
        while (list.hasNext()) {
            IEvent event = (IEvent)list.next();
            if (!event.getID().equals(id)) continue;
            return event;
        }
        return null;
    }

    public ITagEventModelBuilder getEventModelBuilder(String id) {
        ITagEventModelBuilder result = null;
        IEvent event = this.getEvent(id);
        if (event != null) {
            result = (ITagEventModelBuilder)this.eventToBuilder.get(event);
        }
        return result;
    }

    @Override
    public Iterator getEvents() {
        if (this.needsRefresh) {
            this.factory.refreshModel(this);
            this.needsRefresh = false;
        }
        return this.events.iterator();
    }

    @Override
    public String getName() {
        return this.node.getNodeName();
    }

    public IDOMNode getNode() {
        return this.node;
    }

    public boolean isAdapterForType(Object arg0) {
        return this.key.equals(arg0);
    }

    public void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
        Debug.trace("adapters", "notify changed: " + notifier);
        Debug.trace("adapters", "change type: " + INodeNotifier.EVENT_TYPE_STRINGS[eventType]);
        if (this.ignoreChanges) {
            Debug.trace("adapters", "ignoring change: " + this.getName());
        } else {
            Debug.trace("adapters", "not ignoring change: " + this.getName());
            this.needsRefresh = true;
        }
    }

    public void removeEvent(String id) {
        IEvent eventToRemove = this.getEvent(id);
        if (eventToRemove != null) {
            this.events.remove(eventToRemove);
            this.eventToBuilder.remove(eventToRemove);
        }
    }

    public void setRequiresRefresh(boolean b) {
        this.needsRefresh = b;
    }
}

