/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.qev.edit;

import java.io.InputStream;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.wst.sse.core.internal.util.DocumentInputStream;

public class VirtualEditorInput
implements IStorageEditorInput {
    protected IDocument fDocument;
    protected IPath fPath;
    protected TextStorage fStorage;

    public VirtualEditorInput(String path) {
        if (path == null) {
            path = "" + this.hashCode();
        }
        this.fPath = new Path(path);
        this.fStorage = new TextStorage();
        this.fDocument = new Document();
    }

    public boolean exists() {
        return true;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IResource.class) {
            return ResourcesPlugin.getWorkspace().getRoot();
        }
        return null;
    }

    public IDocument getDocument() {
        return this.fDocument;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        return this.fStorage.getName();
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public IStorage getStorage() throws CoreException {
        return this.fStorage;
    }

    public String getToolTipText() {
        return this.getName();
    }

    private class TextStorage
    implements IStorage {
        private TextStorage() {
        }

        public Object getAdapter(Class adapter) {
            return null;
        }

        public InputStream getContents() throws CoreException {
            return new DocumentInputStream(VirtualEditorInput.this.fDocument);
        }

        public IPath getFullPath() {
            return VirtualEditorInput.this.fPath;
        }

        public String getName() {
            return this.getFullPath().toString();
        }

        public boolean isReadOnly() {
            return false;
        }
    }
}

