/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.qev.edit;

import com.ibm.etools.qev.Debug;
import com.ibm.etools.qev.edit.QEVTextEditor;
import com.ibm.etools.qev.edit.VirtualEditorInput;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.texteditor.ITextEditor;

public class TextEditorViewer
extends Viewer {
    protected ITextEditor fTextEditor = null;
    protected Composite parent = null;
    protected Composite container = null;
    @Deprecated
    protected IEditorInput fInput = null;
    protected int fStyle = 0;

    public TextEditorViewer(Composite parent) {
        this(parent, 0);
    }

    public TextEditorViewer(Composite parent, int style) {
        this.parent = parent;
        this.fTextEditor = this.createTextEditor();
        this.fStyle = style;
    }

    protected ITextEditor createTextEditor() {
        return new QEVTextEditor();
    }

    public void dispose() {
        this.getTextEditor().dispose();
    }

    public Control getControl() {
        return this.container;
    }

    public Object getInput() {
        return this.getTextEditor().getEditorInput();
    }

    public ISelection getSelection() {
        return this.getTextEditor().getSelectionProvider().getSelection();
    }

    public ISourceViewer getSourceViewer() {
        return ((QEVTextEditor)this.getTextEditor()).getTextViewer();
    }

    public ITextEditor getTextEditor() {
        return this.fTextEditor;
    }

    public void init(IWorkbenchPartSite site) {
        this.init(site, (IEditorInput)new VirtualEditorInput(null));
    }

    public void init(IWorkbenchPartSite site, IEditorInput input) {
        Object editorSite = null;
        editorSite = site instanceof IEditorSite ? (IEditorSite)site : new ViewerEditorSite(site);
        try {
            this.getTextEditor().init(editorSite, input);
        }
        catch (PartInitException e) {
            Debug.log(202, e.getMessage(), e);
        }
        this.container = new Composite(this.parent, this.fStyle);
        FillLayout fill = new FillLayout();
        this.container.setLayout((Layout)fill);
        this.getTextEditor().createPartControl(this.container);
    }

    public void refresh() {
    }

    public void setInput(Object input) {
        if (!(input instanceof IEditorInput)) {
            throw new UnsupportedOperationException("setInput: unsupported type");
        }
        ((IReusableEditor)this.getTextEditor()).setInput((IEditorInput)input);
        this.updateEditor();
    }

    public void setSelection(ISelection selection, boolean reveal) {
        this.getTextEditor().getSelectionProvider().setSelection(selection);
    }

    protected void updateEditor() {
    }

    public class ViewerEditorSite
    implements IEditorSite {
        protected IWorkbenchPartSite fSite = null;

        public ViewerEditorSite(IWorkbenchPartSite site) {
            this.fSite = site;
        }

        public IEditorActionBarContributor getActionBarContributor() {
            return null;
        }

        public IActionBars getActionBars() {
            if (this.fSite instanceof IViewSite) {
                return ((IViewSite)this.fSite).getActionBars();
            }
            return null;
        }

        public Object getAdapter(Class adapter) {
            return null;
        }

        public String getId() {
            return this.fSite.getId();
        }

        public IKeyBindingService getKeyBindingService() {
            return this.fSite.getKeyBindingService();
        }

        public IWorkbenchPage getPage() {
            return this.fSite.getPage();
        }

        public IWorkbenchPart getPart() {
            return this.fSite.getPart();
        }

        public String getPluginId() {
            return this.fSite.getPluginId();
        }

        public String getRegisteredName() {
            return this.fSite.getRegisteredName();
        }

        public ISelectionProvider getSelectionProvider() {
            return this.fSite.getSelectionProvider();
        }

        public Object getService(Class api) {
            return null;
        }

        public Shell getShell() {
            return this.fSite.getShell();
        }

        public IWorkbenchWindow getWorkbenchWindow() {
            return this.fSite.getWorkbenchWindow();
        }

        public boolean hasService(Class api) {
            return false;
        }

        public void registerContextMenu(MenuManager menuManager, ISelectionProvider selectionProvider) {
            this.fSite.registerContextMenu(menuManager, selectionProvider);
        }

        public void registerContextMenu(MenuManager menuManager, ISelectionProvider selectionProvider, boolean includeEditorInput) {
            this.fSite.registerContextMenu(menuManager, selectionProvider);
        }

        public void registerContextMenu(String menuId, MenuManager menuManager, ISelectionProvider selectionProvider) {
            this.fSite.registerContextMenu(menuId, menuManager, selectionProvider);
        }

        public void registerContextMenu(String menuId, MenuManager menuManager, ISelectionProvider selectionProvider, boolean includeEditorInput) {
            this.fSite.registerContextMenu(menuId, menuManager, selectionProvider);
        }

        public void setSelectionProvider(ISelectionProvider provider) {
        }
    }
}

