/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.qev.edit;

import com.ibm.etools.qev.edit.IExtendedDesignEditor;
import com.ibm.etools.webedit.editor.HTMLEditor;
import com.ibm.etools.webedit.viewer.utils.ModelManagerUtil;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ExtendedDesignEditor
implements IExtendedDesignEditor {
    private HTMLEditor editor;

    public ExtendedDesignEditor(HTMLEditor editor) {
        this.editor = editor;
    }

    @Override
    public IEditorInput getActiveEditorInput() {
        IStructuredModel model = this.getModel();
        IStructuredModel activeModel = this.getActiveModel();
        if (model == null || activeModel == null) {
            return null;
        }
        if (model == activeModel) {
            return this.getEditorInput();
        }
        Path path = new Path(ModelManagerUtil.getBaseLocation((IStructuredModel)activeModel));
        IProject project = this.getProjectForIPath((IPath)path);
        if (project == null) {
            return null;
        }
        IFile file = project.getWorkspace().getRoot().getFileForLocation((IPath)path);
        if (file == null) {
            return null;
        }
        return new FileEditorInput(file);
    }

    @Override
    public IStructuredModel getActiveModel() {
        return this.editor != null ? this.editor.getActiveModel() : null;
    }

    public Node getCaretNode() {
        return this.editor != null ? this.editor.getCaretNode() : null;
    }

    public int getCaretOffset() {
        return this.editor != null ? this.editor.getCaretOffset() : -1;
    }

    public IContainer getDocRootContainer(IPath docRootPath) {
        IWorkspaceRoot workspace = ResourcesPlugin.getWorkspace().getRoot();
        IContainer docRootContainer = workspace.getContainerForLocation(docRootPath);
        return docRootContainer;
    }

    public IDocument getDocument() {
        return this.editor != null ? this.editor.getDocument() : null;
    }

    public Document getDOMDocument() {
        return this.editor != null ? this.editor.getDOMDocument() : null;
    }

    public IEditorInput getEditorInput() {
        return this.editor != null ? this.editor.getEditorInput() : null;
    }

    public IEditorPart getEditorPart() {
        return this.editor != null ? this.editor.getEditorPart() : null;
    }

    public IStructuredModel getModel() {
        return this.editor != null ? this.editor.getModel() : null;
    }

    public IProject getProjectForIPath(IPath fullLocalIPath) {
        IProject project;
        IContainer container = this.getDocRootContainer(fullLocalIPath);
        if (container != null && (project = container.getProject()) != null) {
            return project;
        }
        IWorkspaceRoot workspace = ResourcesPlugin.getWorkspace().getRoot();
        if (workspace == null) {
            return null;
        }
        IProject[] projects = workspace.getProjects();
        if (projects == null) {
            return null;
        }
        IProject project2 = null;
        int i = 0;
        while (i < projects.length) {
            project2 = projects[i];
            if (project2.getLocation().isPrefixOf(fullLocalIPath)) {
                return project2;
            }
            ++i;
        }
        return null;
    }

    public List getSelectedNodes() {
        return this.editor != null ? this.editor.getSelectedNodes() : null;
    }

    public ITextSelection getSelection() {
        return this.editor != null ? this.editor.getSelection() : TextSelection.emptySelection();
    }

    public IStatus validateEdit(Shell arg0) {
        return this.editor != null ? this.editor.validateEdit(arg0) : null;
    }
}

