/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.qev.actions.javascript;

import com.ibm.etools.qev.Debug;
import com.ibm.etools.qev.actions.ActionVariable;
import com.ibm.etools.qev.actions.CommentActionDetector;
import com.ibm.etools.qev.actions.IActionDetector;
import com.ibm.etools.qev.actions.InfoRegion;
import com.ibm.etools.qev.actions.SimpleTextInsertAction;
import com.ibm.etools.qev.actions.javascript.ActionScript022a;
import com.ibm.etools.qev.actions.javascript.ActionScript022b;
import com.ibm.etools.qev.actions.javascript.ComplexJavascriptInsertAction;
import com.ibm.etools.qev.actions.javascript.JavascriptCommentActionDetector;
import com.ibm.etools.qev.model.IEvent;
import com.ibm.etools.qev.model.adapters.EventsNodeAdapter;
import com.ibm.etools.qev.model.impl.ITagEvent;
import com.ibm.etools.qev.nls.ResourceHandler;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.wst.common.snippets.core.ISnippetVariable;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.StructuredModelManager;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ActionScript022
extends ComplexJavascriptInsertAction {
    static final String ACTIONID = "com.ibm.sed.jseditor.script022";
    private static final String TEMPLATE = ResourceHandler.script022_content;
    private static final String funcName1 = ResourceHandler.script022_content_func_1_name;
    private static final String funcContents1 = ResourceHandler.script022_content_func_1;
    private static final String funcName2 = ResourceHandler.script022_content_func_2_name;
    private static final String funcContents2 = ResourceHandler.script022_content_func_2;
    static final String IMGNAME = ResourceHandler.script022_var_id_1;
    static final String IMGNAME_DESC = ResourceHandler.script022_var_desc_1;
    static final String OLDIMGSRC = ResourceHandler.script022_var_id_2;
    static final String OLDIMGSRC_DESC = ResourceHandler.script022_var_desc_2;
    static final String ROLLOVERIMGSRC = ResourceHandler.script022_var_id_3;
    static final String ROLLOVERIMGSRC_DESC = ResourceHandler.script022_var_desc_3;
    private static final String IMGNAME_PREFIX = "IMG_";
    private static final String ONMOUSEOVER_ID = "html.client.onmouseover";
    private static final String ONMOUSEOUT_ID = "html.client.onmouseout";
    private JavascriptCommentActionDetector detector = null;
    private SimpleTextInsertAction thisAction = null;
    private SimpleTextInsertAction otherAction = null;
    private IEvent otherEvent = null;

    public ActionScript022() {
        super(ACTIONID);
        this.setContentString(TEMPLATE);
        ActionVariable var = new ActionVariable(IMGNAME, null, null, IMGNAME_DESC, "");
        this.addVariable((ISnippetVariable)var);
        var = new ActionVariable(OLDIMGSRC, null, null, OLDIMGSRC_DESC, "");
        this.addVariable((ISnippetVariable)var);
        var = new ActionVariable(ROLLOVERIMGSRC, null, null, ROLLOVERIMGSRC_DESC, "");
        this.addVariable((ISnippetVariable)var);
        ComplexJavascriptInsertAction.FunctionVarItem item = new ComplexJavascriptInsertAction.FunctionVarItem(this, funcName1, funcContents1);
        this.addFunction(item);
        item = new ComplexJavascriptInsertAction.FunctionVarItem(this, funcName2, funcContents2);
        this.addFunction(item);
    }

    @Override
    public void breakApart() {
        if (this.getDocument() != null && this.thisAction != null && this.otherAction != null) {
            IStructuredModel sm = StructuredModelManager.getModelManager().getExistingModelForEdit(this.getDocument());
            if (sm != null) {
                sm.beginRecording((Object)this);
            }
            this.thisAction.breakApart();
            this.otherAction.breakApart();
            if (sm != null) {
                sm.endRecording((Object)this);
                sm.releaseFromEdit();
            }
        }
    }

    @Override
    public boolean extract(IEvent e, IDocument doc, InfoRegion prefix, InfoRegion postfix) {
        this.setEvent(e);
        this.setDocument(doc);
        boolean subAction1 = this.thisAction.extract(this.getEvent(), doc, prefix, postfix);
        if (subAction1 && this.getOtherEvent().isScripted()) {
            String otherScript = this.getOtherEvent().getScript();
            Position otherEventPos = this.getOtherEvent().getScriptPosition();
            InfoRegion start = this.getDetector().findActionPrefix(otherScript, 0, otherScript.length(), this.getId());
            while (start != null) {
                InfoRegion end = this.getDetector().findActionPostfix(otherScript, start.getEndOffset(), otherScript.length() - start.getEndOffset(), this.getId());
                if (end != null) {
                    InfoRegion start2 = new InfoRegion(otherEventPos.getOffset() + start.getOffset(), start.getLength(), start.getInfo());
                    InfoRegion end2 = new InfoRegion(otherEventPos.getOffset() + end.getOffset(), end.getLength(), end.getInfo());
                    if (this.isUsingLiveDocument()) {
                        boolean subAction2 = this.otherAction.extract(this.getOtherEvent(), doc, start2, end2);
                        if (subAction2) {
                            String otherImgName = this.otherAction.getVariableValue(IMGNAME);
                            String thisImgName = this.thisAction.getVariableValue(IMGNAME);
                            if (thisImgName != null && thisImgName.equals(otherImgName)) {
                                return true;
                            }
                        }
                        start = this.getDetector().findActionPrefix(otherScript, start.getEndOffset(), otherScript.length() - start.getEndOffset(), this.getId());
                        continue;
                    }
                    start = null;
                    continue;
                }
                start = null;
            }
        }
        return false;
    }

    @Override
    public boolean extract(IEvent e, IDocument doc, int offset, int length) {
        this.setEvent(e);
        this.setDocument(doc);
        boolean subAction1 = this.thisAction.extract(this.getEvent(), doc, offset, length);
        if (subAction1 && this.getOtherEvent().isScripted()) {
            Position otherEventPos = this.getOtherEvent().getScriptPosition();
            if (this.isUsingLiveDocument()) {
                int currentOffset = otherEventPos.getOffset();
                int currentLength = otherEventPos.getLength();
                while (currentOffset < otherEventPos.getOffset() + otherEventPos.getLength()) {
                    boolean subAction2 = this.otherAction.extract(this.getOtherEvent(), doc, currentOffset, currentLength);
                    if (subAction2) {
                        String otherImgName = this.otherAction.getVariableValue(IMGNAME);
                        String thisImgName = this.thisAction.getVariableValue(IMGNAME);
                        if (thisImgName != null && thisImgName.equals(otherImgName)) {
                            return true;
                        }
                        currentOffset += this.otherAction.getContentString().length();
                        currentLength -= this.otherAction.getContentString().length();
                        continue;
                    }
                    currentOffset = otherEventPos.getOffset() + otherEventPos.getLength();
                }
            }
        }
        return false;
    }

    public String getContentString() {
        if (this.thisAction != null) {
            return this.thisAction.getContentString();
        }
        return super.getContentString();
    }

    private CommentActionDetector getDetector() {
        if (this.detector == null) {
            this.detector = new JavascriptCommentActionDetector();
        }
        return this.detector;
    }

    private IEvent getOtherEvent() {
        return this.otherEvent;
    }

    public ISnippetVariable[] getVariables() {
        if (this.thisAction != null && this.otherAction != null) {
            ISnippetVariable[] thisActionVars = this.thisAction.getVariables();
            ISnippetVariable[] otherActionVars = this.otherAction.getVariables();
            ISnippetVariable[] allVars = new ISnippetVariable[thisActionVars.length + otherActionVars.length];
            System.arraycopy(thisActionVars, 0, allVars, 0, thisActionVars.length);
            System.arraycopy(otherActionVars, 0, allVars, thisActionVars.length, otherActionVars.length);
            return allVars;
        }
        return super.getVariables();
    }

    private void init() {
        IDOMNode currNode;
        this.thisAction.setEvent(this.getEvent());
        this.otherAction.setEvent(this.getOtherEvent());
        if (this.getDocument() != null) {
            this.setDocument(this.getDocument());
        }
        if ((currNode = ((ITagEvent)this.getEvent()).getNode()).getNodeName().equalsIgnoreCase("IMG") && currNode.getAttributes() != null) {
            Node attrNode = currNode.getAttributes().getNamedItem("name");
            String imgName = attrNode != null ? attrNode.getNodeValue() : IMGNAME_PREFIX + Long.toString(System.currentTimeMillis());
            this.thisAction.getActionVariable(IMGNAME).setDefaultValue(imgName);
            this.otherAction.getActionVariable(IMGNAME).setDefaultValue(imgName);
        }
    }

    @Override
    public void insert(int offset, IActionDetector extractor) {
        if (this.getDocument() != null && this.thisAction != null && this.otherAction != null) {
            IStructuredModel sm = StructuredModelManager.getModelManager().getExistingModelForEdit(this.getDocument());
            if (sm != null) {
                sm.beginRecording((Object)this);
            }
            this.thisAction.insert(offset, extractor);
            this.insertScriptHead(this.getEvent(), this.getDocument());
            if (!this.getOtherEvent().isScripted()) {
                this.getOtherEvent().getEventUpdater().forceCreate(this.getOtherEvent(), "", this.getOtherEvent().getLanguage(), null);
            }
            Position otherScriptPos = this.getOtherEvent().getScriptPosition();
            int otherOffset = otherScriptPos.getOffset() + otherScriptPos.getLength();
            this.otherAction.insert(otherOffset, extractor);
            ActionVariable imgNameVar = this.getActionVariable(IMGNAME);
            String nameAttr = imgNameVar.getValue();
            IDOMNode node = ((ITagEvent)this.getEvent()).getNode();
            if (node.getNodeName().equalsIgnoreCase("IMG") && (node.getAttributes() == null || node.getAttributes().getNamedItem("name") == null)) {
                ((Element)node).setAttribute("name", nameAttr);
            }
            if (sm != null) {
                sm.endRecording((Object)this);
                sm.releaseFromEdit();
            }
        }
    }

    @Override
    public void insertMainScript(IEvent e, IDocument doc, int offset) {
        if (this.thisAction != null && this.otherAction != null) {
            this.thisAction.insertMainScript(e, doc, offset);
            if (!this.getOtherEvent().isScripted()) {
                this.getOtherEvent().getEventUpdater().forceCreate(this.getOtherEvent(), "", this.getOtherEvent().getLanguage(), null);
            }
            Position otherScriptPos = this.getOtherEvent().getScriptPosition();
            int otherOffset = otherScriptPos.getOffset() + otherScriptPos.getLength() - 1;
            this.otherAction.insertMainScript(this.getOtherEvent(), doc, otherOffset);
        }
    }

    @Override
    public boolean isDeleted() {
        if (this.thisAction != null) {
            return this.thisAction.isDeleted();
        }
        return false;
    }

    @Override
    public boolean isInsideAction(int offset, int length) {
        if (this.thisAction != null) {
            return this.thisAction.isInsideAction(offset, length);
        }
        return false;
    }

    protected boolean isUsingLiveDocument() {
        return this.getEvent().getEditorInfo() != null && this.getEvent().getEditorInfo().getEditorInput() != null;
    }

    @Override
    public void remove() {
        if (this.getDocument() != null && this.thisAction != null && this.otherAction != null) {
            IStructuredModel sm = StructuredModelManager.getModelManager().getExistingModelForEdit(this.getDocument());
            if (sm != null) {
                sm.beginRecording((Object)this);
            }
            this.thisAction.remove();
            this.otherAction.remove();
            if (sm != null) {
                sm.endRecording((Object)this);
                sm.releaseFromEdit();
            }
        }
    }

    @Override
    public void setDocument(IDocument doc) {
        super.setDocument(doc);
        if (this.thisAction != null && this.otherAction != null) {
            this.thisAction.setDocument(doc);
            if (this.isUsingLiveDocument()) {
                this.otherAction.setDocument(doc);
            } else {
                Debug.trace("actions", "Not using live document. Rollover action cannot be used");
            }
        }
    }

    @Override
    public void setEvent(IEvent event) {
        super.setEvent(event);
        if (event != null && ONMOUSEOVER_ID.equals(event.getID())) {
            ITagEvent tagEvent = (ITagEvent)this.getEvent();
            EventsNodeAdapter nodeInfo = (EventsNodeAdapter)tagEvent.getNode().getAdapterFor(EventsNodeAdapter.class);
            if (nodeInfo == null) {
                return;
            }
            this.setOtherEvent(nodeInfo.getEvent(ONMOUSEOUT_ID));
            this.thisAction = new ActionScript022a();
            this.otherAction = new ActionScript022b();
            this.init();
        } else if (event != null && ONMOUSEOUT_ID.equals(event.getID())) {
            ITagEvent tagEvent = (ITagEvent)this.getEvent();
            EventsNodeAdapter nodeInfo = (EventsNodeAdapter)tagEvent.getNode().getAdapterFor(EventsNodeAdapter.class);
            if (nodeInfo == null) {
                return;
            }
            this.setOtherEvent(nodeInfo.getEvent(ONMOUSEOVER_ID));
            this.thisAction = new ActionScript022b();
            this.otherAction = new ActionScript022a();
            this.init();
        } else {
            Debug.trace("actions", "rollover effect action: not on a proper event");
            this.thisAction = null;
            this.otherAction = null;
        }
    }

    private void setOtherEvent(IEvent event) {
        this.otherEvent = event;
    }

    @Override
    public void setVariableValue(String varId, String varValue) {
        if (this.thisAction != null && this.otherAction != null) {
            this.thisAction.setVariableValue(varId, varValue);
            this.otherAction.setVariableValue(varId, varValue);
        }
    }

    @Override
    public void update() {
        if (this.getDocument() != null && this.thisAction != null && this.otherAction != null) {
            IStructuredModel sm = StructuredModelManager.getModelManager().getExistingModelForEdit(this.getDocument());
            if (sm != null) {
                sm.beginRecording((Object)this);
            }
            this.thisAction.update();
            this.otherAction.update();
            if (sm != null) {
                sm.endRecording((Object)this);
                sm.releaseFromEdit();
            }
        }
    }
}

