/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.qev.actions;

import com.ibm.etools.qev.actions.SimpleTextInsertAction;
import java.util.ArrayList;
import org.eclipse.compare.contentmergeviewer.ITokenComparator;
import org.eclipse.compare.rangedifferencer.IRangeComparator;
import org.eclipse.jface.text.TypedRegion;
import org.eclipse.jface.util.Assert;

public class SimpleActionComparator
implements ITokenComparator {
    public static final String WORD_TYPE = "WORD";
    public static final String PUNCTUATION_TYPE = "PUNCTUATION";
    public static final String WHITESPACE_TYPE = "WHITESPACE";
    public static final String VARIABLE_TYPE = "VARIABLE";
    protected boolean fShouldEscape = true;
    protected String fText;
    protected ArrayList fTokens;
    protected int offset;
    protected int length;

    public SimpleActionComparator(String text) {
        this(text, false);
    }

    public SimpleActionComparator(String text, boolean splitVars) {
        this(text, splitVars, false);
    }

    public SimpleActionComparator(String text, boolean splitVars, boolean shouldEscape) {
        this(text, splitVars, shouldEscape, 0, 0);
    }

    public SimpleActionComparator(String text, boolean splitVars, boolean shouldEscape, int textOffset, int textLength) {
        Assert.isNotNull((Object)text);
        this.fText = text;
        if (textLength == 0) {
            textLength = this.fText.length();
        }
        this.fTokens = new ArrayList();
        if (splitVars) {
            this.splitVariables(textOffset, textLength);
        } else {
            this.splitWordsSpaces(textOffset, textLength);
        }
        this.fShouldEscape = shouldEscape;
    }

    public int getRangeCount() {
        return this.fTokens.size();
    }

    public int getTokenLength(int index) {
        if (index < this.getRangeCount()) {
            return ((TypedRegion)this.fTokens.get(index)).getLength();
        }
        return 0;
    }

    public int getTokenStart(int index) {
        if (index < this.getRangeCount()) {
            return ((TypedRegion)this.fTokens.get(index)).getOffset();
        }
        return this.fText.length();
    }

    public String getTokenString(int index) {
        if (index < this.getRangeCount()) {
            return this.fText.substring(this.getTokenStart(index), this.getTokenStart(index) + this.getTokenLength(index));
        }
        return null;
    }

    public String getTokenType(int index) {
        if (index < this.getRangeCount()) {
            return ((TypedRegion)this.fTokens.get(index)).getType();
        }
        return null;
    }

    public boolean rangesEqual(int thisIndex, IRangeComparator other, int otherIndex) {
        if (other != null && this.getClass() == other.getClass()) {
            int otherLen;
            SimpleActionComparator otherTC = (SimpleActionComparator)other;
            String type = this.getTokenType(thisIndex);
            if (type == WHITESPACE_TYPE) {
                String otherType = otherTC.getTokenType(otherIndex);
                return otherType == WHITESPACE_TYPE;
            }
            if (type == VARIABLE_TYPE) {
                return false;
            }
            int thisLen = this.getTokenLength(thisIndex);
            if (thisLen == (otherLen = otherTC.getTokenLength(otherIndex))) {
                return this.fText.regionMatches(false, this.getTokenStart(thisIndex), otherTC.fText, otherTC.getTokenStart(otherIndex), thisLen);
            }
        }
        return false;
    }

    public boolean skipRangeComparison(int length, int max, IRangeComparator other) {
        if (!this.fShouldEscape) {
            return false;
        }
        if (this.getRangeCount() < 50 || other.getRangeCount() < 50) {
            return false;
        }
        if (max < 100) {
            return false;
        }
        if (length < 100) {
            return false;
        }
        if (max > 800) {
            return true;
        }
        return length >= max / 4;
    }

    private void splitVariables(int offset, int length) {
        int lastEnd = 0;
        int varStart = this.fText.indexOf(SimpleTextInsertAction.PARM_START, offset);
        while (varStart != -1 && varStart < length) {
            int varEnd = this.fText.indexOf(SimpleTextInsertAction.PARM_END, varStart);
            if (varEnd != -1 && varEnd < length) {
                varStart = this.fText.lastIndexOf(SimpleTextInsertAction.PARM_START, varEnd);
                if (lastEnd < varStart) {
                    this.splitWordsSpaces(lastEnd, varStart - lastEnd);
                }
                TypedRegion region = new TypedRegion(varStart, varEnd + SimpleTextInsertAction.PARM_END.length() - varStart, VARIABLE_TYPE);
                this.fTokens.add(region);
                lastEnd = varEnd + SimpleTextInsertAction.PARM_END.length();
                varStart = this.fText.indexOf(SimpleTextInsertAction.PARM_START, varEnd + 1);
                continue;
            }
            varStart = -1;
        }
        if (lastEnd < offset + length - 1) {
            this.splitWordsSpaces(lastEnd, offset + length - lastEnd);
        }
    }

    protected void splitWordsSpaces(int offset, int length) {
        int tokenOffset = offset;
        int tokenLength = 1;
        String tokenCategory = WORD_TYPE;
        char c = this.fText.charAt(offset);
        if (Character.isWhitespace(c)) {
            tokenCategory = WHITESPACE_TYPE;
        } else if (c == ',' || c == '\"' || c == '\'') {
            tokenCategory = PUNCTUATION_TYPE;
        }
        int i = offset + 1;
        while (i < offset + length) {
            c = this.fText.charAt(i);
            ++tokenLength;
            String category = WORD_TYPE;
            if (Character.isWhitespace(c)) {
                category = WHITESPACE_TYPE;
            } else if (c == ',' || c == '\"' || c == '\'') {
                category = PUNCTUATION_TYPE;
            }
            if (category != tokenCategory || tokenCategory == PUNCTUATION_TYPE) {
                TypedRegion region = new TypedRegion(tokenOffset, --tokenLength, tokenCategory);
                this.fTokens.add(region);
                tokenCategory = category;
                tokenOffset = i;
                tokenLength = 1;
            }
            ++i;
        }
        TypedRegion region = new TypedRegion(tokenOffset, tokenLength, tokenCategory);
        this.fTokens.add(region);
    }
}

