/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.qev.actions;

import com.ibm.etools.qev.Debug;
import com.ibm.etools.qev.actions.IActionDetector;
import com.ibm.etools.qev.actions.InfoRegion;
import com.ibm.etools.qev.actions.SimpleAction;
import com.ibm.etools.qev.model.IEvent;
import com.ibm.etools.qev.registry.ActionDefinition;
import com.ibm.etools.qev.registry.DefinitionsRegistry;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public abstract class CommentActionDetector
implements IActionDetector {
    public static final String ACTION_BEGIN = "actionBegin: ";
    public static final String ACTION_END = "actionEnd: ";

    protected SimpleAction extractAction(IEvent event, String actionID, IDocument doc, InfoRegion begin, InfoRegion end) {
        SimpleAction action = null;
        ActionDefinition actionDef = DefinitionsRegistry.getRegistry().getAction(actionID);
        if (actionDef != null) {
            action = actionDef.createSimpleAction();
            action.setId(actionID);
        }
        if (action != null) {
            if (action.extract(event, doc, begin, end)) {
                return action;
            }
            action = null;
        }
        return action;
    }

    public InfoRegion findActionPostfix(String script, int offset, int length, String actionID) {
        int startOffset = offset;
        boolean keepSearching = true;
        while (startOffset < offset + length - 1 && keepSearching) {
            int endComment;
            int commentBegin;
            keepSearching = false;
            String subscript = script.substring(startOffset, offset + length);
            int end = subscript.indexOf(ACTION_END);
            if (end <= -1 || (commentBegin = subscript.lastIndexOf(this.getBeginComment(), end)) <= -1 || (endComment = subscript.indexOf(this.getEndComment(), commentBegin + this.getBeginComment().length() - 1)) <= -1 || endComment < end + ACTION_END.length()) continue;
            String id = subscript.substring(end + ACTION_END.length() - 1, endComment).trim();
            if (actionID == null || actionID.equals(id)) {
                int beginCommentOffset = commentBegin + startOffset;
                int commentLength = endComment + this.getEndComment().length() - commentBegin;
                Debug.trace("actions", "CommentActionDetector#findEndComment: begin=" + beginCommentOffset + " length=" + commentLength + " actionID=" + actionID);
                return new InfoRegion(beginCommentOffset, commentLength, id);
            }
            startOffset = startOffset + endComment + this.getEndComment().length() - 1;
            keepSearching = true;
        }
        return null;
    }

    public InfoRegion findActionPrefix(String script, int offset, int length, String actionID) {
        int startOffset = offset;
        boolean keepSearching = true;
        while (startOffset < offset + length - 1 && keepSearching) {
            int endComment;
            String subsubscript;
            int commentBegin;
            keepSearching = false;
            String subscript = script.substring(startOffset, offset + length);
            int begin = subscript.indexOf(ACTION_BEGIN);
            if (begin <= -1 || (commentBegin = (subsubscript = subscript.substring(0, begin)).lastIndexOf(this.getBeginComment())) <= -1 || (endComment = subscript.indexOf(this.getEndComment(), commentBegin + this.getBeginComment().length() - 1)) <= -1 || endComment < begin + ACTION_BEGIN.length()) continue;
            String id = subscript.substring(begin + ACTION_BEGIN.length() - 1, endComment).trim();
            if (actionID == null || actionID.equals(id)) {
                int beginCommentOffset = commentBegin + startOffset;
                int commentLength = endComment + this.getEndComment().length() - commentBegin;
                Debug.trace("actions", "CommentActionDetector#findBeginComment: begin=" + beginCommentOffset + " length=" + commentLength + " actionID=" + actionID);
                return new InfoRegion(beginCommentOffset, commentLength, id);
            }
            startOffset = startOffset + endComment + this.getEndComment().length() - 1;
            keepSearching = true;
        }
        return null;
    }

    @Override
    public List findActions(IEvent event, IDocument doc, int offset, int length) {
        ArrayList<SimpleAction> actions = new ArrayList<SimpleAction>();
        String script = null;
        if (length == 0) {
            length = doc.getLength() - offset;
        }
        try {
            script = doc.get(offset, length);
            InfoRegion beginR = this.findActionPrefix(script, 0, length, null);
            while (beginR != null) {
                int nextLength;
                SimpleAction sa = null;
                int nextOffset = beginR.getOffset() + beginR.getLength() - 1;
                InfoRegion endR = this.findActionPostfix(script, nextOffset, nextLength = length - nextOffset, beginR.getInfo());
                if (endR != null) {
                    nextOffset = endR.getOffset() + endR.getLength() - 1;
                    nextLength = length - nextOffset;
                    String actionID = beginR.getInfo();
                    Debug.trace("actions", "CommentActionDetector#findActions: actionID=" + actionID);
                    beginR = new InfoRegion(beginR.getOffset() + offset, beginR.getLength(), beginR.getInfo());
                    endR = new InfoRegion(endR.getOffset() + offset, endR.getLength(), endR.getInfo());
                    sa = this.extractAction(event, actionID, doc, beginR, endR);
                    if (sa != null) {
                        actions.add(sa);
                    } else {
                        Debug.trace("actions", "actions: findActions: could not find action matching actionID: " + actionID);
                    }
                    beginR = this.findActionPrefix(script, nextOffset, nextLength, null);
                    continue;
                }
                beginR = null;
            }
        }
        catch (BadLocationException exception) {
            Debug.log(204, exception.getMessage());
        }
        return actions;
    }

    public String getActionPostfix(SimpleAction action) {
        return String.valueOf(this.getBeginComment()) + ACTION_END + action.getId() + this.getEndComment();
    }

    public String getActionPrefix(SimpleAction action) {
        return String.valueOf(this.getBeginComment()) + ACTION_BEGIN + action.getId() + this.getEndComment();
    }

    protected abstract String getBeginComment();

    protected abstract String getEndComment();
}

