/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.web.internal.resource.cmds.items;

import com.ibm.etools.diagram.model.internal.DiagramCommandResult;
import com.ibm.etools.diagram.model.internal.commands.support.IDeletionCommand;
import com.ibm.etools.diagram.model.internal.commands.support.ResourceDescriptor;
import com.ibm.etools.diagram.model.internal.commands.support.ResourceTree;
import com.ibm.etools.diagram.model.internal.emf.Item;
import com.ibm.etools.diagram.model.internal.emf.MNode;
import com.ibm.etools.diagram.model.internal.emf.NodeItem;
import com.ibm.etools.model2.diagram.web.internal.edithelper.cmds.CommandExecutionAprover;
import com.ibm.etools.model2.diagram.web.internal.edithelper.cmds.TargetAdapter;
import com.ibm.etools.model2.diagram.web.internal.edithelper.cmds.WebDiagramCommandHelper;
import com.ibm.etools.model2.diagram.web.internal.nls.Messages;
import com.ibm.etools.model2.diagram.web.internal.providers.WebProvider;
import com.ibm.etools.model2.diagram.web.internal.resource.cmds.ResourceModificationCommand;
import com.ibm.etools.model2.diagram.web.internal.resource.cmds.items.CreateWebPageLinkResourceCommand;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.web.AbstractWebProvider;
import com.ibm.etools.webedit.common.editdomain.HTMLEditDomain;
import com.ibm.etools.webtools.model.util.ModelUtil;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.osgi.util.NLS;

public class DeleteWebPageLinkResourceCommand
extends ResourceModificationCommand
implements IDeletionCommand {
    private final IAdaptable itemAdaptable;
    private String rawLink;
    private IFile file;
    private final List resourcesToDelete;
    private int index;
    private final MNode sourceNode;

    public DeleteWebPageLinkResourceCommand(String string, IAdaptable itemAdaptable, List resourcesToDelete) {
        super(string);
        this.itemAdaptable = itemAdaptable;
        this.resourcesToDelete = resourcesToDelete;
        this.sourceNode = this.getNodeItem().getNode();
    }

    protected NodeItem getNodeItem() {
        if (this.itemAdaptable == null) {
            return null;
        }
        return (NodeItem)this.itemAdaptable.getAdapter(NodeItem.class);
    }

    @Override
    protected IFile getFileToModify() {
        if (this.file == null) {
            NodeItem item = this.getNodeItem();
            if (item == null) {
                return null;
            }
            this.file = WebProvider.getFileForNode(item.getNode());
        }
        return this.file;
    }

    private String getCurrentTarget() {
        ILink handle = (ILink)this.getNodeItem().getAdapter(ILink.class);
        if (handle != null) {
            return AbstractWebProvider.trimQuotes((String)handle.getLinkText());
        }
        return null;
    }

    @Override
    protected CommandResult doExecuteResourceModification(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        NodeItem item = this.getNodeItem();
        if (item == null) {
            return CommandResult.newOKCommandResult();
        }
        if (this.resourcesToDelete == null) {
            return CommandResult.newOKCommandResult();
        }
        if (this.resourcesToDelete.contains(this.getCurrentTarget())) {
            this.rawLink = this.getCurrentTarget();
            this.file = this.getFileToModify();
            if (this.file != null && this.file.exists()) {
                HTMLEditDomain domain = null;
                try {
                    try {
                        domain = ModelUtil.getEditDomain((IFile)this.file);
                        this.index = WebProvider.getDuplicateIndex((Item)item);
                        WebDiagramCommandHelper.removeLink(this.index, domain, "A", Collections.singleton("href"), this.rawLink);
                    }
                    catch (Exception e) {
                        CommandResult commandResult = DiagramCommandResult.newErrorCommandResult((Throwable)e);
                        try {
                            ModelUtil.releaseAndSaveIfNecessaryEditDomain((HTMLEditDomain)domain);
                        }
                        catch (Exception e2) {
                            return DiagramCommandResult.newErrorCommandResult((Throwable)e2);
                        }
                        return commandResult;
                    }
                }
                finally {
                    try {
                        ModelUtil.releaseAndSaveIfNecessaryEditDomain((HTMLEditDomain)domain);
                    }
                    catch (Exception e) {
                        return DiagramCommandResult.newErrorCommandResult((Throwable)e);
                    }
                }
            }
        }
        return CommandResult.newOKCommandResult();
    }

    @Override
    protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        HTMLEditDomain domain = null;
        try {
            try {
                domain = ModelUtil.getEditDomain((IFile)this.file);
                WebDiagramCommandHelper.removeLink(this.index, domain, "A", Collections.singleton("href"), this.rawLink);
            }
            catch (Exception e) {
                CommandResult commandResult = DiagramCommandResult.newErrorCommandResult((Throwable)e);
                try {
                    ModelUtil.releaseAndSaveIfNecessaryEditDomain((HTMLEditDomain)domain);
                }
                catch (Exception e2) {
                    return DiagramCommandResult.newErrorCommandResult((Throwable)e2);
                }
                return commandResult;
            }
        }
        finally {
            try {
                ModelUtil.releaseAndSaveIfNecessaryEditDomain((HTMLEditDomain)domain);
            }
            catch (Exception e) {
                return DiagramCommandResult.newErrorCommandResult((Throwable)e);
            }
        }
        return CommandResult.newOKCommandResult();
    }

    @Override
    protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        CreateWebPageLinkResourceCommand cmd = new CreateWebPageLinkResourceCommand(this.sourceNode, true, new CommandExecutionAprover(true), new TargetAdapter(this.rawLink));
        try {
            cmd.execute(progressMonitor, info);
            if (!cmd.getCommandResult().getStatus().isOK()) {
                CommandResult commandResult = cmd.getCommandResult();
                return commandResult;
            }
        }
        finally {
            cmd.dispose();
        }
        return CommandResult.newOKCommandResult();
    }

    public ResourceTree getDeletionTree() {
        ResourceDescriptor desc = new ResourceDescriptor((Object)this.getCurrentTarget());
        desc.setDisplayText(NLS.bind((String)Messages.DeleteXinfileX, (Object)this.getFileToModify().getLocation().lastSegment(), (Object)this.getCurrentTarget()));
        return new ResourceTree(desc);
    }
}

