/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.web.internal.resource.cmds.items;

import com.ibm.etools.diagram.model.internal.DiagramCommandResult;
import com.ibm.etools.diagram.model.internal.emf.MNode;
import com.ibm.etools.model2.diagram.web.internal.edithelper.cmds.CommandExecutionAprover;
import com.ibm.etools.model2.diagram.web.internal.edithelper.cmds.TargetAdapter;
import com.ibm.etools.model2.diagram.web.internal.edithelper.cmds.WebDiagramCommandHelper;
import com.ibm.etools.model2.diagram.web.internal.edithelper.cmds.factories.AnchorLinkFactory;
import com.ibm.etools.model2.diagram.web.internal.nls.Messages;
import com.ibm.etools.model2.diagram.web.internal.providers.WebProvider;
import com.ibm.etools.model2.diagram.web.internal.resource.cmds.ResourceModificationCommand;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.LinkNode;
import com.ibm.etools.references.management.ReferenceException;
import com.ibm.etools.references.management.ReferenceManager;
import com.ibm.etools.references.web.AbstractWebProvider;
import com.ibm.etools.webedit.common.editdomain.HTMLEditDomain;
import com.ibm.etools.webtools.model.util.ModelUtil;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;

public class CreateWebPageLinkResourceCommand
extends ResourceModificationCommand {
    private final MNode sourceNode;
    private final boolean createDups;
    private boolean alwaysCreateNew;
    private boolean undoable = false;
    private final CommandExecutionAprover createAprover;
    private final TargetAdapter targetAdapter;

    public CreateWebPageLinkResourceCommand(MNode sourceNode, boolean createDups, CommandExecutionAprover createAprover, TargetAdapter targetAdapter) {
        super(Messages.CreateHTMLLink);
        this.sourceNode = sourceNode;
        this.createAprover = createAprover;
        this.targetAdapter = targetAdapter;
        this.createDups = createDups;
    }

    @Override
    protected IFile getFileToModify() {
        return WebProvider.getFileForNode(this.sourceNode);
    }

    protected String getPath() {
        return this.targetAdapter.getTargetPath() == null ? "" : this.targetAdapter.getTargetPath();
    }

    @Override
    protected CommandResult doExecuteResourceModification(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (this.getFileToModify() == null || !this.getFileToModify().exists() || !this.createAprover.isProceed()) {
            return CommandResult.newOKCommandResult();
        }
        progressMonitor.beginTask("", 900);
        IFile file = this.getFileToModify();
        if (file != null && file.exists()) {
            boolean doCreate = true;
            if (!this.createDups) {
                Collection links;
                LinkNode node = ReferenceManager.getReferenceManager().getLinkNode(file);
                try {
                    links = node.getLinks(null);
                }
                catch (ReferenceException e) {
                    throw new ExecutionException(e.getMessage(), (Throwable)e);
                }
                for (ILink link : links) {
                    String linkText = link.getLinkText();
                    if (linkText == null) continue;
                    linkText = AbstractWebProvider.trimQuotes((String)linkText);
                    if (!this.getPath().toString().equals(linkText)) continue;
                    doCreate = false;
                    break;
                }
            }
            progressMonitor.worked(100);
            if (doCreate || this.alwaysCreateNew) {
                HTMLEditDomain domain = null;
                try {
                    try {
                        domain = ModelUtil.getEditDomain((IFile)file);
                        progressMonitor.worked(200);
                        String tagname = "A";
                        String attribute = "href";
                        if (this.alwaysCreateNew) {
                            AnchorLinkFactory factory = new AnchorLinkFactory(null, this.getPath(), this.getLinkLabel());
                            factory.setLinkContext(domain.getActiveSubModelContext());
                            WebDiagramCommandHelper.addLink(domain, factory, null);
                        } else {
                            boolean updated = WebDiagramCommandHelper.updateLink(0, domain, tagname, Collections.singleton(attribute), attribute, "", this.getPath());
                            if (!updated) {
                                AnchorLinkFactory factory = new AnchorLinkFactory(null, this.getPath(), this.getLinkLabel());
                                factory.setLinkContext(domain.getActiveSubModelContext());
                                WebDiagramCommandHelper.addLink(domain, factory, null);
                            }
                        }
                        progressMonitor.worked(400);
                        this.undoable = true;
                    }
                    catch (Exception e) {
                        CommandResult commandResult = DiagramCommandResult.newErrorCommandResult((Throwable)e);
                        if (domain != null) {
                            try {
                                ModelUtil.releaseAndSaveIfNecessaryEditDomain((HTMLEditDomain)domain);
                            }
                            catch (Exception e2) {
                                return DiagramCommandResult.newErrorCommandResult((Throwable)e2);
                            }
                        }
                        return commandResult;
                    }
                }
                finally {
                    if (domain != null) {
                        try {
                            ModelUtil.releaseAndSaveIfNecessaryEditDomain((HTMLEditDomain)domain);
                        }
                        catch (Exception e) {
                            return DiagramCommandResult.newErrorCommandResult((Throwable)e);
                        }
                    }
                }
            }
        }
        progressMonitor.done();
        return CommandResult.newOKCommandResult();
    }

    private String getLinkLabel() {
        return this.targetAdapter.getTargetLabel();
    }

    @Override
    protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        return this.doExecuteWithResult(progressMonitor, info);
    }

    @Override
    protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        IFile file;
        if (this.undoable && (file = this.getFileToModify()) != null && file.exists()) {
            HTMLEditDomain domain = null;
            try {
                try {
                    domain = ModelUtil.getEditDomain((IFile)file);
                    WebDiagramCommandHelper.removeLink(-1, domain, "A", Collections.singleton("href"), this.getPath());
                }
                catch (Exception e) {
                    CommandResult commandResult = DiagramCommandResult.newErrorCommandResult((Throwable)e);
                    try {
                        ModelUtil.releaseAndSaveIfNecessaryEditDomain((HTMLEditDomain)domain);
                    }
                    catch (Exception e2) {
                        return DiagramCommandResult.newErrorCommandResult((Throwable)e2);
                    }
                    return commandResult;
                }
            }
            finally {
                try {
                    ModelUtil.releaseAndSaveIfNecessaryEditDomain((HTMLEditDomain)domain);
                }
                catch (Exception e) {
                    return DiagramCommandResult.newErrorCommandResult((Throwable)e);
                }
            }
        }
        return CommandResult.newOKCommandResult();
    }

    public boolean isAlwaysCreateNew() {
        return this.alwaysCreateNew;
    }

    public void setAlwaysCreateNew(boolean alwaysCreateNew) {
        this.alwaysCreateNew = alwaysCreateNew;
    }

    @Override
    public boolean canExecute() {
        return true;
    }
}

