/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.web.internal.resource.cmds;

import com.ibm.etools.diagram.model.internal.commands.IWorkspaceLockMarker;
import com.ibm.etools.model2.diagram.web.internal.nls.Messages;
import com.ibm.etools.model2.diagram.web.internal.providers.WebProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.gmf.runtime.common.core.command.AbstractCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.ResourceUtil;

public abstract class ResourceModificationCommand
extends AbstractCommand
implements IWorkspaceLockMarker {
    public ResourceModificationCommand(String label) {
        super(label);
    }

    protected final CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        IResource[] resources;
        final IFile fileToModify = this.getFileToModify();
        if (fileToModify != null && fileToModify.exists() && this.isDirty(resources = new IResource[]{fileToModify})) {
            final boolean[] resultHolder = new boolean[1];
            if (Thread.currentThread() != PlatformUI.getWorkbench().getDisplay().getThread()) {
                PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        resultHolder[0] = ResourceModificationCommand.this.shouldSaveAndContinue(fileToModify);
                    }
                });
            } else {
                resultHolder[0] = this.shouldSaveAndContinue(fileToModify);
            }
            if (!resultHolder[0]) {
                progressMonitor.setCanceled(true);
                return CommandResult.newCancelledCommandResult();
            }
        }
        return this.doExecuteResourceModification(progressMonitor, info);
    }

    private boolean shouldSaveAndContinue(IFile fileToModify) {
        Shell shell = new Shell(PlatformUI.getWorkbench().getDisplay().getActiveShell(), 65536);
        try {
            shell.setSize(0, 0);
            shell.setVisible(true);
            MessageBox box = new MessageBox(shell, 65728);
            box.setText(Messages.SaveEditorsBeforeContinuing);
            box.setMessage(NLS.bind((String)Messages.ModifiesFileWithUnsavedChanges, (Object)WebProvider.getDocumentRootRelativePath(fileToModify)));
            if (box.open() != 64) {
                return false;
            }
            IDE.saveAllEditors((IResource[])new IResource[]{fileToModify}, (boolean)false);
            return true;
        }
        finally {
            shell.close();
            shell.dispose();
        }
    }

    private boolean isDirty(IResource[] resourceRoots) {
        final IResource[] finalResources = resourceRoots;
        final boolean[] result = new boolean[]{false};
        if (resourceRoots.length == 0) {
            return result[0];
        }
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                    public void run() {
                        ArrayList<IEditorPart> dirtyEditors = new ArrayList<IEditorPart>();
                        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
                        int i = 0;
                        while (i < windows.length) {
                            IWorkbenchWindow window = windows[i];
                            IWorkbenchPage[] pages = window.getPages();
                            int j = 0;
                            while (j < pages.length) {
                                IWorkbenchPage page = pages[j];
                                IEditorPart[] dirty = page.getDirtyEditors();
                                int k = 0;
                                while (k < dirty.length) {
                                    IEditorPart part = dirty[k];
                                    IFile file = ResourceUtil.getFile((IEditorInput)part.getEditorInput());
                                    if (file != null) {
                                        int l = 0;
                                        while (l < finalResources.length) {
                                            IResource resource = finalResources[l];
                                            if (resource.getFullPath().isPrefixOf(file.getFullPath())) {
                                                dirtyEditors.add(part);
                                                break;
                                            }
                                            ++l;
                                        }
                                    }
                                    ++k;
                                }
                                ++j;
                            }
                            ++i;
                        }
                        if (dirtyEditors.size() > 0) {
                            result[0] = true;
                        }
                    }
                });
            }
        });
        return result[0];
    }

    public List getAffectedFiles() {
        IFile file = this.getFileToModify();
        return file == null ? Collections.EMPTY_LIST : Collections.singletonList(file);
    }

    protected abstract IFile getFileToModify();

    protected abstract CommandResult doExecuteResourceModification(IProgressMonitor var1, IAdaptable var2) throws ExecutionException;

    protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        return CommandResult.newOKCommandResult();
    }

    protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        return CommandResult.newOKCommandResult();
    }

    public boolean canExecute() {
        IFile file = this.getFileToModify();
        return file != null && file.exists();
    }
}

