/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.web.internal.references;

import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.IResolvedReference;
import com.ibm.etools.references.management.ReferenceElementFactory;
import com.ibm.etools.references.services.providers.ILinkDetectorProvider;
import com.ibm.etools.references.services.providers.SharedModel;
import com.ibm.etools.references.web.AbstractWebProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.TreeWalker;

public class DiagramLinkDetector
implements ILinkDetectorProvider {
    public List<ILink> detectLinks(ReferenceElementFactory factory, SharedModel sharedModel, Set<IResolvedReference> incomingReferences) {
        ArrayList<ILink> links = new ArrayList<ILink>();
        if (sharedModel.getSharedModel() instanceof IDOMModel) {
            IDOMModel model = (IDOMModel)sharedModel.getSharedModel();
            IDOMDocument document = model.getDocument();
            TreeWalker iter = ((DocumentTraversal)document).createTreeWalker((Node)document, 1, null, false);
            HashMap<String, IDOMElement> elementToIdMap = new HashMap<String, IDOMElement>();
            Node n = iter.nextNode();
            while (n != null) {
                if ("xmi:XMI".equals(n.getNodeName())) {
                    n = iter.firstChild();
                    continue;
                }
                if ("DiagramModel:Model".equals(n.getNodeName())) {
                    n = iter.firstChild();
                    continue;
                }
                if ("diagram".equals(n.getNodeName())) {
                    links.addAll(this.processDiagramNode(iter, factory, elementToIdMap));
                    n = iter.nextSibling();
                    continue;
                }
                if ("edges".equals(n.getNodeName())) {
                    this.processEdgesNode(iter);
                    n = iter.nextSibling();
                    continue;
                }
                n = iter.nextSibling();
            }
        }
        return links;
    }

    private List<ILink> processEdgesNode(TreeWalker iter) {
        return Collections.emptyList();
    }

    private List<ILink> processDiagramNode(TreeWalker iter, ReferenceElementFactory factory, Map<String, IDOMElement> elementToIdMap) {
        ArrayList<ILink> links = new ArrayList<ILink>();
        Node child = iter.firstChild();
        while (child != null) {
            if ("nodes".equals(child.getNodeName())) {
                links.addAll(this.processNodes(iter, factory, elementToIdMap));
            }
            child = iter.nextSibling();
        }
        iter.parentNode();
        return links;
    }

    private List<ILink> processNodes(TreeWalker iter, ReferenceElementFactory factory, Map<String, IDOMElement> elementToIdMap) {
        ArrayList<ILink> links = new ArrayList<ILink>();
        Node current = iter.getCurrentNode();
        while (current != null) {
            String id = this.getAttribute(current, "xmi:id");
            if (id != null) {
                elementToIdMap.put(id, (IDOMElement)current);
            }
            if ("com.ibm.etools.model2.diagram.web.WebPageNode".equals(this.getAttribute(current, "type"))) {
                Node child = iter.firstChild();
                while (child != null) {
                    if ("web.path.key".equals(this.getAttribute(child, "name"))) {
                        ILink link = AbstractWebProvider.createLink((ReferenceElementFactory)factory, (IDOMElement)((IDOMElement)child), (IDOMAttr)((IDOMAttr)((IDOMElement)child).getAttributeNode("value")), (String)"wdeWebPath", null);
                        links.add(link);
                    }
                    child = iter.nextSibling();
                }
                iter.parentNode();
            }
            current = iter.nextSibling();
        }
        return links;
    }

    private String getAttribute(Node node, String attribute) {
        return ((IDOMElement)node).getAttribute(attribute);
    }
}

