/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.web.internal.refactoring;

import com.ibm.etools.diagram.model.internal.emf.IPropertyHolder;
import com.ibm.etools.diagram.model.internal.emf.MNode;
import com.ibm.etools.diagram.model.internal.emf.TypedElement;
import com.ibm.etools.model2.diagram.web.internal.WDEEditingDomainManager;
import com.ibm.etools.model2.diagram.web.internal.nls.Messages;
import com.ibm.etools.model2.diagram.web.internal.providers.WebProvider;
import com.ibm.etools.model2.diagram.web.internal.refactoring.DiagramChange;
import com.ibm.etools.model2.diagram.web.internal.refactoring.ResourceVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.ISharableParticipant;
import org.eclipse.ltk.core.refactoring.participants.MoveArguments;
import org.eclipse.ltk.core.refactoring.participants.MoveParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;

public class DiagramMoveParticipant
extends MoveParticipant
implements ISharableParticipant {
    private final List<ObjectAndArgs> argsList = new ArrayList<ObjectAndArgs>();

    public void addElement(Object element, RefactoringArguments arguments) {
        ObjectAndArgs args = new ObjectAndArgs();
        args.args = (MoveArguments)arguments;
        args.element = element;
        this.argsList.add(args);
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        return RefactoringStatus.create((IStatus)Status.OK_STATUS);
    }

    public Change createChange(IProgressMonitor mon) throws CoreException, OperationCanceledException {
        ArrayList<Change> changes = new ArrayList<Change>();
        for (ObjectAndArgs info : this.argsList) {
            try {
                if (!info.args.getUpdateReferences()) continue;
                IResource r = (IResource)info.element;
                if (r instanceof IFile) {
                    IFile file = (IFile)r;
                    IContainer targetContainer = (IContainer)info.args.getDestination();
                    IFile targetFile = targetContainer.getFile((IPath)new Path(file.getName()));
                    changes.addAll(this.moveFile(mon, (IResource)file, targetContainer, file, targetFile));
                    continue;
                }
                if (!(r instanceof IFolder)) continue;
                IFolder anchorContainer = (IFolder)r;
                IPath anchorPath = anchorContainer.getFullPath();
                IContainer newContainer = (IContainer)info.args.getDestination();
                IPath newContainerPath = newContainer.getFullPath().append(anchorPath.lastSegment());
                ResourceVisitor children = new ResourceVisitor();
                anchorContainer.accept((IResourceVisitor)children);
                Collection<IResource> allChildren = children.getChildren();
                for (IResource resource : allChildren) {
                    if (!(resource instanceof IFile)) continue;
                    IPath targetPath = resource.getFullPath();
                    int strippedSegments = targetPath.matchingFirstSegments(anchorPath);
                    targetPath = targetPath.removeFirstSegments(strippedSegments);
                    targetPath = newContainerPath.append(targetPath);
                    IFile targetFile = ResourcesPlugin.getWorkspace().getRoot().getFile(targetPath);
                    changes.addAll(this.moveFile(mon, (IResource)anchorContainer, newContainer, (IFile)resource, targetFile));
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
                return null;
            }
        }
        if (changes.isEmpty()) {
            return null;
        }
        CompositeChange change = new CompositeChange(Messages.DiagramMoveParticipant_DiagramChanges, changes.toArray(new Change[changes.size()]));
        return change;
    }

    private List<Change> moveFile(IProgressMonitor monitor, IResource subject, IContainer newContainer, IFile sourceFile, IFile targetFile) {
        ArrayList<Change> changes = new ArrayList<Change>();
        List<Resource> resources = WDEEditingDomainManager.INSTANCE.getModelRoots();
        for (Resource resource : resources) {
            TreeIterator itr = resource.getAllContents();
            while (itr.hasNext()) {
                MNode node;
                EObject object = (EObject)itr.next();
                if (!"http://www.ibm.com/etools/7.0/DiagramModel".equals(object.eClass().getEPackage().getNsURI()) || !(object instanceof MNode) || !WebProvider.isWebPageNode((TypedElement)(node = (MNode)object))) continue;
                IFile file = sourceFile;
                IFile nodeFile = WebProvider.getFileForNode(node);
                if (!file.getFullPath().equals((Object)nodeFile.getFullPath())) continue;
                HashMap<String, String> map = new HashMap<String, String>();
                IPath newPath = WebProvider.getDocumentRootRelativePath(targetFile);
                map.put("web.path.key", newPath.toString());
                DiagramChange change = new DiagramChange((IPropertyHolder)node, map);
                changes.add(change);
            }
        }
        return changes;
    }

    public String getName() {
        return Messages.DiagramMoveParticipant_UpdateWDE;
    }

    protected boolean initialize(Object element) {
        ObjectAndArgs args = new ObjectAndArgs();
        args.args = this.getArguments();
        args.element = element;
        this.argsList.add(args);
        return true;
    }

    private class ObjectAndArgs {
        public Object element;
        public MoveArguments args;

        private ObjectAndArgs() {
        }
    }
}

