/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.web.internal.providers.item;

import com.ibm.etools.diagram.model.internal.commands.CreateNodeItemCommand;
import com.ibm.etools.diagram.model.internal.emf.Compartment;
import com.ibm.etools.diagram.model.internal.emf.DiagramModelFactory;
import com.ibm.etools.diagram.model.internal.emf.NodeItem;
import com.ibm.etools.diagram.model.internal.emf.Property;
import com.ibm.etools.diagram.model.internal.providers.INodeItemProvider;
import com.ibm.etools.model2.diagram.web.internal.providers.WebProvider;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.LinkNode;
import com.ibm.etools.references.management.ReferenceException;
import com.ibm.etools.references.management.ReferenceManager;
import com.ibm.etools.references.management.SpecializedType;
import com.ibm.etools.references.web.AbstractWebProvider;
import com.ibm.etools.references.web.URIUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;

public class WebPageLinkNodeItemProvider
extends WebProvider
implements INodeItemProvider {
    public List<NodeItem> getModelChildren(Compartment node) {
        ArrayList<NodeItem> results = new ArrayList<NodeItem>();
        EList item = node.getItems();
        for (NodeItem nodeItem : item) {
            if (!"com.ibm.etools.model2.diagram.web.WebPageLinkNodeItem".equals(nodeItem.getType())) continue;
            results.add(nodeItem);
        }
        return results;
    }

    public Collection<ILink> getChildren(Compartment node) {
        IFile webPageFile = WebPageLinkNodeItemProvider.getFileForNode(node.getParent());
        if (webPageFile == null || !webPageFile.exists()) {
            return Collections.EMPTY_LIST;
        }
        LinkNode fileNode = ReferenceManager.getReferenceManager().getLinkNode(webPageFile);
        ArrayList<ILink> results = new ArrayList<ILink>();
        try {
            SpecializedType linkType = ReferenceManager.getReferenceManager().getLinkType("web.commonlink");
            Collection links = fileNode.getLinks(linkType, SpecializedType.Depth.ZERO, null);
            Iterator iterator = links.iterator();
            while (iterator.hasNext()) {
                ILink link = (ILink)iterator.next();
                URIUtil.ParsedURI uri = URIUtil.parse((String)AbstractWebProvider.trimQuotes((String)link.getLinkText()));
                if (link.getName() != null) {
                    iterator.remove();
                    continue;
                }
                if (uri.path.endsWith("css") || uri.path.endsWith("gif") || uri.path.endsWith("jpg") || uri.path.endsWith("jpeg") || uri.path.endsWith("png") || (uri.path == null || uri.path.trim().length() == 0) && uri.fragment != null || uri.fragment != null && uri.fragment.length() == 0 || uri.path.equals("/") || uri.path.equals("\\")) {
                    iterator.remove();
                    continue;
                }
                if (uri.scheme != null && uri.scheme.length() > 0) {
                    iterator.remove();
                    continue;
                }
                String editable = link.getParameter("editable");
                if (editable == null || !"0".equals(editable)) continue;
                iterator.remove();
            }
            return links;
        }
        catch (ReferenceException e) {
            e.printStackTrace();
            return results;
        }
    }

    public void refreshNodeItems(Compartment node) {
        List<NodeItem> modelChildren = this.getModelChildren(node);
        Collection<ILink> children = this.getChildren(node);
        ArrayList<NodeItem> orphaned = new ArrayList<NodeItem>();
        for (NodeItem item : modelChildren) {
            ILink handle = (ILink)item.getAdapter(ILink.class);
            if (handle == null) {
                orphaned.add(item);
                continue;
            }
            if (children.remove(handle)) continue;
            orphaned.add(item);
        }
        for (NodeItem item : orphaned) {
            node.getItems().remove((Object)item);
        }
        int untargettedIndex = -1;
        for (final ILink linkHandle : children) {
            final String trimmed = AbstractWebProvider.trimQuotes((String)linkHandle.getLinkText());
            if ("".equals(trimmed)) {
                ++untargettedIndex;
            }
            CreateElementRequest req = new CreateElementRequest((EObject)node, ElementTypeRegistry.getInstance().getType("com.ibm.etools.model2.diagram.web.WebPageLinkNodeItem"));
            CreateNodeItemCommand cmd = new CreateNodeItemCommand(req, true){

                protected EObject doDefaultElementCreation() {
                    NodeItem item = (NodeItem)super.doDefaultElementCreation();
                    item.addAdapter((Object)linkHandle, ILink.class);
                    Property property = DiagramModelFactory.eINSTANCE.createProperty();
                    property = DiagramModelFactory.eINSTANCE.createProperty();
                    property.setDisplayable(false);
                    property.setEditable(false);
                    property.setName("web.itemname.key");
                    property.setValue(trimmed);
                    item.getTransientProperties().add((Object)property);
                    item.setTitleProperty(property);
                    return item;
                }
            };
            try {
                cmd.execute(null, null);
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
    }

    public void compartmentCollapsed(Compartment node) {
    }

    public void compartmentExpanded(Compartment node) {
    }
}

