/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.web.internal.providers.item;

import com.ibm.etools.diagram.model.internal.commands.CreateNodeItemCommand;
import com.ibm.etools.diagram.model.internal.emf.Compartment;
import com.ibm.etools.diagram.model.internal.emf.DiagramModelFactory;
import com.ibm.etools.diagram.model.internal.emf.MNode;
import com.ibm.etools.diagram.model.internal.emf.NodeItem;
import com.ibm.etools.diagram.model.internal.emf.Property;
import com.ibm.etools.diagram.model.internal.providers.INodeItemProvider;
import com.ibm.etools.model2.diagram.web.internal.data.filter.DataFilterManager;
import com.ibm.etools.model2.diagram.web.internal.data.filter.IDataFilter;
import com.ibm.etools.model2.diagram.web.internal.providers.WebProvider;
import com.ibm.etools.model2.diagram.web.internal.providers.config.WebModelDataListener;
import com.ibm.etools.webtools.model.api.DataNode;
import com.ibm.etools.webtools.model.api.JSP;
import com.ibm.etools.webtools.model.api.WebModel;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNode;
import com.ibm.etools.webtools.pagedataview.ui.IPageDataNodeUIAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;

public class PageDataNodeItemProvider
extends WebProvider
implements INodeItemProvider {
    private final HashMap<Compartment, JSP> compartmentToJSP = new HashMap();

    public List<NodeItem> getModelChildren(Compartment node) {
        ArrayList<NodeItem> results = new ArrayList<NodeItem>();
        EList item = node.getItems();
        for (NodeItem nodeItem : item) {
            if (!"com.ibm.etools.model2.diagram.web.PageDataNodeItem".equals(nodeItem.getType())) continue;
            results.add(nodeItem);
        }
        return results;
    }

    public List getChildren(Compartment node) {
        IFile webPageFile = PageDataNodeItemProvider.getFileForNode(node.getParent());
        if (webPageFile == null || !webPageFile.exists()) {
            return Collections.EMPTY_LIST;
        }
        JSP jsp = this.compartmentToJSP.get(node);
        if (jsp != null) {
            WebModelDataListener listener = (WebModelDataListener)((Object)node.getParent().getAdapter(WebModelDataListener.class));
            if (listener != null) {
                listener.ignoreNode(node.getParent());
            }
            List data = new ArrayList();
            try {
                data.addAll(jsp.getData());
                data = this.filterData(data, node.getParent());
            }
            finally {
                if (listener != null) {
                    listener.unIgnoreNode(node.getParent());
                }
            }
            return data;
        }
        return Collections.EMPTY_LIST;
    }

    private List filterData(List data, MNode node) {
        List<Object> filters = DataFilterManager.getFilters();
        for (IDataFilter iDataFilter : filters) {
            data = iDataFilter.filterData(data, node);
        }
        return data;
    }

    public void refreshNodeItems(Compartment node) {
        List<NodeItem> modelChildren = this.getModelChildren(node);
        List children = this.getChildren(node);
        ArrayList<NodeItem> orphaned = new ArrayList<NodeItem>();
        for (NodeItem item : modelChildren) {
            DataNode handle = (DataNode)item.getAdapter(DataNode.class);
            if (handle == null) {
                orphaned.add(item);
                continue;
            }
            if (children.remove(handle)) continue;
            orphaned.add(item);
        }
        for (NodeItem item : orphaned) {
            node.getItems().remove((Object)item);
        }
        for (final DataNode datanode : children) {
            CreateElementRequest req = new CreateElementRequest((EObject)node, ElementTypeRegistry.getInstance().getType("com.ibm.etools.model2.diagram.web.PageDataNodeItem"));
            CreateNodeItemCommand cmd = new CreateNodeItemCommand(req, true){

                protected EObject doDefaultElementCreation() {
                    NodeItem item = (NodeItem)super.doDefaultElementCreation();
                    item.addAdapter((Object)datanode, DataNode.class);
                    Property property = DiagramModelFactory.eINSTANCE.createProperty();
                    property.setDisplayable(true);
                    property.setEditable(false);
                    property.setName("data name");
                    IPageDataNode pageData = (IPageDataNode)datanode.getUnderlying();
                    IPageDataNodeUIAttribute attribute = (IPageDataNodeUIAttribute)pageData.getAdapter(IPageDataNodeUIAttribute.ADAPTER_KEY);
                    property.setValue(attribute.getLabel(pageData));
                    item.getTransientProperties().add((Object)property);
                    item.setTitleProperty(property);
                    return item;
                }
            };
            try {
                cmd.execute(null, null);
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
    }

    public void compartmentCollapsed(Compartment node) {
        JSP jsp = this.compartmentToJSP.remove(node);
        node.getParent().removeAdapter(WebModelDataListener.class);
        if (jsp != null) {
            jsp.releaseData();
        }
    }

    public void compartmentExpanded(Compartment node) {
        MNode parent;
        WebModel model;
        IFile webPageFile = PageDataNodeItemProvider.getFileForNode(node.getParent());
        if (webPageFile != null && webPageFile.exists() && (model = (WebModel)(parent = node.getParent()).getParent().getAdapter(WebModel.class)) != null) {
            JSP jsp = model.getJSP(webPageFile);
            this.compartmentToJSP.put(node, jsp);
            node.refreshItems();
        }
    }
}

