/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.web.internal.providers.edgeresolver;

import com.ibm.etools.diagram.model.internal.emf.DiagramModelFactory;
import com.ibm.etools.diagram.model.internal.emf.IPropertyHolder;
import com.ibm.etools.diagram.model.internal.emf.Item;
import com.ibm.etools.diagram.model.internal.emf.MEdge;
import com.ibm.etools.diagram.model.internal.emf.MNode;
import com.ibm.etools.diagram.model.internal.emf.Property;
import com.ibm.etools.diagram.model.internal.emf.TypedElement;
import com.ibm.etools.diagram.model.internal.providers.IEdgeResolverProvider;
import com.ibm.etools.diagram.model.internal.providers.ModelDescriptor;
import com.ibm.etools.diagram.model.internal.providers.SourceReference;
import com.ibm.etools.model2.base.util.Model2Util;
import com.ibm.etools.model2.diagram.web.internal.providers.WebProvider;
import com.ibm.etools.references.management.ILink;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;

public class WebPageEdgeResolverProvider
extends WebProvider
implements IEdgeResolverProvider {
    public boolean isResolvable(MNode target, SourceReference ref) {
        if (!ref.getEdgeType().getId().equals("com.ibm.etools.model2.diagram.web.HREFEdgeType")) {
            return false;
        }
        IFile t = (IFile)ref.getParameter("web.itemname.key");
        if (t == null) {
            return false;
        }
        IFile path = WebPageEdgeResolverProvider.getFileForNode(target);
        if (path == null) {
            return false;
        }
        return t.equals((Object)path);
    }

    public void instantiateEdge(MEdge edge, SourceReference reference, MNode target) {
        Integer dupIndex = (Integer)reference.getParameter("web.dup.index");
        if (dupIndex != null) {
            Property indexProperty = DiagramModelFactory.eINSTANCE.createProperty();
            indexProperty.setName("web.dup.index");
            indexProperty.setValue(dupIndex.toString());
            edge.getPersistedProperties().add((Object)indexProperty);
        }
    }

    public void instantiateNode(SourceReference reference, MNode target, ModelDescriptor descriptor) {
        Property title = DiagramModelFactory.eINSTANCE.createProperty();
        title.setName("web.path.key");
        IFile targetFile = (IFile)descriptor.getParameter("web.path.key");
        IPath path = Model2Util.getDocRootRelativePath((IFile)targetFile);
        title.setValue(path.toString());
        target.setTitleProperty(title);
        target.getPersistedProperties().add((Object)title);
    }

    public Collection getTargetableNodeDescriptors(IElementType targetNodeType, SourceReference reference) {
        if (reference.getEdgeType().getId().equals("com.ibm.etools.model2.diagram.web.HREFEdgeType")) {
            IFile s = (IFile)reference.getParameter("web.itemname.key");
            if (s == null) {
                return Collections.EMPTY_LIST;
            }
            Item item = reference.getSource();
            ILink target = WebProvider.getTarget((IAdaptable)item);
            if (target == null) {
                return Collections.EMPTY_LIST;
            }
            if ("com.ibm.etools.model2.diagram.web.WebPageNode".equals(targetNodeType.getId()) && WebProvider.isTargetWebPage(target)) {
                ModelDescriptor descriptor = new ModelDescriptor(){

                    public boolean matches(MNode node) {
                        if (WebProvider.isWebPageNode((TypedElement)node)) {
                            IFile otherFile = WebPageEdgeResolverProvider.getFileForNode(node);
                            IFile myPath = (IFile)this.getParameter("web.path.key");
                            return myPath.equals((Object)otherFile);
                        }
                        return false;
                    }
                };
                descriptor.setDisplayName(reference.getDisplayText());
                descriptor.addParameter("web.path.key", reference.getParameter("web.itemname.key"));
                return Collections.singletonList(descriptor);
            }
            if ("com.ibm.etools.model2.diagram.web.WebApplicationNode".equals(targetNodeType.getId()) && WebProvider.isTargetProject(target)) {
                ModelDescriptor descriptor = new ModelDescriptor(){

                    public boolean matches(MNode node) {
                        String path = WebPageEdgeResolverProvider.getStringProperty("web.project.key", (IPropertyHolder)node);
                        String myPath = (String)this.getParameter("web.path.key");
                        return myPath.equals(path);
                    }
                };
                descriptor.setDisplayName(reference.getDisplayText());
                descriptor.addParameter("web.project.key", reference.getParameter("web.itemname.key"));
                return Collections.singletonList(descriptor);
            }
        }
        return Collections.EMPTY_LIST;
    }
}

