/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.web.internal.providers.edgegenerator;

import com.ibm.etools.diagram.model.internal.emf.IPropertyHolder;
import com.ibm.etools.diagram.model.internal.emf.Item;
import com.ibm.etools.diagram.model.internal.emf.MEdge;
import com.ibm.etools.diagram.model.internal.emf.MNode;
import com.ibm.etools.diagram.model.internal.emf.TypedElement;
import com.ibm.etools.diagram.model.internal.providers.IEdgeGeneratorProvider;
import com.ibm.etools.diagram.model.internal.providers.SourceReference;
import com.ibm.etools.model2.diagram.web.internal.edithelper.cmds.WebTargetTypeUtilities;
import com.ibm.etools.model2.diagram.web.internal.providers.WebProvider;
import com.ibm.etools.references.management.ILink;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;

public class HREFEdgeTypeGeneratorProvider
extends WebProvider
implements IEdgeGeneratorProvider {
    public boolean isSourcedToItem(MEdge edge, Item node) {
        ILink source = (ILink)node.getAdapter(ILink.class);
        ILink target = WebProvider.getTarget((IAdaptable)node);
        if (target != null) {
            if (target.equals(edge.getTarget().getAdapter(ILink.class))) {
                int dupCount = HREFEdgeTypeGeneratorProvider.getDuplicateIndex(node);
                MEdge edgeToCompare = this.getLowestDupEdgeStartingAtIndex(edge, (List)node.getNode().getOutput(), dupCount);
                if (edge.equals(edgeToCompare)) {
                    return true;
                }
            }
        } else {
            String targetNode;
            String stringTarget = source.getLinkText();
            if (stringTarget != null && stringTarget.startsWith("/") && WebProvider.isWebApplicationNode((TypedElement)edge.getTarget()) && (targetNode = WebTargetTypeUtilities.getTargetNodePath(edge.getSource(), edge.getTarget())) != null && stringTarget.startsWith(targetNode)) {
                return true;
            }
        }
        return false;
    }

    private MEdge getLowestDupEdgeStartingAtIndex(MEdge forEdge, List edges, int index) {
        HashMap<MEdge, Integer> indexToEdgeMap = new HashMap<MEdge, Integer>();
        String edgeType = forEdge.getType();
        MNode target = forEdge.getTarget();
        for (MEdge edge : edges) {
            String dupIndex;
            if (!edgeType.equals(edge.getType()) || !target.equals(edge.getTarget()) || (dupIndex = WebProvider.getStringProperty("web.dup.index", (IPropertyHolder)edge)) == null) continue;
            indexToEdgeMap.put(edge, Integer.valueOf(dupIndex));
        }
        LinkedList<MEdge> sortedEdges = new LinkedList<MEdge>();
        for (Map.Entry entry : indexToEdgeMap.entrySet()) {
            Integer integer = (Integer)entry.getValue();
            MEdge edge = (MEdge)entry.getKey();
            boolean added = false;
            ListIterator<MEdge> iterator = sortedEdges.listIterator();
            while (iterator.hasNext()) {
                MEdge compareToEdge = (MEdge)iterator.next();
                Integer compartToInt = (Integer)indexToEdgeMap.get(compareToEdge);
                int comparison = integer.compareTo(compartToInt);
                if (comparison == 0) {
                    iterator.add(edge);
                    added = true;
                    break;
                }
                if (comparison >= 0) continue;
                iterator.previous();
                iterator.add(edge);
                iterator.next();
                added = true;
                break;
            }
            if (added) continue;
            sortedEdges.add(edge);
        }
        return index <= sortedEdges.size() - 1 ? (MEdge)sortedEdges.get(index) : null;
    }

    public Collection generateSources(Item source, IElementType edgeType, IElementType itemTypeToGenerate) {
        int dupIndex = 0;
        IResource r = WebProvider.getTargetContainer((IAdaptable)source);
        if (r instanceof IFile) {
            IFile targetFile = (IFile)r;
            dupIndex = HREFEdgeTypeGeneratorProvider.getDuplicateIndex(source);
            SourceReference ref = new SourceReference(source, edgeType);
            IPath modRelative = WebProvider.getDocumentRootRelativePath(targetFile);
            ref.setDisplayText(modRelative.toString());
            ref.addParameter("web.itemname.key", (Object)targetFile);
            ref.addParameter("web.dup.index", (Object)new Integer(dupIndex));
            return Collections.singletonList(ref);
        }
        return Collections.EMPTY_SET;
    }
}

