/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.web.internal.providers.config;

import com.ibm.etools.diagram.model.internal.emf.CommonElement;
import com.ibm.etools.diagram.model.internal.emf.Compartment;
import com.ibm.etools.diagram.model.internal.emf.DiagramModelFactory;
import com.ibm.etools.diagram.model.internal.emf.IPropertyHolder;
import com.ibm.etools.diagram.model.internal.emf.Item;
import com.ibm.etools.diagram.model.internal.emf.MDiagram;
import com.ibm.etools.diagram.model.internal.emf.MEdge;
import com.ibm.etools.diagram.model.internal.emf.MNode;
import com.ibm.etools.diagram.model.internal.emf.NodeItem;
import com.ibm.etools.diagram.model.internal.emf.Property;
import com.ibm.etools.diagram.model.internal.emf.SubItem;
import com.ibm.etools.diagram.model.internal.emf.TypedElement;
import com.ibm.etools.diagram.model.internal.providers.IConfiguratorProvider;
import com.ibm.etools.diagram.model.internal.providers.SourceReference;
import com.ibm.etools.diagram.model.internal.services.EdgeGeneratorService;
import com.ibm.etools.diagram.model.internal.services.EdgeResolverService;
import com.ibm.etools.model2.base.facet.ProjectFacetUtil;
import com.ibm.etools.model2.base.util.Model2Util;
import com.ibm.etools.model2.diagram.web.internal.nls.Messages;
import com.ibm.etools.model2.diagram.web.internal.providers.WebProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;

public class WebPageConfiguratorProvider
extends WebProvider
implements IConfiguratorProvider {
    public void configureNew(CommonElement element) {
        MNode nodeToConfigure = (MNode)element;
        IProject project = WebProvider.getProjectForElement(element);
        IFacetedProject fp = ProjectFacetUtil.getFacetedProject((IProject)project);
        String ext = ".html";
        if (fp != null && fp.hasProjectFacet(ProjectFacetUtil.getProjectFacet((String)"jst.web"))) {
            ext = ".jsp";
        }
        String newPath = String.valueOf(Messages.page) + ext;
        int increment = 1;
        while (!this.isUniquePath(nodeToConfigure, newPath, increment)) {
            ++increment;
        }
        Property property = DiagramModelFactory.eINSTANCE.createProperty();
        property.setName("web.path.key");
        property.setValue(this.createPath(newPath, increment).toString());
        property.setEditable(true);
        element.getPersistedProperties().add((Object)property);
        element.setTitleProperty(property);
    }

    private boolean isUniquePath(MNode nodeToConfigure, String newPath, int suffix) {
        MDiagram d = nodeToConfigure.getParent();
        EList nodes = d.getNodes();
        IPath incedPath = this.createPath(newPath, suffix);
        IFile newFile = WebPageConfiguratorProvider.getDocumentRootContainer(nodeToConfigure.eResource()).getFile(incedPath);
        for (MNode node : nodes) {
            IFile file = WebPageConfiguratorProvider.getFileForNode(node);
            if (file == null || !file.equals((Object)newFile)) continue;
            return false;
        }
        IProject project = WorkspaceSynchronizer.getFile((Resource)nodeToConfigure.eResource()).getProject();
        IPath path = Model2Util.getProjectRelativeDocRootPath((IVirtualComponent)WebPageConfiguratorProvider.getVirtualComponent((EObject)nodeToConfigure));
        return !project.getFile(path = path.append(incedPath)).exists();
    }

    private IPath createPath(String newPath, int suffix) {
        Path path = new Path(newPath);
        if (suffix > 1) {
            String extension = path.getFileExtension();
            if (extension != null) {
                path = path.removeFileExtension();
            }
            path = new Path(String.valueOf(path.toString()) + suffix);
            if (extension != null) {
                path = path.addFileExtension(extension);
            }
        }
        return path;
    }

    public void configureLoad(CommonElement element) {
    }

    @Override
    public boolean provides(IOperation operation) {
        return false;
    }

    public void configureExisting(CommonElement element, Object existing, Map options) {
        MNode node = (MNode)element;
        IFile file = null;
        if (existing instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)existing;
            file = (IFile)adaptable.getAdapter(IFile.class);
        } else if (existing instanceof String) {
            IContainer container = WebPageConfiguratorProvider.getDocumentRootContainer(element.eResource());
            file = Model2Util.getFile((IContainer)container, (String)((String)existing));
        } else if (existing instanceof IFile) {
            file = (IFile)existing;
        }
        if ("nodePhase".equals(options.get("configure phase"))) {
            boolean updated;
            if (file == null) {
                return;
            }
            String path = null;
            IPath thePath = WebProvider.getDocumentRootRelativePath(file);
            if (thePath != null) {
                path = thePath.toString();
            }
            if (!(updated = WebProvider.updateStringProperty("web.path.key", path, (IPropertyHolder)node))) {
                Property property = DiagramModelFactory.eINSTANCE.createProperty();
                property.setName("web.path.key");
                property.setValue(path);
                property.setEditable(true);
                node.getPersistedProperties().add((Object)property);
                node.setTitleProperty(property);
            }
        } else if ("edgePhase".equals(options.get("configure phase")) && Boolean.TRUE.equals(options.get("use defaults"))) {
            ArrayList nodes = new ArrayList(node.getParent().getNodes());
            nodes.remove(node);
            EList compartments = node.getCompartments();
            for (Compartment compartment : compartments) {
                if (WebProvider.isDataCompartment((TypedElement)compartment)) continue;
                EList items = compartment.getItems();
                for (NodeItem nodeItem : items) {
                    this.processItem(options, node, nodes, (Item)nodeItem);
                    EList subItems = nodeItem.getChildren();
                    for (SubItem subItem : subItems) {
                        this.processItem(options, node, nodes, (Item)subItem);
                    }
                }
            }
        }
    }

    private void processItem(Map<Object, Object> options, MNode node, List nodes, Item nodeItem) {
        List list = EdgeGeneratorService.getInstance().getGenerableEdgeTypes(nodeItem);
        for (IElementType edgeType : list) {
            List references = EdgeGeneratorService.getInstance().generateExistingReferences(nodeItem, edgeType, nodeItem.getElementType());
            for (SourceReference reference : references) {
                for (MNode otherNode : nodes) {
                    IElementType otherNodeType = otherNode.getElementType();
                    List resolvableEdgeTypes = EdgeResolverService.getInstance().getResolvableEdgeTypes(otherNodeType);
                    if (!resolvableEdgeTypes.contains(edgeType) || !EdgeResolverService.getInstance().isResolvable(otherNode, reference)) continue;
                    List outputs = EdgeGeneratorService.getInstance().getItemsEdges(nodeItem);
                    boolean foundMatch = false;
                    for (MEdge edge : outputs) {
                        if (!otherNode.equals(edge.getTarget()) || !edgeType.getId().equals(edge.getType())) continue;
                        foundMatch = true;
                        break;
                    }
                    if (foundMatch) continue;
                    CreateRelationshipRequest req = new CreateRelationshipRequest((EObject)node.getParent().getModel(), (EObject)node, (EObject)otherNode, edgeType);
                    IElementType webDiagramType = node.getParent().getElementType();
                    req.addParameters(options);
                    req.setParameter("existing edge", (Object)Boolean.TRUE);
                    req.setParameter("source reference", (Object)reference);
                    ICommand cmd = webDiagramType.getEditCommand((IEditCommandRequest)req);
                    if (!cmd.canExecute()) continue;
                    try {
                        cmd.execute(null, null);
                    }
                    catch (ExecutionException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}

