/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.web.internal.providers.config;

import com.ibm.etools.diagram.model.internal.emf.MDiagram;
import com.ibm.etools.diagram.model.internal.emf.MNode;
import com.ibm.etools.diagram.model.internal.metamodel.IDisposeListener;
import com.ibm.etools.diagram.model.internal.metamodel.ModelLifecycleManager;
import com.ibm.etools.model2.diagram.web.internal.providers.WebProvider;
import com.ibm.etools.references.events.IReferenceListener;
import com.ibm.etools.references.events.ReferenceEvent;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.IReferenceElement;
import com.ibm.etools.references.management.LinkNode;
import com.ibm.etools.references.management.ReferenceManager;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.ecore.EObject;

public class DiagramImageHandleListener
implements IDisposeListener,
IReferenceListener {
    private final MDiagram node;

    public DiagramImageHandleListener(MDiagram node) {
        this.node = node;
        this.node.addAdapter((Object)this, DiagramImageHandleListener.class);
        ReferenceManager.getReferenceManager().addReferenceListener((IReferenceListener)this);
        ModelLifecycleManager.getInstance().addDisposeListener((IDisposeListener)this, (EObject)node);
    }

    public void dispose() {
        ReferenceManager.getReferenceManager().removeReferenceListener((IReferenceListener)this);
        this.node.removeAdapter(DiagramImageHandleListener.class);
    }

    public void handleReferenceEvents(List<ReferenceEvent> events) {
        if (this.node.eResource() == null) {
            return;
        }
        if (events.isEmpty()) {
            return;
        }
        ArrayList nodes = new ArrayList(this.node.getNodes());
        for (ReferenceEvent event : events) {
            LinkNode linkNode;
            IReferenceElement source = event.getReferenceElement();
            if (source.getElementType() != IReferenceElement.ElementType.LINK || (linkNode = ((ILink)source).getContainer()) == null) continue;
            IResource resource = linkNode.getResource();
            if (resource instanceof IFile) {
                IFile file = (IFile)resource;
                for (MNode node : nodes) {
                    if (!file.equals((Object)WebProvider.getFileForNode(node))) continue;
                    WebProvider.asyncRefreshNode(node);
                }
                continue;
            }
            if (!(resource instanceof IProject)) continue;
            IProject project = (IProject)resource;
            for (MNode node : nodes) {
                if (!project.equals((Object)WebProvider.getProjectForNode(node))) continue;
                WebProvider.asyncRefreshNode(node);
            }
        }
    }
}

