/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.web.internal.edithelper.cmds.nodes;

import com.ibm.etools.diagram.model.internal.Debug;
import com.ibm.etools.diagram.model.internal.DiagramCommandResult;
import com.ibm.etools.diagram.model.internal.commands.support.IDeletionCommand;
import com.ibm.etools.diagram.model.internal.commands.support.ResourceDescriptor;
import com.ibm.etools.diagram.model.internal.commands.support.ResourceTree;
import com.ibm.etools.diagram.model.internal.emf.MNode;
import com.ibm.etools.model2.diagram.web.internal.WebPlugin;
import com.ibm.etools.model2.diagram.web.internal.providers.WebProvider;
import com.ibm.etools.model2.diagram.web.internal.resource.cmds.ResourceModificationCommand;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;

public class DeleteWebPageCommand
extends ResourceModificationCommand
implements IDeletionCommand {
    DestroyElementRequest request;
    private IFile file;
    private boolean undoable = false;

    public DeleteWebPageCommand(String label, DestroyElementRequest request) {
        super(label);
        this.request = request;
    }

    public ResourceTree getDeletionTree() {
        MNode resource = (MNode)this.request.getElementToDestroy();
        IFile file = WebProvider.getFileForNode(resource);
        if (file != null && file.exists()) {
            ResourceDescriptor descriptor = new ResourceDescriptor((Object)file);
            ResourceTree tree = new ResourceTree(descriptor);
            return tree;
        }
        return null;
    }

    @Override
    protected IFile getFileToModify() {
        MNode resource = (MNode)this.request.getElementToDestroy();
        IFile file = WebProvider.getFileForNode(resource);
        return file;
    }

    @Override
    public boolean canExecute() {
        return true;
    }

    @Override
    protected CommandResult doExecuteResourceModification(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        MNode resource = (MNode)this.request.getElementToDestroy();
        this.file = WebProvider.getFileForNode(resource);
        try {
            List resourceToDelete;
            if (this.file != null && this.file.exists() && (resourceToDelete = (List)this.request.getParameter("resources to delete")) != null && resourceToDelete.contains(this.file)) {
                this.file.delete(true, true, null);
                this.undoable = true;
            }
        }
        catch (CoreException e) {
            WebPlugin.getDefault().getLog().log(e.getStatus());
            return DiagramCommandResult.newErrorCommandResult((Throwable)e);
        }
        return CommandResult.newOKCommandResult();
    }

    @Override
    protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        return this.doExecuteWithResult(progressMonitor, info);
    }

    @Override
    protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (this.undoable) {
            try {
                IFileState[] state = this.file.getHistory(progressMonitor);
                if (state != null && state.length > 0) {
                    this.file.create(state[0].getContents(), false, progressMonitor);
                }
                Debug.noop();
            }
            catch (CoreException e) {
                WebPlugin.getDefault().getLog().log(e.getStatus());
                return DiagramCommandResult.newErrorCommandResult((Throwable)e);
            }
        }
        return CommandResult.newOKCommandResult();
    }
}

