/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.web.internal.edithelper.cmds.edges;

import com.ibm.etools.diagram.model.internal.emf.DiagramModelFactory;
import com.ibm.etools.diagram.model.internal.emf.IPropertyHolder;
import com.ibm.etools.diagram.model.internal.emf.MEdge;
import com.ibm.etools.diagram.model.internal.emf.Property;
import com.ibm.etools.model2.diagram.web.internal.edithelper.cmds.CommandExecutionAprover;
import com.ibm.etools.model2.diagram.web.internal.edithelper.cmds.IAdapterProxy;
import com.ibm.etools.model2.diagram.web.internal.edithelper.cmds.PropertyValueAdapter;
import com.ibm.etools.model2.diagram.web.internal.nls.Messages;
import com.ibm.etools.model2.diagram.web.internal.providers.WebProvider;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;

public class UpdateEdgePropertyCommand
extends AbstractTransactionalCommand {
    private IAdaptable edgeAdapter;
    private PropertyValueAdapter propertyValueAdapter;
    private Collection propertiesToDelete;
    private boolean create;
    private final String propertyName;
    private final CommandExecutionAprover aprover;

    public UpdateEdgePropertyCommand(TransactionalEditingDomain domain, String propertyName, IAdaptable edgeAdapter, PropertyValueAdapter propertyValueAdapter, Collection propertiesToDelete, boolean create) {
        this(domain, propertyName, edgeAdapter, propertyValueAdapter, propertiesToDelete, create, new CommandExecutionAprover(true));
    }

    public UpdateEdgePropertyCommand(TransactionalEditingDomain domain, String propertyName, IAdaptable edgeAdapter, PropertyValueAdapter propertyValueAdapter, Collection propertiesToDelete, boolean create, CommandExecutionAprover aprover) {
        super(domain, Messages.UpdateEdgeProperties, Collections.EMPTY_LIST);
        this.propertyName = propertyName;
        this.edgeAdapter = edgeAdapter;
        this.propertyValueAdapter = propertyValueAdapter;
        this.propertiesToDelete = propertiesToDelete;
        this.create = create;
        this.aprover = aprover;
    }

    public UpdateEdgePropertyCommand(String propertyName, MEdge edge, PropertyValueAdapter propertyValueAdapter, Collection propertiesToDelete, boolean create, CommandExecutionAprover aprover) {
        this(TransactionUtil.getEditingDomain((EObject)edge), propertyName, new IAdapterProxy((IAdaptable)edge), propertyValueAdapter, propertiesToDelete, create, aprover);
    }

    public UpdateEdgePropertyCommand(String propertyName, MEdge edge, PropertyValueAdapter propertyValueAdapter, Collection<String> propertiesToDelete, boolean create) {
        this(TransactionUtil.getEditingDomain((EObject)edge), propertyName, new IAdapterProxy((IAdaptable)edge), propertyValueAdapter, propertiesToDelete, create, new CommandExecutionAprover(true));
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (this.aprover.isProceed()) {
            MEdge edge = (MEdge)this.edgeAdapter.getAdapter(MEdge.class);
            String newProperty = null;
            if (this.propertyValueAdapter != null) {
                newProperty = this.propertyValueAdapter.getValue();
            }
            UpdateEdgePropertyCommand.updateProperty((IPropertyHolder)edge, this.propertyName, newProperty, this.propertiesToDelete, this.create);
        }
        return CommandResult.newOKCommandResult();
    }

    public static final void updateProperty(IPropertyHolder edge, String propertyName, String propertyValue, Collection propertiesToDelete, boolean create) {
        boolean updated;
        if (propertiesToDelete != null) {
            for (String propertyKey : propertiesToDelete) {
                WebProvider.deleteStringProperty(propertyKey, edge);
            }
        }
        if (!(updated = WebProvider.updateStringProperty(propertyName, propertyValue, edge)) && create) {
            Property edgeProperty = DiagramModelFactory.eINSTANCE.createProperty();
            edgeProperty.setName(propertyName);
            edgeProperty.setValue(propertyValue);
            edge.getPersistedProperties().add((Object)edgeProperty);
        }
    }
}

