/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.web.internal.edithelper.cmds.edges;

import com.ibm.etools.diagram.model.internal.commands.IWorkspaceLockMarker;
import com.ibm.etools.diagram.model.internal.commands.ReorientEdgeCommand;
import com.ibm.etools.diagram.model.internal.emf.CommonElement;
import com.ibm.etools.diagram.model.internal.emf.Item;
import com.ibm.etools.diagram.model.internal.emf.MEdge;
import com.ibm.etools.diagram.model.internal.emf.MNode;
import com.ibm.etools.diagram.model.internal.services.EdgeGeneratorService;
import com.ibm.etools.model2.diagram.web.internal.edithelper.cmds.CommandExecutionAprover;
import com.ibm.etools.model2.diagram.web.internal.edithelper.cmds.TargetAdapter;
import com.ibm.etools.model2.diagram.web.internal.edithelper.cmds.WebTargetTypeUtilities;
import com.ibm.etools.model2.diagram.web.internal.nls.Messages;
import com.ibm.etools.model2.diagram.web.internal.providers.WebProvider;
import com.ibm.etools.model2.diagram.web.internal.resource.cmds.items.UpdateWebPageLinkResourceCommand;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.web.AbstractWebProvider;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.AbstractCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;

public class RetargetHREFLinkCommand
extends AbstractCommand
implements IWorkspaceLockMarker {
    private final ReorientRelationshipRequest req;
    private UpdateWebPageLinkResourceCommand updateResource;

    public RetargetHREFLinkCommand(ReorientRelationshipRequest req) {
        super(Messages.UpdateHTMLLink);
        this.req = req;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        MEdge edge = (MEdge)this.req.getRelationship();
        if (edge.getSource().isRealized()) {
            ILink handle;
            MNode target = ReorientEdgeCommand.getTargetNode((EObject)this.req.getNewRelationshipEnd());
            String targetPath = WebTargetTypeUtilities.getTargetNodePath(edge.getSource(), target);
            targetPath = WebProvider.externalPathModification(targetPath, WebProvider.getProjectForElement((CommonElement)target));
            Item sourceItem = EdgeGeneratorService.getInstance().getEdgesItem((List)edge.getSource().getCompartments(), edge);
            if (sourceItem != null && (handle = (ILink)sourceItem.getAdapter(ILink.class)) != null) {
                String oldPath = AbstractWebProvider.trimQuotes((String)handle.getLinkText());
                this.updateResource = new UpdateWebPageLinkResourceCommand(oldPath, (IAdaptable)sourceItem, Collections.singletonList(oldPath), new CommandExecutionAprover(true), new TargetAdapter(targetPath));
                this.updateResource.execute(progressMonitor, info);
                if (!this.updateResource.getCommandResult().getStatus().isOK()) {
                    return this.updateResource.getCommandResult();
                }
            }
        }
        return CommandResult.newOKCommandResult();
    }

    protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (this.updateResource != null) {
            this.updateResource.redo(progressMonitor, info);
        }
        return CommandResult.newOKCommandResult();
    }

    protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (this.updateResource != null) {
            this.updateResource.undo(progressMonitor, info);
        }
        return CommandResult.newOKCommandResult();
    }
}

