/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.web.internal.edithelper.cmds.edges;

import com.ibm.etools.diagram.model.internal.commands.IWorkspaceLockMarker;
import com.ibm.etools.diagram.model.internal.emf.CommonElement;
import com.ibm.etools.diagram.model.internal.emf.DiagramModelFactory;
import com.ibm.etools.diagram.model.internal.emf.IPropertyHolder;
import com.ibm.etools.diagram.model.internal.emf.Item;
import com.ibm.etools.diagram.model.internal.emf.MEdge;
import com.ibm.etools.diagram.model.internal.emf.MNode;
import com.ibm.etools.diagram.model.internal.emf.NodeItem;
import com.ibm.etools.diagram.model.internal.emf.Property;
import com.ibm.etools.diagram.model.internal.providers.SourceReference;
import com.ibm.etools.diagram.model.internal.services.EdgeGeneratorService;
import com.ibm.etools.model2.diagram.web.internal.edithelper.cmds.CommandExecutionAprover;
import com.ibm.etools.model2.diagram.web.internal.edithelper.cmds.EdgeAdapter;
import com.ibm.etools.model2.diagram.web.internal.edithelper.cmds.TargetAdapter;
import com.ibm.etools.model2.diagram.web.internal.edithelper.cmds.WebTargetTypeUtilities;
import com.ibm.etools.model2.diagram.web.internal.providers.WebProvider;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.web.AbstractWebProvider;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;

public class CreateHREFLinkCommand
extends AbstractTransactionalCommand
implements IWorkspaceLockMarker {
    private final CreateRelationshipRequest request;
    private boolean askedRetargetAndAffirmative = false;
    private final CommandExecutionAprover createAprover;
    private final CommandExecutionAprover updateAprover;
    private final TargetAdapter targetAdapter;
    private final EdgeAdapter edgeAdapter;

    public CreateHREFLinkCommand(String label, CreateRelationshipRequest request, CommandExecutionAprover createAprover, CommandExecutionAprover updateAprover, TargetAdapter targetAdapter, EdgeAdapter edgeAdapter) {
        super(request.getEditingDomain(), label, CreateHREFLinkCommand.getWorkspaceFiles((List)request.getElementsToEdit()));
        this.request = request;
        this.createAprover = createAprover;
        this.updateAprover = updateAprover;
        this.targetAdapter = targetAdapter;
        this.edgeAdapter = edgeAdapter;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        String to;
        Item item;
        ILink handle;
        MEdge edge = (MEdge)this.request.getNewElement();
        MNode target = edge.getTarget();
        MNode source = edge.getSource();
        String targetPath = WebTargetTypeUtilities.getTargetNodePath(source, target);
        targetPath = WebProvider.externalPathModification(targetPath, WebProvider.getProjectForElement((CommonElement)target));
        this.targetAdapter.setTargetPath(targetPath);
        Boolean isExisting = (Boolean)this.request.getParameter("existing edge");
        if (isExisting == null || !isExisting.booleanValue()) {
            if (source.isRealized()) {
                if (!target.isRealized()) {
                    targetPath = "";
                    this.targetAdapter.setTargetPath(targetPath);
                }
                ArrayList<MEdge> existingEdges = new ArrayList<MEdge>();
                boolean retargettingEdge = false;
                NodeItem sourceItem = (NodeItem)this.request.getParameter("source node item");
                if (sourceItem != null) {
                    ILink existingTarget;
                    List itemTarges = EdgeGeneratorService.getInstance().getItemsEdges((Item)sourceItem);
                    for (MEdge existingEdge : itemTarges) {
                        if (target.equals(existingEdge.getTarget())) continue;
                        retargettingEdge = true;
                        existingEdges.add(existingEdge);
                    }
                    if (!retargettingEdge && (existingTarget = WebProvider.getTarget((IAdaptable)sourceItem)) != null) {
                        ILink newTarget = (ILink)edge.getTarget().getAdapter(ILink.class);
                        boolean bl = retargettingEdge = !existingTarget.equals(newTarget);
                    }
                }
                if (retargettingEdge) {
                    boolean allowRetarget;
                    boolean bl = allowRetarget = !this.askedRetargetAndAffirmative ? WebProvider.allowRetargetDialog() : this.askedRetargetAndAffirmative;
                    if (!allowRetarget) {
                        progressMonitor.setCanceled(true);
                        return CommandResult.newCancelledCommandResult();
                    }
                    this.askedRetargetAndAffirmative = true;
                    this.edgeAdapter.addAllEdge(existingEdges);
                    ILink handle2 = (ILink)sourceItem.getAdapter(ILink.class);
                    if (handle2 != null) {
                        this.updateAprover.setProceed(true);
                    }
                } else if (target.isRealized()) {
                    if (sourceItem == null) {
                        this.createAprover.setProceed(true);
                    } else {
                        this.updateAprover.setProceed(true);
                    }
                }
                int dupIndex = 0;
                EList outputs = source.getOutput();
                for (MEdge possibleDup : outputs) {
                    if (possibleDup == edge || !edge.getType().equals(possibleDup.getType()) || !target.equals(possibleDup.getTarget())) continue;
                    ++dupIndex;
                }
                Property property = DiagramModelFactory.eINSTANCE.createProperty();
                property.setName("web.dup.index");
                property.setValue(Integer.toString(dupIndex));
                edge.getPersistedProperties().add((Object)property);
            }
        } else if (target.isRealized()) {
            SourceReference reference = (SourceReference)this.request.getParameter("source reference");
            Integer dupIndex = (Integer)reference.getParameter("web.dup.index");
            if (dupIndex != null && !WebProvider.updateStringProperty("web.dup.index", dupIndex.toString(), (IPropertyHolder)edge)) {
                Property indexProperty = DiagramModelFactory.eINSTANCE.createProperty();
                indexProperty.setName("web.dup.index");
                indexProperty.setValue(dupIndex.toString());
                edge.getPersistedProperties().add((Object)indexProperty);
            }
        } else if (this.request.getSource() instanceof Item && (handle = (ILink)(item = (Item)this.request.getSource()).getAdapter(ILink.class)) != null && !"".equals(to = AbstractWebProvider.trimQuotes((String)handle.getLinkText()))) {
            boolean updated;
            Path temp = new Path(to);
            String[] segs = temp.segments();
            targetPath = "";
            int i = 0;
            while (i < segs.length) {
                targetPath = String.valueOf(targetPath) + segs[i] + "/";
                ++i;
            }
            if (targetPath.length() > 0 && targetPath.endsWith("/")) {
                targetPath = targetPath.substring(0, targetPath.length() - 1);
            }
            if (!(updated = WebProvider.updateStringProperty("web.path.key", targetPath, (IPropertyHolder)target))) {
                Property property = DiagramModelFactory.eINSTANCE.createProperty();
                property.setName("web.path.key");
                property.setValue(targetPath);
                target.getPersistedProperties().add((Object)property);
            }
            int dupIndex = 0;
            EList outputs = source.getOutput();
            for (MEdge possibleDup : outputs) {
                if (possibleDup == edge || !edge.getType().equals(possibleDup.getType()) || !target.equals(possibleDup.getTarget())) continue;
                ++dupIndex;
            }
            Property property = DiagramModelFactory.eINSTANCE.createProperty();
            property.setName("web.dup.index");
            property.setValue(Integer.toString(dupIndex));
            edge.getPersistedProperties().add((Object)property);
        }
        edge.refreshRealization();
        return CommandResult.newOKCommandResult();
    }
}

