/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.web.internal.edithelper.cmds;

import com.ibm.etools.diagram.model.internal.emf.IPropertyHolder;
import com.ibm.etools.diagram.model.internal.emf.MNode;
import com.ibm.etools.diagram.model.internal.emf.TypedElement;
import com.ibm.etools.model2.diagram.web.internal.providers.WebProvider;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;

public class WebTargetTypeUtilities {
    private WebTargetTypeUtilities() {
    }

    public static final String getTargetNodePath(MNode sourceNode, MNode targetNode) {
        String targetPath = null;
        if (WebProvider.isWebApplicationNode((TypedElement)targetNode)) {
            IProject project = WebProvider.getProjectForNode(targetNode);
            if (project.exists()) {
                Path path = new Path(ComponentUtilities.getServerContextRoot((IProject)project));
                targetPath = path.makeAbsolute().toString();
            }
        } else if (WebProvider.isWebPageNode((TypedElement)targetNode)) {
            String targetPathValue = WebProvider.getStringProperty("web.path.key", (IPropertyHolder)targetNode);
            if (targetPathValue == null || targetPathValue.length() == 0) {
                return "";
            }
            if (WebProvider.isWebPageNode((TypedElement)sourceNode)) {
                Path targetP = new Path(targetPathValue);
                String sourcePathValue = WebProvider.getStringProperty("web.path.key", (IPropertyHolder)sourceNode);
                if (sourcePathValue == null || sourcePathValue.length() == 0) {
                    return "";
                }
                Path sourceP = new Path(sourcePathValue);
                IPath temp = targetP.removeFirstSegments(targetP.matchingFirstSegments((IPath)sourceP));
                targetPath = temp.makeRelative().toString();
            } else {
                targetPath = targetPathValue;
            }
        }
        return targetPath;
    }
}

